#!/bin/sh

if [ $# -ne 1 ]
then 
  if [ $# -lt 3 ]
  then
    if [ $# -gt 5 ]
    then
      echo ""
      echo "Extra parameter found"
    else
      echo ""
      echo "Missing parameter"
    fi
    echo ""
    echo "Usage :"
    echo "$0 <SERVER_ROOT>"
    echo "<SERVER_ROOT> : where Sun ONE Directory Server has been intially installed"
    echo "For example : /var/Sun/mps"
    echo ""
    echo "$0 <SERVER_ROOT> <ADMIN_ID> <PASSWORD>"
    echo "<SERVER_ROOT> : where Sun ONE Directory Server has been intially installed"
    echo "For example : /var/Sun/mps"
    echo "<ADMIN ID> : id for the user admin"
    echo "<PASSWORD> : password for the user admin"
    echo ""
    echo "$0 <SERVER_ROOT> <ADMIN_ID> <PASSWORD> <SERVER UID> <SERVER GROUP>"
    echo "<SERVER_ROOT> : where Sun ONE Directory Server has been intially installed"
    echo "For example : /var/Sun/mps"
    echo "<ADMIN ID> : id for the user admin"
    echo "<PASSWORD> : password for the user admin"
    echo "<SERVER UID> : User Id the server is running as.  Ex: sunusr"
    echo "<SERVER GROUP> : Group Id the server is running as.  Ex: sungrp"
    echo ""
    echo "$0 <SERVER_ROOT> -f <CREDS FILE>"
    echo "<SERVER_ROOT> : where Sun ONE Directory Server has been intially installed"
    echo "For example : /var/Sun/mps"
    echo "<CREDS FILE> : path to a file with the following format:"
    echo "Admin Id: <ADMIN ID>"
    echo "Admin Password: <PASSWORD>"
    echo ""
    echo "<ADMIN ID> : id for the user admin"
    echo "<PASSWORD> : password for the user admin"
    echo ""
    exit 1
  else
   INTERACTIVE=0 
  fi
else
  INTERACTIVE=1
fi

SERVER_ROOT="$1";

LD_LIBRARY_PATH=`pwd`/lib/nsPerl5.005_03/lib/*/CORE
export LD_LIBRARY_PATH
./lib/nsPerl5.005_03/install 1>/dev/null 2>&1
if [ $INTERACTIVE -eq 1 ]
then
   ./lib/nsPerl5.005_03/nsperl upgrade.pl "$SERVER_ROOT"
else
	if [ "$4" = "" -a "$5" = "" ]; then
   	   ./lib/nsPerl5.005_03/nsperl upgrade.pl "$SERVER_ROOT" "$2" "$3"
	else
	   # Used for non root installations where the server is running under
	   # privalenged port 1024.
	   # Requires command line params 4 and 5 (User Id & Group Id of the server)
   	   ./lib/nsPerl5.005_03/nsperl upgrade.pl "$SERVER_ROOT" "$2" "$3" "$4" "$5"
	fi
fi
