# The contents of this file are subject to the Netscape Public License
# Version 1.1 (the "License"); you may not use this file except in
# compliance with the License. You may obtain a copy of the License at
# http://www.mozilla.org/NPL/
#
# Software distributed under the License is distributed on an "AS IS"
# basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
# the License for the specific language governing rights and limitations
# under the License.
#
# The Original Code was released August, 1999.  The Initial Developer
# of the Original Code is Netscape Communications Corporation.  Portions
# created by Netscape are Copyright (C) 1999 Netscape Communications
# Corporation.  All Rights Reserved.
#
# Contributor(s): John M. Kristian <kristian@netscape.com>
# --------------------------------------------------------------------

# Reconfigure Perl for its current location in the filesystem.
# This is a Perl script, but don't run it as a shell command; instead,
# run the `perl` program with the name of this script as a parameter.

use strict;

use Config;
use Cwd qw(cwd);
use File::Basename qw(dirname);
use File::Spec;
use FileHandle;

my $prefixexp = cwd();

sub _fully_qualify # filename
{
    my ($p) = @_;
    return File::Spec->file_name_is_absolute ($p) ? $p
	 : File::Spec->catfile ($prefixexp, $p);
}

my $perl = shift @ARGV;
my $perlpath = _fully_qualify $perl;
my $script   = _fully_qualify $0;
my $executor = File::Spec->catfile (dirname ($0), 'executor.exe');
foreach my $file (@ARGV) {
    if (open PIPE, "|$executor $file") {
	# Bug: can't handle spaces in pathnames
	# A fix would be to use IPC::Open3.
	print PIPE ("source: $script\n", "exec $perlpath\n");
	if (close PIPE) {
	    $perl = $file;
	    next;
	}
    }
    warn "$executor: ".($! or $?);
}

my $reconfigure_pl = File::Spec->catfile (dirname ($0), 'reconfigure.pl');
system ("$perl $reconfigure_pl \"prefixexp=$prefixexp\" \"perlpath=$perlpath\"")
    and die ($! ? "$perl: $!" : "$perl $reconfigure_pl: $?");

my $reconfigure = File::Spec->catfile (File::Spec->curdir(), 'reconfigure');
$reconfigure_pl = _fully_qualify ($reconfigure_pl);
$reconfigure_pl = "\"$reconfigure_pl\"" if ($reconfigure_pl =~ /\s/);
$perlpath       = "\"$perlpath\""       if ($perlpath       =~ /\s/);
print {new FileHandle "> $reconfigure.bat"} (
	"$perlpath $reconfigure_pl ", '"%1" "%2" "%3" "%4" "%5" "%6" "%7" "%8" "%9"', "\n")
    or die;
chmod (0755, "$reconfigure.bat"); # has no apparent effect

print ("You might want to reconfigure these parameters:\n");
foreach my $key (qw(myhostname mydomain perladmin cf_email cf_by)) {
    print ("$reconfigure \"$key=$Config{$key}\"\n");
}

my $test = File::Spec->catfile (dirname ($0), 'test.pl');
system ("$perl $test")
    and die ($! ? "$perl: $!" : "$perl $test: $?");
