<%--
/*
 * %W% %E% 
 * 
 * Copyright 2002-2003 by Sun Microsystems, Inc. All rights reserved.
 * Use is subject to license terms.
 */
--%>
<%@ page language="java"  %>
<%@taglib uri="/WEB-INF/tld/com_iplanet_jato/jato.tld" prefix="jato"%>
<%@taglib uri="/WEB-INF/tld/com_sun_web_ui/cc.tld" prefix="cc"%>
<%@taglib uri="/WEB-INF/lib/sa.tld" prefix="sa"%>

<jato:useViewBean className="com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.revision.RAUpgradeViewBean">

<%
  String isPrivilegedUser = (String)session.getAttribute("storade.privilegedRole");
  if (isPrivilegedUser == null) isPrivilegedUser = "false";

  String isReserved = (String)session.getAttribute("storade.systemReserved");
  if (isReserved == null) isReserved = "false";

  String deviceTypes = (String)session.getAttribute("deviceTypes");
  if (deviceTypes == null) deviceTypes = "";
%>

<sa:primarymasthead name="Masthead" showDefaultPageTitle="withBarOnly"/>
<jato:form name="form" method="post">

<%
  String warningMessageUpgrade = (String)session.getAttribute("warningMessageUpgrade");
  if (warningMessageUpgrade == null) warningMessageUpgrade = "Generate Patch Upgrade Report?";

  String warningMessageClear = (String)session.getAttribute("warningMessageClear");
  if (warningMessageClear == null) warningMessageClear = "Clear Patch Report?";
%>


<script language="javascript">

function confirmRevUpgrade() {
  return confirm("<%=warningMessageUpgrade%>");
}

function confirmClearReport() {
  return confirm("<%=warningMessageClear%>");
}

// Check if the checkbox is for a row for an array
function isArray(itemSelected) {
  var devices     = new Array(<%=deviceTypes%>);
  var index       = "";
  var prefix      = "RAUpgrade.RevisionAnalysisUpgradeReportTable.SelectionCheckbox";
  var prefixIndex = itemSelected.indexOf(prefix);
  if (prefixIndex != -1) {
    index = itemSelected.substr(i+prefix.length-2);
  }
  for (i = 0; i < devices.length; i++) {
    if (index == i+1 && devices[i] == "array") return true;
  }
  return false;
}

// This function will toggle the disabled state of action buttons
// depending on single or multiple selections.
function toggleDisabledState() {
   // do we have the role to activate the menu?
   // Action button and menu names.
   var applyButton   = "RAUpgrade.applyButton";
   var viewVolButton = "RAUpgrade.viewAffectedVolumes";

   // Element name (prefix) of selection checkbox/radiobutton.
   var elementName = "RAUpgrade.RevisionAnalysisUpgradeReportTable.Selection";
  
   // Document form.
   var form = document.form;
 
   // Flag indicating to disable action button and menu options.
   var disabled = true;
   var itemSelected = "-";
 
   var numChecked = 0;
   // Set flags according to single or multiple selections.
   for (i = 0; i < form.elements.length; i++) {
        var e = form.elements[i];

        if (e.name.indexOf(elementName) != -1) {
             if (e.type == "checkbox" && e.checked) {
                disabled = false;
                numChecked++;
                itemSelected = e.name;
            }
        }
   }

   if (numChecked > 1) {
     ccSetButtonDisabled(viewVolButton, "form", true);
   } else {
     ccSetButtonDisabled(viewVolButton, "form", disabled);
     if (!(isArray(itemSelected))) {
       ccSetButtonDisabled(viewVolButton, "form", true);
     }
   }
  
   // Toggle action button disabled state.
   ccSetButtonDisabled(applyButton, "form", disabled);

   // do we have the role to apply a patch
   if (!('true' == '<%=isPrivilegedUser%>')) {
     ccSetButtonDisabled(applyButton, "form", true);
   }

   // the system is reserved, cannot apply a patch
   if ('true' == '<%=isReserved%>') {
     ccSetButtonDisabled(applyButton, "form", true);
   }

}
</script>

<cc:spacer name="spacer" height="20" newline="true"/>

<div class="ConMgn">
<!-- Page Inline Help -->
<table>
 <tr>
  <td>
   <cc:helpinline type="page">
    <cc:text name="StaticText" bundleID="appBundle" defaultValue="ra.help.text.update" />
   </cc:helpinline>
  </td>
 </tr>
</table>
</div>

<div class="ConMgn">

<cc:spacer name="spacer" height="15" newline="true"/>

<cc:button name="generateRevAnalysisUpgradeReportButton" bundleID="appBundle" 
     defaultValue="button.generateRevAnalysisReport"
     title="button.generateRevAnalysisReport"
     type="primary"
     dynamic="true" 
     onClick="javascript: return confirmRevUpgrade();" />

<jato:content name="ClearButtonSection">

  <cc:button name="clearRevAnalysisUpgradeReportButton" bundleID="appBundle" 
       defaultValue="button.clearRevAnalysisReport"
       title="button.clearRevAnalysisReport"
       type="primary"
       dynamic="true" 
       onClick="javascript: return confirmClearReport();" />

</jato:content>

</div>

<cc:spacer name="spacer" height="15" newline="true"/>

<jato:content name="RevisionAnalysisReportSection">

  <div class="ConMgn">
  <cc:text name="ReportText" bundleID="appBundle" defaultValue="assets.revision.upgrade.report"/>
  </div>

  <cc:spacer name="spacer" height="15" newline="true"/>

  <cc:actiontable
      name="RevisionAnalysisUpgradeReportTable" 
      bundleID="appBundle" 
      title="assets.revision.upgrade.table.title" 
      summary="assets.revision.upgrade.table.summary" 
      empty="assets.revision.upgrade.table.empty"
      showAdvancedSortingIcon="false" 
      showLowerActions="true" 
      showPaginationControls="true" 
      showPaginationIcon="true" 
      showSelectionIcons="true" 
      selectionType="multiple"
      selectionJavascript="toggleDisabledState()"
      page="1" />

</jato:content>

<jato:content name="noRevisionAnalysisReportSection">

  <div class="ConMgn">
  <cc:text name="NoReportText" bundleID="appBundle" defaultValue="assets.revision.upgrade.noreport"/>
  </div>

</jato:content>

</jato:form>
</jato:useViewBean>


