/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.revision;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestManager;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.ContainerViewBase;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.iplanet.jato.view.html.Option;
import com.iplanet.jato.view.html.OptionList;
import com.iplanet.jato.view.html.SelectableGroup;
import com.sun.netstorage.mgmt.fm.storade.schema.Value;
import com.sun.netstorage.mgmt.fm.storade.schema.revision.RevisionCheckResultDocument;
import com.sun.netstorage.mgmt.fm.storade.schema.revision.RunRevisionCheckResultDocument;
import com.sun.netstorage.mgmt.fm.storade.ui.common.UIMastHeadViewBeanBase;
import com.sun.netstorage.mgmt.fm.storade.ui.util.Connection;
import com.sun.netstorage.mgmt.fm.storade.ui.util.LocalizeUtil;
import com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.revision.Getter;
import com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.revision.Setter;
import com.sun.web.ui.model.CCPageTitleModel;
import com.sun.web.ui.model.CCPageTitleModelInterface;
import com.sun.web.ui.model.CCPropertySheetModel;
import com.sun.web.ui.model.CCPropertySheetModelInterface;
import com.sun.web.ui.view.html.CCHref;
import com.sun.web.ui.view.html.CCOption;
import com.sun.web.ui.view.pagetitle.CCPageTitle;
import com.sun.web.ui.view.propertysheet.CCPropertySheet;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;

public class RevisionCheckViewBean
extends UIMastHeadViewBeanBase {
    public static final String PAGE_NAME = "RevisionCheck";
    public static final String DEFAULT_DISPLAY_URL = "/jsp/revision/RevisionCheck.jsp";
    public static final String CHILD_PROPERTYSHEET = "PropertySheet";
    public static final String CHILD_PAGETITLE = "PageTitle";
    private CCPropertySheetModel propertySheetModel = new CCPropertySheetModel(RequestManager.getRequestContext().getServletContext(), "/xml/propertysheet/RevisionCheckPropertySheet.xml");
    private CCPageTitleModel pageTitleModel = new CCPageTitleModel(RequestManager.getRequestContext().getServletContext(), "/xml/pagetitle/RevisionCheckPageTitle.xml");
    public static final String CHILD_HOSTHREF = "HostHref";
    public static final String HOSTID_KEY = "hostID";
    private OptionList hosts = new OptionList();
    private OptionList matrice = new OptionList();
    private OptionList modules = new OptionList();
    public static final String sccs_id = "%Z%%M% %I%     %E% SMI";
    static /* synthetic */ Class class$com$sun$web$ui$view$propertysheet$CCPropertySheet;
    static /* synthetic */ Class class$com$sun$web$ui$view$pagetitle$CCPageTitle;
    static /* synthetic */ Class class$com$sun$web$ui$view$html$CCHref;

    public RevisionCheckViewBean() {
        super(PAGE_NAME, DEFAULT_DISPLAY_URL);
    }

    public void setRequestContext(RequestContext ctx) {
        super.setRequestContext(ctx);
        this.initModel();
    }

    protected void subRegisterChildren() {
        this.registerChild(CHILD_PROPERTYSHEET, class$com$sun$web$ui$view$propertysheet$CCPropertySheet == null ? (class$com$sun$web$ui$view$propertysheet$CCPropertySheet = RevisionCheckViewBean.class$("com.sun.web.ui.view.propertysheet.CCPropertySheet")) : class$com$sun$web$ui$view$propertysheet$CCPropertySheet);
        this.propertySheetModel.registerChildren((ContainerViewBase)this);
        this.registerChild(CHILD_PAGETITLE, class$com$sun$web$ui$view$pagetitle$CCPageTitle == null ? (class$com$sun$web$ui$view$pagetitle$CCPageTitle = RevisionCheckViewBean.class$("com.sun.web.ui.view.pagetitle.CCPageTitle")) : class$com$sun$web$ui$view$pagetitle$CCPageTitle);
        this.pageTitleModel.registerChildren((ContainerViewBase)this);
        this.registerChild(CHILD_HOSTHREF, class$com$sun$web$ui$view$html$CCHref == null ? (class$com$sun$web$ui$view$html$CCHref = RevisionCheckViewBean.class$("com.sun.web.ui.view.html.CCHref")) : class$com$sun$web$ui$view$html$CCHref);
    }

    protected View subCreateChild(String name) {
        if (name.equals(CHILD_PROPERTYSHEET)) {
            CCPropertySheet child = new CCPropertySheet((ContainerView)this, (CCPropertySheetModelInterface)this.propertySheetModel, name);
            return child;
        }
        if (name.equals(CHILD_PAGETITLE)) {
            CCPageTitle child = new CCPageTitle((ContainerView)this, (CCPageTitleModelInterface)this.pageTitleModel, name);
            return child;
        }
        if (name.equals(CHILD_HOSTHREF)) {
            CCHref child = new CCHref((ContainerView)this, name, null);
            return child;
        }
        if (this.propertySheetModel.isChildSupported(name)) {
            if ("HostValue".equals(name)) {
                SelectableGroup list = (SelectableGroup)this.propertySheetModel.createChild((View)this, name);
                list.setOptions(this.hosts);
                return list;
            }
            if ("MatrixValue".equals(name)) {
                SelectableGroup list = (SelectableGroup)this.propertySheetModel.createChild((View)this, name);
                list.setOptions(this.matrice);
                return list;
            }
            if ("RevModulesValue".equals(name)) {
                SelectableGroup list = (SelectableGroup)this.propertySheetModel.createChild((View)this, name);
                list.setOptions(this.modules);
                return list;
            }
            return this.propertySheetModel.createChild((View)this, name);
        }
        if (this.pageTitleModel.isChildSupported(name)) {
            return this.pageTitleModel.createChild((View)this, name);
        }
        return null;
    }

    private void initModel() {
        this.pageTitleModel.setValue("PageButtonRun", (Object)"button.run");
        this.pageTitleModel.setValue("PageButtonCancel", (Object)"button.cancel");
    }

    private void setHosts(Value[] values) {
        CCOption[] options = new CCOption[values.length];
        int i = 0;
        while (i < values.length) {
            options[i] = new CCOption(values[i].getStringValue(), values[i].getID());
            ++i;
        }
        this.hosts = new OptionList((Option[])options);
    }

    private void setMatrice(Value[] values, Locale locale) {
        CCOption[] options = new CCOption[values.length];
        int i = 0;
        while (i < values.length) {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
            Date timeObj = new Date();
            try {
                timeObj = formatter.parse(values[i].getStringValue());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            DateFormat printer = DateFormat.getDateInstance(3, locale);
            String timeStr = printer.format(timeObj);
            String displayName = values[i].getID() + " -- " + LocalizeUtil.getLocalizedString("revision.created", new String[]{timeStr}, locale);
            options[i] = new CCOption(displayName, values[i].getID());
            ++i;
        }
        this.matrice = new OptionList((Option[])options);
    }

    private void setModules(Value[] values, Locale locale) {
        CCOption[] options = new CCOption[values.length + 1];
        int i = 0;
        while (i < values.length) {
            String localizedModuleName = LocalizeUtil.getLocalizedString("com.sun.netstorage.mgmt.fm.storade.ui.resources.Revision", values[i].getID() + ".description", locale);
            options[i + 1] = new CCOption(localizedModuleName, values[i].getID());
            ++i;
        }
        options[0] = new CCOption("revModules.all", "*" + this.getModulesStr(values));
        this.modules = new OptionList((Option[])options);
    }

    private String getModulesStr(Value[] values) {
        String forAll = "";
        int i = 0;
        while (i < values.length) {
            forAll = forAll + values[i].getID() + "|";
            ++i;
        }
        return forAll;
    }

    private String bt(String in) {
        if ("Y".equals(in) || "1".equals(in)) {
            return "true";
        }
        return "false";
    }

    private void loadPropertySheetModel(CCPropertySheetModel model, String hostID, Locale locale) {
        model.clear();
        RevisionCheckResultDocument.RevisionCheckResult result = Getter.getRevisionCheckResultDocument(hostID).getRevisionCheckResult();
        this.setAlarmSummary(result.getAlarmSummary());
        Value[] hosts_v = result.getHosts().getVALUEArray();
        Value[] matrice_v = result.getRevMatrice().getVALUEArray();
        Value[] modules_v = result.getRevModules().getVALUEArray();
        this.setHosts(hosts_v);
        this.setMatrice(matrice_v, locale);
        this.setModules(modules_v, locale);
        model.setValue("RevModulesValue", (Object)("*" + this.getModulesStr(modules_v)));
        if (hostID != null) {
            model.setValue("HostValue", (Object)hostID);
        }
    }

    public void beginDisplay(DisplayEvent event) {
        HttpServletRequest request = RequestManager.getRequestContext().getRequest();
        Locale locale = request.getLocale();
        String hostID = this.getHostID();
        this.loadPropertySheetModel(this.propertySheetModel, hostID, locale);
        if (hostID != null) {
            this.setPageSessionAttribute(HOSTID_KEY, (Serializable)((Object)hostID));
        }
        try {
            super.beginDisplay(event);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void handleHostHrefRequest(RequestInvocationEvent event) {
        String hostID = (String)this.getDisplayFieldValue("HostValue");
        String url = "/" + Connection.getAppName() + "/revision/RevisionCheck?" + HOSTID_KEY + "=" + this.urlencode(hostID);
        try {
            this.getRequestContext().getResponse().sendRedirect(url);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void handlePageButtonRunRequest(RequestInvocationEvent event) {
        HttpServletRequest request = RequestManager.getRequestContext().getRequest();
        String hostID = (String)this.getDisplayFieldValue("HostValue");
        String matrix = (String)this.getDisplayFieldValue("MatrixValue");
        String[] modules = request.getParameterValues("RevisionCheck.RevModulesValue");
        String email = (String)this.getDisplayFieldValue("EmailAddressValue");
        String modulesStr = "";
        int i = 0;
        while (i < modules.length) {
            if (modules[i].startsWith("*")) {
                modulesStr = modules[i].substring(1);
                break;
            }
            modulesStr = modulesStr + modules[i] + "|";
            ++i;
        }
        try {
            String setterCommand = "host=" + this.urlencode(hostID) + "&matrix=" + this.urlencode(matrix) + "&email=" + this.urlencode(email) + "&modules=" + this.urlencode(modulesStr);
            RunRevisionCheckResultDocument.RunRevisionCheckResult result = Setter.runRevisionCheck(setterCommand);
            if (result == null) {
                this.setInlineAlert("error", "summary.runRevisionCheck", null, "error.internal", null);
                String url = "/" + Connection.getAppName() + "/revision/RevisionCheck";
                event.getRequestContext().getResponse().sendRedirect(url);
            } else if (result.getERROR() != null) {
                this.setInlineAlert("error", "summary.runRevisionCheck", null, "error.revision." + result.getERROR().getNo(), new String[]{result.getERROR().getStringValue()});
                String url = "/" + Connection.getAppName() + "/revision/RevisionCheck";
                event.getRequestContext().getResponse().sendRedirect(url);
            } else {
                String url = "/" + Connection.getAppName() + "/revision/RevisionReport?hostID=" + this.urlencode(hostID);
                event.getRequestContext().getResponse().sendRedirect(url);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void handlePageButtonCancelRequest(RequestInvocationEvent event) {
        String url = "/" + Connection.getAppName() + "/reports/Assets";
        try {
            this.getRequestContext().getResponse().sendRedirect(url);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private String getHostID() {
        HttpServletRequest request = RequestManager.getRequestContext().getRequest();
        String hostID = request.getParameter(HOSTID_KEY);
        if (hostID == null) {
            hostID = (String)this.getPageSessionAttribute(HOSTID_KEY);
        }
        return hostID;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        PAGE_NAME = PAGE_NAME;
        DEFAULT_DISPLAY_URL = DEFAULT_DISPLAY_URL;
        CHILD_PROPERTYSHEET = CHILD_PROPERTYSHEET;
        CHILD_PAGETITLE = CHILD_PAGETITLE;
        CHILD_HOSTHREF = CHILD_HOSTHREF;
        HOSTID_KEY = HOSTID_KEY;
        sccs_id = sccs_id;
    }
}

