/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.reports;

import com.sun.netstorage.mgmt.fm.storade.schema.Event;
import com.sun.netstorage.mgmt.fm.storade.schema.asset.Rack;
import com.sun.netstorage.mgmt.fm.storade.schema.asset.RackResultDocument;
import com.sun.netstorage.mgmt.fm.storade.schema.asset.Tray;
import com.sun.netstorage.mgmt.fm.storade.ui.common.AlarmConstants;
import com.sun.netstorage.mgmt.fm.storade.ui.model.ActionTableModel;
import com.sun.netstorage.mgmt.fm.storade.ui.util.DelimUtil;
import com.sun.netstorage.mgmt.fm.storade.ui.util.DeviceUtil;
import com.sun.netstorage.mgmt.fm.storade.ui.util.StringUtil;
import com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.reports.Getter;
import com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.reports.Setter;
import com.sun.web.ui.view.alarm.CCAlarmObject;
import java.util.ArrayList;
import java.util.Locale;

public class RackDataHelper {
    private static final String[] VOL_VERIFY_ARRAYS = new String[]{"t3", "6020", "6120"};
    private static String systemID = null;
    private static String summaryID = null;

    private RackDataHelper() {
    }

    public static String getSystemID() {
        RackResultDocument.RackResult result;
        if ((systemID == null || "".equals(systemID)) && (result = Getter.getRack()) != null) {
            String devType;
            int index;
            systemID = result.getStorageSystem().getSystemID();
            if (systemID == null || "".equals(systemID)) {
                return systemID;
            }
            String devName = DeviceUtil.getDeviceName(RackDataHelper.getSummaryID());
            if (devName != null && (index = devName.indexOf(46)) != -1 && !systemID.startsWith(devType = devName.substring(0, index + 1))) {
                systemID = devType + systemID;
            }
        }
        return systemID;
    }

    public static String getSummaryID() {
        RackResultDocument.RackResult result;
        if (summaryID == null && (result = Getter.getRack()) != null) {
            summaryID = result.getStorageSystem().getSUMMARY();
        }
        return summaryID;
    }

    public static String getSummaryID(RackResultDocument.RackResult result) {
        String summaryID = null;
        if (result != null) {
            summaryID = result.getStorageSystem().getSUMMARY();
        }
        return summaryID;
    }

    private static void addAlarms(ActionTableModel rackModel, Event[] events, int rackID, Tray tray) {
        String key;
        int severity = 0;
        String fullKey = key = tray.getKey();
        if (key != null) {
            int index = key.indexOf(58);
            if (index != -1) {
                key = key.substring(index + 1);
            }
            if (events != null) {
                int i = 0;
                while (i < events.length) {
                    if (events[i].getKey().equals(key)) {
                        int s = Integer.parseInt(events[i].getSeverity());
                        String unit = tray.getUnit();
                        if (unit != null && !unit.equals("")) {
                            String topic = events[i].getTopic();
                            if (topic != null) {
                                int index2 = topic.indexOf(46);
                                if (index2 != -1) {
                                    topic = topic.substring(index2 + 1);
                                }
                                if (!topic.startsWith("u") && "u1".equals(unit)) {
                                    severity = Math.max(severity, s);
                                } else if (topic.startsWith(unit)) {
                                    severity = Math.max(severity, s);
                                }
                            }
                        } else {
                            severity = Math.max(severity, s);
                        }
                    }
                    ++i;
                }
            }
        }
        if (severity > 0) {
            CCAlarmObject alarm = AlarmConstants.getSeverityObject(Integer.MIN_VALUE);
            if (severity == 1) {
                alarm = AlarmConstants.getSeverityObject(1);
            } else if (severity == 2) {
                alarm = AlarmConstants.getSeverityObject(2);
            } else if (severity == 3) {
                alarm = AlarmConstants.getSeverityObject(3);
            }
            rackModel.setValue("alarms_" + rackID, alarm);
            String str = DelimUtil.compose("AssetAlarmLink", new String[]{fullKey, tray.getName()});
            rackModel.setValue("alarmHREF_" + rackID, str);
        } else {
            rackModel.setValue("alarms_" + rackID, null);
            rackModel.setValue("alarmHREF_" + rackID, null);
        }
    }

    private static String buildTrayID(int index, Locale locale) {
        return "Tray " + index;
    }

    private static String buildTrayID(String name, Locale locale) {
        int index = name.indexOf(32);
        if (index != -1) {
            String s1 = name.substring(0, index);
            String s2 = name.substring(index);
            try {
                int i = Integer.parseInt(s2.trim());
                name = s1.trim() + " " + i;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return name;
    }

    public static void populateRackTableModel(int rackIndex, RackResultDocument.RackResult result, ActionTableModel rackModel, Locale locale) {
        Event[] events = result.getALARMS().getEventArray();
        ArrayList<String> keysList = new ArrayList<String>();
        Rack[] racks = result.getStorageSystem().getRackArray();
        if (racks != null) {
            int i = 0;
            while (i < racks.length) {
                int id = -1;
                try {
                    id = Integer.parseInt(racks[i].getID());
                }
                catch (NumberFormatException ex) {
                    ex.printStackTrace();
                }
                if (rackIndex == id) {
                    int trayMax = racks[i].getTrayMax().intValue();
                    Tray[] trays = racks[i].getTrayArray();
                    if (trays != null) {
                        int lastTray = -1;
                        int k = 0;
                        while (k < trays.length) {
                            lastTray = Math.max(trays[k].getOrder().intValue(), lastTray);
                            ++k;
                        }
                        int index = 0;
                        int j = trayMax;
                        while (j >= 1) {
                            boolean found = false;
                            if (index != 0) {
                                rackModel.appendRow();
                            }
                            int k2 = 0;
                            while (k2 < trays.length) {
                                int trayID = trays[k2].getOrder().intValue();
                                if ((trayID -= lastTray - trayMax) == j) {
                                    ++index;
                                    rackModel.setValue("trayID_" + id, RackDataHelper.buildTrayID(trays[k2].getTrayID(), locale));
                                    rackModel.setValue("componentType_" + id, trays[k2].getDisplayType());
                                    String key = trays[k2].getKey();
                                    if (key != null) {
                                        rackModel.setValue("componentName_" + id, trays[k2].getName());
                                        rackModel.setValue("componentNoHREF_" + id, null);
                                        rackModel.setValue("componentHREF_" + id, trays[k2].getKey());
                                    } else {
                                        rackModel.setValue("componentName_" + id, null);
                                        rackModel.setValue("componentNoHREF_" + id, trays[k2].getName());
                                        rackModel.setValue("componentHREF_" + id, null);
                                    }
                                    keysList.add(trays[k2].getKey());
                                    rackModel.setValue("unit_" + id, StringUtil.toBlank(trays[k2].getUnit()));
                                    RackDataHelper.addAlarms(rackModel, events, id, trays[k2]);
                                    found = true;
                                    break;
                                }
                                ++k2;
                            }
                            if (!found) {
                                rackModel.setValue("trayID_" + id, RackDataHelper.buildTrayID(j, locale));
                                rackModel.setValue("componentType_" + id, "-");
                                rackModel.setValue("componentName_" + id, null);
                                rackModel.setValue("componentNoHREF_" + id, "-");
                                rackModel.setValue("unit_" + id, "-");
                                rackModel.setValue("alarms_" + id, null);
                                rackModel.setValue("alarmHREF_" + id, null);
                            }
                            --j;
                        }
                    }
                }
                ++i;
            }
        }
        String[] keys = new String[keysList.size()];
        keysList.toArray(keys);
        rackModel.setKeys(keys);
    }

    public static int countExpansionRacks(RackResultDocument.RackResult result) {
        Rack[] racks;
        int nbrExpansionUnits = 0;
        if (result != null && (racks = result.getStorageSystem().getRackArray()) != null) {
            nbrExpansionUnits = racks.length - 1;
        }
        return nbrExpansionUnits;
    }

    public static void setNote(String key, String text) {
        Setter.setNote(key, text);
    }

    static boolean isVolVerifyNeeded(RackResultDocument.RackResult result) {
        if (result == null) {
            return false;
        }
        Rack[] racks = result.getStorageSystem().getRackArray();
        if (racks != null) {
            int i = 0;
            while (i < racks.length) {
                Tray[] trays = racks[i].getTrayArray();
                if (trays != null) {
                    int k = 0;
                    while (k < trays.length) {
                        String key = trays[k].getKey();
                        String type = DeviceUtil.getDeviceType(key);
                        int l = 0;
                        while (l < VOL_VERIFY_ARRAYS.length) {
                            if (VOL_VERIFY_ARRAYS[l].equals(type)) {
                                return true;
                            }
                            ++l;
                        }
                        ++k;
                    }
                }
                ++i;
            }
        }
        return false;
    }
}

