/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.reports;

import com.sun.netstorage.mgmt.fm.storade.schema.asset.PERFORMANCEDEVICE;
import com.sun.netstorage.mgmt.fm.storade.schema.asset.PERFORMANCEDEVICES;
import com.sun.netstorage.mgmt.fm.storade.schema.asset.PERFORMANCEHOUR;
import com.sun.netstorage.mgmt.fm.storade.schema.asset.PERFORMANCEUNIT;
import com.sun.netstorage.mgmt.fm.storade.schema.asset.PerformanceResultDocument;
import com.sun.netstorage.mgmt.fm.storade.ui.util.ChartData;
import com.sun.netstorage.mgmt.fm.storade.ui.util.ChartDataCollection;
import com.sun.netstorage.mgmt.fm.storade.ui.util.ChartGenerator;
import com.sun.netstorage.mgmt.fm.storade.ui.util.DateUtil;
import com.sun.netstorage.mgmt.fm.storade.ui.util.HourlyChartData;
import com.sun.netstorage.mgmt.fm.storade.ui.util.HourlyChartDataCollection;
import com.sun.web.ui.model.CCActionTableModel;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;

public class PerformanceDataHelper {
    static final String DATE = "dateStr";
    static final String DEVICE = "deviceStr";
    static final String UNIT = "unitStr";
    static final String READ = "readStr";
    static final String WRITE = "writeStr";
    static final String READCHART = "readchartStr";
    static final String AM = " AM";
    static final String PM = " PM";
    static final String CURRENT_VALUE = " Current Value";
    static final String HOURLY_VIEW = " Hourly View";
    static final String HOURS = "Hours";
    static final String HOUR = "Hour";
    static final String VOLUMES = "Volumes";
    static final String VOLUME = "Volume ";
    static final String PORT = "Port ";
    static final String PORTS = "Ports";
    static final String PORT_VOLUME = "Port/Volume";
    static final String PORTS_VOLUMES = "Ports/Volumes";
    static final String DASH = " - ";
    static final String UTILIZATION_PERCENTAGE = "Utilization %";
    static final String MB_PER_SECOND = "Avg. MB/Second";
    static final String MEGABYTES = "Megabytes";
    static final String IO_PER_SECOND = "Avg. IO/Second";
    static final String DSP = "dsp";
    static final String ARRAY = "array";
    static final String PNG = ".png";
    static final String IO = "I/O";
    static final String TOTAL = "total";
    static final String RACK_LABEL = "SE-6920";

    private PerformanceDataHelper() {
    }

    public static String getName(PerformanceResultDocument.PerformanceResult result) {
        String name;
        block2: {
            name = null;
            if (result == null) {
                return null;
            }
            PERFORMANCEDEVICES devices = result.getDEVICES();
            PERFORMANCEDEVICE[] device = devices.getDEVICEArray();
            if (device == null) break block2;
            int i = 0;
            if (i < device.length) {
                String deviceName;
                name = deviceName = device[i].getName();
            }
        }
        return name;
    }

    public static String[] getDevices(PerformanceResultDocument.PerformanceResult result) {
        String[] devices;
        HashSet<String> s = new HashSet<String>();
        if (result != null) {
            devices = result.getDEVICES();
            PERFORMANCEDEVICE[] device = devices.getDEVICEArray();
            int i = 0;
            while (i < device.length) {
                String deviceName = device[i].getName();
                s.add(deviceName);
                ++i;
            }
        }
        devices = new String[s.size()];
        s.toArray(devices);
        return devices;
    }

    public static String[] getVolumes(PerformanceResultDocument.PerformanceResult result) {
        HashSet<String> s = new HashSet<String>();
        if (result != null) {
            PERFORMANCEDEVICES devices = result.getDEVICES();
            PERFORMANCEDEVICE[] device = devices.getDEVICEArray();
            int i = 0;
            while (i < device.length) {
                PERFORMANCEHOUR[] hour = device[i].getHOURArray();
                if (hour != null) {
                    int j = 0;
                    while (j < hour.length) {
                        PERFORMANCEUNIT[] unit = hour[j].getUnitArray();
                        if (unit != null) {
                            int k = 0;
                            while (k < unit.length) {
                                String unitName = unit[k].getName();
                                s.add(unitName);
                                ++k;
                            }
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        String[] volumes = new String[s.size()];
        s.toArray(volumes);
        return volumes;
    }

    public static void populatePerformanceTable(boolean withDevice, PerformanceResultDocument.PerformanceResult result, Properties deviceN, Properties volume, CCActionTableModel tableModel, String layout, String xAxisLabel, String yAxisLabel, String reportType, String fullImageDir, Locale locale) {
        if (result == null) {
            return;
        }
        boolean rowAdded = false;
        PERFORMANCEDEVICES devices = result.getDEVICES();
        PERFORMANCEDEVICE[] device = devices.getDEVICEArray();
        HashMap<String, HourlyChartDataCollection> hss = new HashMap<String, HourlyChartDataCollection>();
        if (device != null) {
            int i = 0;
            while (i < device.length) {
                String deviceName = device[i].getName();
                if (deviceN == null || deviceN != null && deviceN.containsKey(deviceName)) {
                    PERFORMANCEHOUR[] hour = device[i].getHOURArray();
                    HourlyChartDataCollection hcdc = new HourlyChartDataCollection(deviceName, HOURS, IO);
                    if (hour != null) {
                        rowAdded = false;
                        int j = 0;
                        while (j < hour.length) {
                            String hourValue = hour[j].getValue();
                            ChartDataCollection cdc = new ChartDataCollection(hourValue.toString(), PORTS, IO);
                            if (hourValue == null || !hourValue.toString().endsWith(TOTAL)) {
                                try {
                                    hourValue = DateUtil.toString1(DateUtil.toDate1(hourValue.toString()), locale);
                                }
                                catch (Exception ex) {
                                    // empty catch block
                                }
                            }
                            PERFORMANCEUNIT[] unit = hour[j].getUnitArray();
                            if (unit != null) {
                                int k = 0;
                                while (k < unit.length) {
                                    int volumeSize = 0;
                                    if (volume != null) {
                                        volumeSize = volume.size();
                                    }
                                    if (volume == null || volumeSize == 0 || volume != null && volume.containsKey(unit[k].getName())) {
                                        Object readValue = unit[k].getREAD();
                                        try {
                                            readValue = new Float(readValue.toString());
                                        }
                                        catch (Exception ex) {
                                            ex.printStackTrace();
                                        }
                                        Object writeValue = unit[k].getWRITE();
                                        try {
                                            writeValue = new Float(writeValue.toString());
                                        }
                                        catch (Exception ex) {
                                            ex.printStackTrace();
                                        }
                                        if (rowAdded) {
                                            tableModel.appendRow();
                                        }
                                        String untName = null;
                                        untName = withDevice && "graphical".equalsIgnoreCase(layout) ? deviceName + "_" + unit[k].getName() : unit[k].getName();
                                        ChartData cd = new ChartData(untName, deviceName, hourValue);
                                        cd.setData(readValue, writeValue);
                                        cdc.setChartData(cd);
                                    }
                                    ++k;
                                }
                            }
                            HourlyChartData hcd = new HourlyChartData(hourValue);
                            hcd.setData(cdc);
                            hcdc.setHourlyChartData(hcd);
                            ++j;
                        }
                    }
                    hss.put(deviceName, hcdc);
                }
                ++i;
            }
        }
        if ("graphical".equalsIgnoreCase(layout)) {
            PerformanceDataHelper.fillChartRow(tableModel, hss, xAxisLabel, yAxisLabel, reportType, withDevice, fullImageDir);
        } else {
            PerformanceDataHelper.fillTextRow(tableModel, hss, withDevice);
        }
    }

    private static void fillChartRow(CCActionTableModel tableModel, HashMap chartDataCollection, String xAxisLabel, String yAxisLabel, String reportType, boolean withDevice, String fullImageDir) {
        String VAR = fullImageDir + "/currentreadchart";
        String OTHER_READ = "/storade/images/currentreadchart";
        String xAxisLabelM = PORTS_VOLUMES;
        String xAxisLabelS = PORT_VOLUME;
        String yAxisLabelM = yAxisLabel;
        String chartTitle = "";
        String deviceName = "";
        Iterator chartHrDataIter = chartDataCollection.keySet().iterator();
        while (chartHrDataIter.hasNext()) {
            deviceName = (String)chartHrDataIter.next();
            HourlyChartDataCollection chHrData = (HourlyChartDataCollection)chartDataCollection.get(deviceName);
            if (withDevice) {
                deviceName = RACK_LABEL;
            }
            chartTitle = deviceName + DASH;
            chartTitle = "C".equalsIgnoreCase(reportType) ? chartTitle + CURRENT_VALUE : chartTitle + HOURLY_VIEW;
            if (chartTitle.startsWith(DSP)) {
                xAxisLabelM = HOURS;
                if ("C".equalsIgnoreCase(reportType)) {
                    xAxisLabelM = PORTS;
                }
                xAxisLabelS = PORT;
            } else if (chartTitle.startsWith(ARRAY)) {
                xAxisLabelM = HOURS;
                if ("C".equalsIgnoreCase(reportType)) {
                    xAxisLabelM = VOLUMES;
                }
                xAxisLabelS = VOLUME;
            }
            if ("io".equals(yAxisLabel)) {
                yAxisLabelM = IO_PER_SECOND;
                continue;
            }
            if ("meg".equals(yAxisLabel)) {
                yAxisLabelM = MB_PER_SECOND;
                continue;
            }
            if ("replication".equals(yAxisLabel)) {
                yAxisLabelM = MEGABYTES;
                xAxisLabelM = VOLUMES;
                continue;
            }
            yAxisLabelM = xAxisLabelS + UTILIZATION_PERCENTAGE;
        }
        if ("C".equalsIgnoreCase(reportType)) {
            ChartGenerator.generateBarChart(chartDataCollection, null, chartTitle, xAxisLabelM, yAxisLabelM, VAR + deviceName + PNG, withDevice);
        } else {
            ChartGenerator.generateLineChart(chartDataCollection, null, chartTitle, xAxisLabelM, yAxisLabelM, VAR + deviceName + PNG);
        }
        tableModel.appendRow();
        tableModel.setValue(READCHART, (Object)(OTHER_READ + deviceName + PNG));
    }

    private static void fillTextRow(CCActionTableModel tableModel, HashMap chartDataCollection, boolean withDevice) {
        Iterator chartHrDataIter = chartDataCollection.keySet().iterator();
        while (chartHrDataIter.hasNext()) {
            String deviceName = (String)chartHrDataIter.next();
            HourlyChartDataCollection chHrData = (HourlyChartDataCollection)chartDataCollection.get(deviceName);
            Iterator chrtDataIter = chHrData.getHours();
            while (chrtDataIter.hasNext()) {
                Object key = chrtDataIter.next();
                HourlyChartData hcd = chHrData.getHourlyChartData(key);
                Iterator listDataIter = hcd.getHourlyChartData(key);
                while (listDataIter.hasNext()) {
                    ChartData chrtData = (ChartData)listDataIter.next();
                    tableModel.appendRow();
                    if (withDevice) {
                        tableModel.setValue(DEVICE, (Object)deviceName);
                    }
                    tableModel.setValue(DATE, chrtData.getUnitHourValue());
                    tableModel.setValue(UNIT, (Object)chrtData.getUnitName());
                    tableModel.setValue(READ, chrtData.getUnitReadValue());
                    tableModel.setValue(WRITE, chrtData.getUnitWriteValue());
                }
            }
        }
    }

    static {
        DATE = DATE;
        DEVICE = DEVICE;
        UNIT = UNIT;
        READ = READ;
        WRITE = WRITE;
        READCHART = READCHART;
        AM = AM;
        PM = PM;
        CURRENT_VALUE = CURRENT_VALUE;
        HOURLY_VIEW = HOURLY_VIEW;
        HOURS = HOURS;
        HOUR = HOUR;
        VOLUMES = VOLUMES;
        VOLUME = VOLUME;
        PORT = PORT;
        PORTS = PORTS;
        PORT_VOLUME = PORT_VOLUME;
        PORTS_VOLUMES = PORTS_VOLUMES;
        DASH = DASH;
        UTILIZATION_PERCENTAGE = UTILIZATION_PERCENTAGE;
        MB_PER_SECOND = MB_PER_SECOND;
        MEGABYTES = MEGABYTES;
        IO_PER_SECOND = IO_PER_SECOND;
        DSP = DSP;
        ARRAY = ARRAY;
        PNG = PNG;
        IO = IO;
        TOTAL = TOTAL;
        RACK_LABEL = RACK_LABEL;
    }
}

