/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.reports;

import com.sun.netstorage.mgmt.fm.storade.schema.asset.ARPResultDocument;
import com.sun.netstorage.mgmt.fm.storade.schema.asset.AssetResultDocument;
import com.sun.netstorage.mgmt.fm.storade.schema.asset.AssetsResultDocument;
import com.sun.netstorage.mgmt.fm.storade.schema.asset.ComponentResultDocument;
import com.sun.netstorage.mgmt.fm.storade.schema.asset.DSPNetworkConfigResultDocument;
import com.sun.netstorage.mgmt.fm.storade.schema.asset.ExceptionReportResultDocument;
import com.sun.netstorage.mgmt.fm.storade.schema.asset.MonitoringResultDocument;
import com.sun.netstorage.mgmt.fm.storade.schema.asset.PerformanceResultDocument;
import com.sun.netstorage.mgmt.fm.storade.schema.asset.RESERVESTATUSDocument;
import com.sun.netstorage.mgmt.fm.storade.schema.asset.RackResultDocument;
import com.sun.netstorage.mgmt.fm.storade.schema.asset.SECompareResultDocument;
import com.sun.netstorage.mgmt.fm.storade.schema.asset.SEListArrayResultDocument;
import com.sun.netstorage.mgmt.fm.storade.schema.asset.SwitchStatsResultDocument;
import com.sun.netstorage.mgmt.fm.storade.schema.asset.VolVerifyResultDocument;
import com.sun.netstorage.mgmt.fm.storade.ui.util.Connection;
import com.sun.netstorage.mgmt.fm.storade.ui.util.Debug;
import com.sun.netstorage.mgmt.fm.storade.ui.util.DeviceUtil;
import com.sun.netstorage.mgmt.fm.storade.ui.util.XmlUtil;
import java.net.URLEncoder;

public class Getter {
    private Getter() {
    }

    public static RackResultDocument.RackResult getRack() {
        RackResultDocument.RackResult result = null;
        try {
            String s = Connection.getComboHeader();
            s = s + "?GO=Client::Control::GetAlarms&format=xml&";
            s = s + "GO2=Client::System::trays";
            s = s + "&GO3=Client::Config::getDeviceInfo";
            s = s + "&key=rackSystem";
            s = s + "&GO4=Client::Alarm::summary";
            String data = Connection.getData(s);
            Debug.println("REQUEST: " + s);
            Debug.println("DATA: " + data);
            data = XmlUtil.addHeader(data, "rackResult");
            RackResultDocument resultDoc = RackResultDocument.Factory.parse((String)data);
            result = resultDoc.getRackResult();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public static AssetsResultDocument.AssetsResult getSimpleAssets() {
        AssetsResultDocument.AssetsResult result = null;
        try {
            String s = Connection.getComboHeader();
            s = s + "?GO=Client::Config::listDevices";
            String data = Connection.getData(s);
            Debug.println("REQUEST: " + s);
            Debug.println("DATA: " + data);
            data = XmlUtil.addHeader(data, "assetsResult");
            AssetsResultDocument resultDoc = AssetsResultDocument.Factory.parse((String)data);
            result = resultDoc.getAssetsResult();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public static AssetsResultDocument.AssetsResult getAssets() {
        AssetsResultDocument.AssetsResult result = null;
        try {
            String s = Connection.getComboHeader();
            s = s + "?GO=Client::InstrReport::list&format=xml&host=1";
            s = s + "&GO2=Client::Config::listDevices";
            s = s + "&GO3=Client::Control::GetAlarms&format=xml&";
            s = s + "&GO4=Client::Alarm::summary";
            String data = Connection.getData(s);
            Debug.println("REQUEST: " + s);
            Debug.println("DATA: " + data);
            data = XmlUtil.addHeader(data, "assetsResult");
            AssetsResultDocument resultDoc = AssetsResultDocument.Factory.parse((String)data);
            result = resultDoc.getAssetsResult();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public static AssetResultDocument.AssetResult getSimpleReportDetails(String id) {
        AssetResultDocument.AssetResult result = null;
        try {
            String s = Connection.getComboHeader();
            s = s + "?GO=Client::InstrReport::summary";
            s = s + "&key=" + URLEncoder.encode(id, "UTF-8");
            String data = Connection.getData(s);
            Debug.println("REQUEST: " + s);
            Debug.println("DATA: " + data);
            data = XmlUtil.addHeader(data, "assetResult");
            AssetResultDocument resultDoc = AssetResultDocument.Factory.parse((String)data);
            result = resultDoc.getAssetResult();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public static AssetResultDocument.AssetResult getLiveFruList(String id, String filter) {
        AssetResultDocument.AssetResult result = null;
        try {
            String s = Connection.getRascgiComboHeader();
            s = s + "?GO=Client::Inventory::fruList";
            s = s + "&key=" + URLEncoder.encode(id, "UTF-8");
            if (filter != null) {
                s = s + "&filter=" + URLEncoder.encode(filter, "UTF-8");
            }
            String data = Connection.getData(s);
            data = "<CONTENT>" + data + "</CONTENT>";
            data = "<REPORT>" + data + "</REPORT>";
            Debug.println("REQUEST: " + s);
            Debug.println("DATA: " + data);
            data = XmlUtil.addHeader(data, "assetResult");
            AssetResultDocument resultDoc = AssetResultDocument.Factory.parse((String)data);
            result = resultDoc.getAssetResult();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static AssetResultDocument.AssetResult getFruList(String id, String filter) {
        AssetResultDocument.AssetResult result = null;
        try {
            String s = Connection.getComboHeader();
            s = s + "?GO=Client::InstrReport::fruList";
            s = s + "&key=" + URLEncoder.encode(id, "UTF-8");
            if (filter != null) {
                s = s + "&filter=" + URLEncoder.encode(filter, "UTF-8");
            }
            String data = Connection.getData(s);
            data = "<CONTENT>" + data + "</CONTENT>";
            data = "<REPORT>" + data + "</REPORT>";
            Debug.println("REQUEST: " + s);
            Debug.println("DATA: " + data);
            data = XmlUtil.addHeader(data, "assetResult");
            AssetResultDocument resultDoc = AssetResultDocument.Factory.parse((String)data);
            result = resultDoc.getAssetResult();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static AssetResultDocument.AssetResult getReportDetails(String id) {
        return Getter.getReportDetails(id, true, null);
    }

    public static AssetResultDocument.AssetResult getReportDetails(String id, boolean useIDForAlarm) {
        return Getter.getReportDetails(id, useIDForAlarm, null);
    }

    public static AssetResultDocument.AssetResult getReportDetails(String id, boolean useIDForAlarm, String agent) {
        AssetResultDocument.AssetResult result = null;
        try {
            String type = "";
            int index = id.indexOf(":");
            if (index != -1) {
                type = id.substring(0, id.indexOf(":"));
            }
            String s = Connection.getComboHeader();
            s = s + "?GO=Client::Control::GetAlarms&format=xml";
            if (useIDForAlarm) {
                s = s + "&key=" + URLEncoder.encode(id, "UTF-8");
            }
            s = s + "&GO2=Client::InstrReport::summary";
            s = s + "&key=" + URLEncoder.encode(id, "UTF-8");
            if (agent != null) {
                s = s + "&host=" + URLEncoder.encode(agent, "UTF-8");
            }
            s = s + "&GO3=Client::Config::getDeviceInfo";
            s = s + "&key=" + URLEncoder.encode(id, "UTF-8");
            s = s + "&GO4=Client::Config::listDevice";
            s = s + "&key=" + URLEncoder.encode(id, "UTF-8");
            s = s + "&GO5=Client::Diagx::list";
            s = s + "&ACTIVE=1";
            s = s + "&key=" + URLEncoder.encode(id, "UTF-8");
            s = s + "&GO6=Client::AppLauncher::listApp";
            s = s + "&deviceType=" + URLEncoder.encode(type, "UTF-8");
            s = s + "&GO7=Client::Alarm::summary";
            Debug.println("REQUEST: " + s);
            String data = Connection.getData(s);
            Debug.println("DATA: " + data);
            data = XmlUtil.addHeader(data, "assetResult");
            AssetResultDocument resultDoc = AssetResultDocument.Factory.parse((String)data);
            result = resultDoc.getAssetResult();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public static AssetResultDocument.AssetResult getSpaTray() {
        AssetResultDocument.AssetResult result = null;
        try {
            String s = Connection.getComboHeader();
            s = s + "?GO=Client::System::spatray";
            s = s + "&GO2=Client::Alarm::summary";
            Debug.println("REQUEST: " + s);
            String data = Connection.getData(s);
            Debug.println("DATA: " + data);
            data = XmlUtil.addHeader(data, "assetResult");
            AssetResultDocument resultDoc = AssetResultDocument.Factory.parse((String)data);
            result = resultDoc.getAssetResult();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public static ComponentResultDocument.ComponentResult getComponent(String key, String comp) {
        ComponentResultDocument.ComponentResult result = null;
        try {
            String s = Connection.getComboHeader();
            s = s + "?GO=Client::InstrReport::summary";
            s = s + "&key=" + URLEncoder.encode(key, "UTF-8");
            s = s + "&summary=" + URLEncoder.encode(comp + '.', "UTF-8");
            s = s + "&GO2=Client::Alarm::summary";
            String data = Connection.getData(s);
            data = XmlUtil.addHeader(data, "componentResult");
            Debug.println("REQUEST: " + s);
            Debug.println("DATA: " + data);
            ComponentResultDocument resultDoc = ComponentResultDocument.Factory.parse((String)data);
            result = resultDoc.getComponentResult();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public static MonitoringResultDocument.MonitoringResult getMonitoringAndSetup(String key) {
        MonitoringResultDocument.MonitoringResult result = null;
        try {
            String s = Connection.getComboHeader();
            s = s + "?GO=Client::Config::listDevices";
            String data = Connection.getData(s);
            data = XmlUtil.addHeader(data, "monitoringResult");
            Debug.println("REQUEST: " + s);
            Debug.println("DATA: " + data);
            MonitoringResultDocument resultDoc = MonitoringResultDocument.Factory.parse((String)data);
            result = resultDoc.getMonitoringResult();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public static ExceptionReportResultDocument.ExceptionReportResult getExceptionReport() {
        ExceptionReportResultDocument.ExceptionReportResult result = null;
        try {
            String s = Connection.getComboHeader();
            s = s + "?GO=Client::Alarm::summary";
            s = s + "&GO2=Client::ExceptionReport::list";
            s = s + "&GO3=Client::ExceptionReport::config";
            String data = Connection.getData(s);
            data = XmlUtil.addHeader(data, "exceptionReportResult");
            Debug.println("REQUEST: " + s);
            Debug.println("DATA: " + data);
            ExceptionReportResultDocument resultDoc = ExceptionReportResultDocument.Factory.parse((String)data);
            result = resultDoc.getExceptionReportResult();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public static SwitchStatsResultDocument.SwitchStatsResult getSwitchStatistics(String id) {
        SwitchStatsResultDocument.SwitchStatsResult result = null;
        id = DeviceUtil.getDeviceName(id);
        try {
            String s = Connection.getComboHeader();
            s = s + "?GO=Client::Alarm::summary";
            s = s + "&GO2=Client::SWITCHUtil::fc_data";
            s = s + "&SW=" + URLEncoder.encode(id, "UTF-8");
            String data = Connection.getData(s);
            data = XmlUtil.addHeader(data, "switchStatsResult");
            Debug.println("REQUEST: " + s);
            Debug.println("DATA: " + data);
            SwitchStatsResultDocument resultDoc = SwitchStatsResultDocument.Factory.parse((String)data);
            result = resultDoc.getSwitchStatsResult();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public static VolVerifyResultDocument.VolVerifyResult getVolVerifyOptions() {
        VolVerifyResultDocument.VolVerifyResult result = null;
        try {
            String s = Connection.getComboHeader();
            s = s + "?GO=Client::Alarm::summary";
            s = s + "&GO2=Client::VolVerify::getOptions";
            String data = Connection.getData(s);
            data = XmlUtil.addHeader(data, "VolVerifyResult");
            Debug.println("REQUEST: " + s);
            Debug.println("DATA: " + data);
            VolVerifyResultDocument resultDoc = VolVerifyResultDocument.Factory.parse((String)data);
            result = resultDoc.getVolVerifyResult();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public static String decodePassword(String password) {
        String result;
        try {
            String s = Connection.getComboHeader();
            s = s + "?GO=Client::Config::decodePassword";
            s = s + "&password=" + URLEncoder.encode(password, "UTF-8");
            String data = Connection.getData(s);
            Debug.println("REQUEST: " + s);
            Debug.println("DATA: " + data);
            result = data;
        }
        catch (Exception ex) {
            result = password;
            ex.printStackTrace();
        }
        return result;
    }

    public static RESERVESTATUSDocument.RESERVESTATUS getReserveStatus(String key) {
        RESERVESTATUSDocument.RESERVESTATUS result = null;
        if (key == null) {
            return null;
        }
        try {
            String s = Connection.getComboHeader();
            int pos = key.indexOf(":");
            if (pos != -1) {
                key = key.substring(pos + 1);
            }
            s = s + "?GO=Client::Advisor::reserve_status";
            s = s + "&key=" + URLEncoder.encode(key, "UTF-8");
            Debug.println("REQUEST: " + s);
            String data = Connection.getData(s);
            Debug.println("DATA: " + data);
            RESERVESTATUSDocument resultDoc = RESERVESTATUSDocument.Factory.parse((String)data);
            result = resultDoc.getRESERVESTATUS();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public static PerformanceResultDocument.PerformanceResult getPerformanceResult(String key, String reportType, String viewMode) {
        PerformanceResultDocument.PerformanceResult result = null;
        try {
            String s = Connection.getComboHeader();
            s = s + "?GO=Client::Perf::array";
            s = s + "&dev=" + URLEncoder.encode(key, "UTF-8");
            if ("C".equals(reportType)) {
                s = s + "&mode=C";
            } else if ("H".equals(reportType)) {
                s = s + "&mode=H";
            }
            if ("io".equals(viewMode)) {
                s = s + "&data=I";
            } else if ("meg".equals(viewMode)) {
                s = s + "&data=M";
            } else if ("utilization".equals(viewMode)) {
                s = s + "&data=U";
            } else if ("replication".equals(viewMode)) {
                s = s + "&data=R";
            }
            s = s + "&GO2=Client::Alarm::summary";
            Debug.println("REQUEST: " + s);
            String data = Connection.getData(s);
            data = XmlUtil.addHeader(data, "PerformanceResult");
            Debug.println("DATA: " + data);
            PerformanceResultDocument resultDoc = PerformanceResultDocument.Factory.parse((String)data);
            result = resultDoc.getPerformanceResult();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public static String getSEVerifyInfo(String action, String devID, String fruID) {
        if (action == null) {
            return null;
        }
        String ret = "";
        try {
            String s = Connection.getComboHeader();
            s = s + "?GO=Client::SEControl::" + action;
            if (devID != null) {
                s = s + "&deviceID=" + URLEncoder.encode(devID, "UTF-8");
            }
            if (fruID != null) {
                s = s + "&fruID=" + URLEncoder.encode(fruID, "UTF-8");
            }
            Debug.println("REQUEST: " + s);
            String data = Connection.getData(s);
            Debug.println("DATA: " + data);
            ret = data;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return ret;
    }

    public static boolean startSECompare() {
        boolean ret = false;
        try {
            String s = Connection.getComboHeader();
            s = s + "?GO=Client::SEControl::compareInventory";
            Debug.println("REQUEST: " + s);
            String data = Connection.getData(s);
            Debug.println("DATA: " + data);
            ret = true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return ret;
    }

    public static String getSECompareState() {
        String ret = "";
        try {
            String s = Connection.getComboHeader();
            s = s + "?GO=Client::SEControl::getCompareInventoryState";
            Debug.println("REQUEST: " + s);
            String data = Connection.getData(s);
            Debug.println("DATA: " + data);
            ret = data;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return ret;
    }

    public static SECompareResultDocument.SECompareResult getSECompareResult() {
        SECompareResultDocument.SECompareResult result = null;
        try {
            String s = Connection.getComboHeader();
            s = s + "?GO=Client::SEControl::getCompareInventoryResult";
            Debug.println("REQUEST: " + s);
            String data = Connection.getData(s);
            Debug.println("DATA: " + data);
            int pos = data.indexOf("XMLSTART");
            if (pos != -1) {
                data = data.substring(pos + 8);
            }
            data = XmlUtil.addHeader(data, "SECompareResult");
            SECompareResultDocument resultDoc = SECompareResultDocument.Factory.parse((String)data);
            result = resultDoc.getSECompareResult();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public static SEListArrayResultDocument.SEListArrayResult getSEListArrayResult() {
        SEListArrayResultDocument.SEListArrayResult result = null;
        try {
            String s = Connection.getComboHeader();
            s = s + "?GO=Client::SEControl::getArrays";
            Debug.println("REQUEST: " + s);
            String data = Connection.getData(s);
            Debug.println("DATA: " + data);
            data = XmlUtil.addHeader(data, "SEListArrayResult");
            SEListArrayResultDocument resultDoc = SEListArrayResultDocument.Factory.parse((String)data);
            result = resultDoc.getSEListArrayResult();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public static SEListArrayResultDocument.SEListArrayResult getSEListAllArrayResult() {
        SEListArrayResultDocument.SEListArrayResult result = null;
        try {
            String s = Connection.getComboHeader();
            s = s + "?GO=Client::SEControl::getAllArrays";
            Debug.println("REQUEST: " + s);
            String data = Connection.getData(s);
            Debug.println("DATA: " + data);
            data = XmlUtil.addHeader(data, "SEListArrayResult");
            SEListArrayResultDocument resultDoc = SEListArrayResultDocument.Factory.parse((String)data);
            result = resultDoc.getSEListArrayResult();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public static SEListArrayResultDocument.SEListArrayResult getSEListNewArrayResult() {
        SEListArrayResultDocument.SEListArrayResult result = null;
        try {
            String s = Connection.getComboHeader();
            s = s + "?GO=Client::SEControl::getNewArrays";
            Debug.println("REQUEST: " + s);
            String data = Connection.getData(s);
            Debug.println("DATA: " + data);
            data = XmlUtil.addHeader(data, "SEListArrayResult");
            SEListArrayResultDocument resultDoc = SEListArrayResultDocument.Factory.parse((String)data);
            result = resultDoc.getSEListArrayResult();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public static String getSEArrayBootStatus() {
        String result = null;
        try {
            String s = Connection.getComboHeader();
            s = s + "?GO=Client::SEControl::getBootStatus";
            Debug.println("REQUEST: " + s);
            String data = Connection.getData(s);
            Debug.println("DATA: " + data);
            result = data;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public static DSPNetworkConfigResultDocument.DSPNetworkConfigResult getDSPNetworkConfigResult(String cardNumber) {
        DSPNetworkConfigResultDocument.DSPNetworkConfigResult result = null;
        try {
            String s = Connection.getComboHeader();
            s = s + "?GO=Client::SEControl::showNetworkConfig&cardNumber=" + cardNumber;
            Debug.println("REQUEST: " + s);
            String data = Connection.getData(s);
            Debug.println("DATA: " + data);
            data = XmlUtil.addHeader(data, "DSPNetworkConfigResult");
            DSPNetworkConfigResultDocument resultDoc = DSPNetworkConfigResultDocument.Factory.parse((String)data);
            result = resultDoc.getDSPNetworkConfigResult();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public static ARPResultDocument.ARPResult getDSPARPResult(String cardNumber) {
        ARPResultDocument.ARPResult result = null;
        try {
            String s = Connection.getComboHeader();
            s = s + "?GO=Client::SEControl::getARP&cardNumber=" + cardNumber;
            Debug.println("REQUEST: " + s);
            String data = Connection.getData(s);
            Debug.println("DATA: " + data);
            data = XmlUtil.addHeader(data, "ARPResult");
            ARPResultDocument resultDoc = ARPResultDocument.Factory.parse((String)data);
            result = resultDoc.getARPResult();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }
}

