/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.jobs;

import com.iplanet.jato.model.DefaultModel;
import com.sun.netstorage.mgmt.fm.storade.schema.jobs.VolVerifyDevice;
import com.sun.netstorage.mgmt.fm.storade.schema.jobs.VolVerifyMonitorResultDocument;
import com.sun.netstorage.mgmt.fm.storade.schema.jobs.VolVerifyReport;
import com.sun.netstorage.mgmt.fm.storade.ui.util.NavUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class VolVerifyDataHelper {
    static final String RUNNING = "Running";
    static final String STORADE_STATUS_RUNNING = "Running";
    static final String STORADE_STATUS_ABORTED = "ABORTED";
    static final String STORADE_STATUS_DONE = "DONE";
    static final String STORADE_STATUS_STARTED = "Started";
    static final String STATUS_RUNNING = "job.status.running";
    static final String STATUS_ABORTED = "job.status.aborted";
    static final String STATUS_DONE = "job.status.done";
    static final String STATUS_STARTED = "job.status.started";

    public static final String getLocalizedStatus(String status) {
        if (status == null) {
            return status;
        }
        String r = status;
        if (status.equals("Running")) {
            r = STATUS_RUNNING;
        } else if (status.equals(STORADE_STATUS_ABORTED)) {
            r = STATUS_ABORTED;
        } else if (status.equals(STORADE_STATUS_DONE)) {
            r = STATUS_DONE;
        } else if (status.equals(STORADE_STATUS_STARTED)) {
            r = STATUS_STARTED;
        }
        return r;
    }

    public static boolean isRunning(VolVerifyMonitorResultDocument.VolVerifyMonitorResult result) {
        VolVerifyDevice[] devices;
        VolVerifyReport report;
        boolean isRunning = false;
        if (result != null && (report = result.getVOLVERIFYREPORT()) != null && (devices = report.getDEVICEArray()) != null) {
            int i = 0;
            while (i < devices.length) {
                if (!STORADE_STATUS_ABORTED.equals(devices[i].getSTATUS()) && "Running".equals(devices[i].getENDDATE())) {
                    isRunning = true;
                    break;
                }
                ++i;
            }
        }
        return isRunning;
    }

    public static void populateVolVerifyMonitor(VolVerifyMonitorResultDocument.VolVerifyMonitorResult result, DefaultModel model, Locale locale) {
        VolVerifyDevice[] devices;
        VolVerifyReport report;
        if (result != null && (report = result.getVOLVERIFYREPORT()) != null && (devices = report.getDEVICEArray()) != null) {
            SimpleDateFormat formatter = new SimpleDateFormat("MM-dd HH:mm:ss");
            boolean tableStarted = false;
            int i = 0;
            while (i < devices.length) {
                String type;
                if (tableStarted) {
                    model.appendRow();
                }
                if (!"".equals(type = devices[i].getTYPE())) {
                    tableStarted = true;
                    Date start = null;
                    Date end = null;
                    try {
                        if (devices[i].getSTARTDATE() != null) {
                            start = formatter.parse(devices[i].getSTARTDATE());
                        }
                    }
                    catch (ParseException ex) {
                        // empty catch block
                    }
                    try {
                        if (devices[i].getENDDATE() != null) {
                            end = formatter.parse(devices[i].getENDDATE());
                        }
                    }
                    catch (ParseException ex) {
                        // empty catch block
                    }
                    String host = devices[i].getHOST() == null ? "-" : devices[i].getHOST();
                    String verify = devices[i].getVERIFY() == null ? "-" : devices[i].getVERIFY();
                    String volume = devices[i].getVOLUME() == null ? "-" : devices[i].getVOLUME();
                    String errors = devices[i].getERRORS() == null ? "-" : devices[i].getERRORS();
                    String name = devices[i].getNAME() == null ? "-" : devices[i].getNAME();
                    String status = devices[i].getSTATUS() == null ? "-" : VolVerifyDataHelper.getLocalizedStatus(devices[i].getSTATUS());
                    String deviceKey = devices[i].getTYPE() + ":" + devices[i].getKEY();
                    model.setValue("AssetDetailsStoradeHREF", (Object)NavUtil.compose(new String[]{deviceKey, "NavUtil.JustIgnoreIt"}));
                    model.setValue("deviceValue", (Object)name);
                    model.setValue("verifyValue", (Object)verify);
                    model.setValue("volumeValue", (Object)volume);
                    model.setValue("errorsValue", (Object)errors);
                    model.setValue("hostValue", (Object)host);
                    model.setValue("startDateValue", (Object)start);
                    model.setValue("endDateValue", (Object)end);
                    model.setValue("statusValue", (Object)status);
                    model.setValue("durationValue", (Object)devices[i].getDURATION());
                }
                ++i;
            }
        }
    }

    static {
        RUNNING = "Running";
        STORADE_STATUS_RUNNING = "Running";
        STORADE_STATUS_ABORTED = STORADE_STATUS_ABORTED;
        STORADE_STATUS_DONE = STORADE_STATUS_DONE;
        STORADE_STATUS_STARTED = STORADE_STATUS_STARTED;
        STATUS_RUNNING = STATUS_RUNNING;
        STATUS_ABORTED = STATUS_ABORTED;
        STATUS_DONE = STATUS_DONE;
        STATUS_STARTED = STATUS_STARTED;
    }
}

