/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.discovery;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestManager;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.ContainerViewBase;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.iplanet.jato.view.html.OptionList;
import com.sun.netstorage.mgmt.fm.storade.ui.common.UIMastHeadViewBeanBase;
import com.sun.netstorage.mgmt.fm.storade.ui.util.AgentUtil;
import com.sun.netstorage.mgmt.fm.storade.ui.util.Connection;
import com.sun.netstorage.mgmt.fm.storade.ui.util.Debug;
import com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.discovery.DiscoveryDataHelper;
import com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.discovery.Setter;
import com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.jobs.JobsDataHelper;
import com.sun.web.ui.common.CCI18N;
import com.sun.web.ui.model.CCPageTitleModel;
import com.sun.web.ui.model.CCPageTitleModelInterface;
import com.sun.web.ui.model.CCPropertySheetModel;
import com.sun.web.ui.model.CCPropertySheetModelInterface;
import com.sun.web.ui.view.html.CCDropDownMenu;
import com.sun.web.ui.view.pagetitle.CCPageTitle;
import com.sun.web.ui.view.propertysheet.CCPropertySheet;
import java.util.StringTokenizer;
import javax.servlet.http.HttpSession;

public class DiscoveryViewBean
extends UIMastHeadViewBeanBase {
    public static final String PAGE_NAME = "Discovery";
    public static final String DEFAULT_DISPLAY_URL = "/jsp/discovery/Discovery.jsp";
    public static final String CHILD_PAGETITLE = "PageTitle";
    public static final String CHILD_PROPERTYSHEET = "DiscoveryPropertySheet";
    public static final String CHILD_AGENT = "agentValue";
    public static final String DISCOVERY_IP = "ip";
    public static final String DISCOVERY_INBAND = "inband";
    public static final String DISCOVERY_FILE = "file";
    private CCPropertySheetModel propertySheetModel = new CCPropertySheetModel(RequestManager.getRequestContext().getServletContext(), "/xml/propertysheet/DiscoveryPropertySheet.xml");
    private CCPageTitleModel pageTitleModel = new CCPageTitleModel(RequestManager.getRequestContext().getServletContext(), "/xml/pagetitle/DiscoveryPageTitle.xml");
    private CCI18N cci18n;
    private static final String AGENT_KEY = "agent.";
    static final String DO_REFRESH_DISCOVERY = "doRefreshDiscovery";
    static /* synthetic */ Class class$com$sun$web$ui$view$propertysheet$CCPropertySheet;
    static /* synthetic */ Class class$com$sun$web$ui$view$pagetitle$CCPageTitle;

    public DiscoveryViewBean() {
        super(PAGE_NAME, DEFAULT_DISPLAY_URL);
    }

    public void setRequestContext(RequestContext ctx) {
        super.setRequestContext(ctx);
        this.initModel();
    }

    protected void subRegisterChildren() {
        this.registerChild(CHILD_PROPERTYSHEET, class$com$sun$web$ui$view$propertysheet$CCPropertySheet == null ? (class$com$sun$web$ui$view$propertysheet$CCPropertySheet = DiscoveryViewBean.class$("com.sun.web.ui.view.propertysheet.CCPropertySheet")) : class$com$sun$web$ui$view$propertysheet$CCPropertySheet);
        this.propertySheetModel.registerChildren((ContainerViewBase)this);
        this.registerChild(CHILD_PAGETITLE, class$com$sun$web$ui$view$pagetitle$CCPageTitle == null ? (class$com$sun$web$ui$view$pagetitle$CCPageTitle = DiscoveryViewBean.class$("com.sun.web.ui.view.pagetitle.CCPageTitle")) : class$com$sun$web$ui$view$pagetitle$CCPageTitle);
        this.pageTitleModel.registerChildren((ContainerViewBase)this);
    }

    protected View subCreateChild(String name) {
        if (name.equals(CHILD_PROPERTYSHEET)) {
            CCPropertySheet child = new CCPropertySheet((ContainerView)this, (CCPropertySheetModelInterface)this.propertySheetModel, name);
            return child;
        }
        if (name.equals(CHILD_PAGETITLE)) {
            CCPageTitle child = new CCPageTitle((ContainerView)this, (CCPageTitleModelInterface)this.pageTitleModel, name);
            return child;
        }
        if (this.propertySheetModel.isChildSupported(name)) {
            View v = this.propertySheetModel.createChild((View)this, name);
            if (CHILD_AGENT.equals(name)) {
                this.cci18n = new CCI18N(this.getRequestContext(), "com.sun.netstorage.mgmt.fm.storade.ui.resources.ApplicationResources");
                OptionList options = new OptionList();
                String[] agentNames = DiscoveryDataHelper.getAgents();
                boolean unique = AgentUtil.unique(agentNames);
                String localAgent = null;
                int i = 0;
                while (i < agentNames.length) {
                    boolean isLocal = AgentUtil.isLocalHost(agentNames[i]);
                    if (isLocal) {
                        localAgent = agentNames[i];
                    }
                    ++i;
                }
                CCDropDownMenu agentDropDown = (CCDropDownMenu)v;
                if (agentNames != null) {
                    if (localAgent != null) {
                        String agentName = localAgent;
                        if (unique) {
                            agentName = AgentUtil.getShortName(agentName);
                        }
                        Object[] params = new String[]{agentName};
                        String value = this.cci18n.getMessage("assets.discovery.localAgent", params);
                        options.add(value, AGENT_KEY + localAgent);
                    }
                    int i2 = 0;
                    while (i2 < agentNames.length) {
                        if (localAgent == null || !localAgent.equals(agentNames[i2])) {
                            String agentName = agentNames[i2];
                            if (unique) {
                                agentName = AgentUtil.getShortName(agentName);
                            }
                            options.add(agentName, AGENT_KEY + agentNames[i2]);
                        }
                        ++i2;
                    }
                }
                String value = this.cci18n.getMessage("assets.discovery.allAgents", null);
                options.add(value, "allAgents");
                agentDropDown.setOptions(options);
            }
            return v;
        }
        if (this.pageTitleModel.isChildSupported(name)) {
            return this.pageTitleModel.createChild((View)this, name);
        }
        return null;
    }

    private void loadPropertySheetModel(CCPropertySheetModel model) {
        model.clear();
        model.setValue("PrefixValue", (Object)"none");
        model.setValue("monitorDiscoValue", (Object)"yes");
        model.setValue("addToInventoryValue", (Object)"yes");
    }

    private void initModel() {
        this.pageTitleModel.setValue("PageButtonStartDiscovery", (Object)"button.startDiscovery");
        this.pageTitleModel.setValue("PageButtonCancel", (Object)"button.cancel");
        this.loadPropertySheetModel(this.propertySheetModel);
    }

    public void beginDisplay(DisplayEvent event) {
        this.checkUserPrivilege();
        try {
            super.beginDisplay(event);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void handlePageButtonStartDiscoveryRequest(RequestInvocationEvent event) {
        boolean isLocal = false;
        String agentValue = (String)this.getDisplayFieldValue(CHILD_AGENT);
        long lastStart = JobsDataHelper.getDiscoveryStartTime();
        Debug.println("AGENT: " + agentValue);
        Debug.println("Last Start: " + lastStart);
        if (agentValue != null && agentValue.startsWith(AGENT_KEY)) {
            agentValue = agentValue.substring(AGENT_KEY.length());
            isLocal = AgentUtil.isLocalHost(agentValue);
        } else {
            agentValue = null;
        }
        String IPlistValue = (String)this.getDisplayFieldValue("IPlistValue");
        if (IPlistValue != null) {
            IPlistValue = this.rebuildIPList(IPlistValue);
        }
        Debug.println("IP List: " + IPlistValue);
        String discoveryMechanismValue = (String)this.getDisplayFieldValue("discoveryMechanismValue");
        String prefixValue = (String)this.getDisplayFieldValue("PrefixValue");
        String customValue = (String)this.getDisplayFieldValue("customValue");
        String monitorDiscoValue = (String)this.getDisplayFieldValue("monitorDiscoValue");
        String addToInventoryValue = (String)this.getDisplayFieldValue("addToInventoryValue");
        Debug.println("DISCOVERY MECHANISM: " + discoveryMechanismValue);
        Debug.println("IS LOCAL: " + isLocal);
        Debug.println("AGENT: " + agentValue);
        Debug.println("PREFIX VALUE: " + prefixValue);
        Debug.println("CUSTOM VALUE: " + customValue);
        Debug.println("MONITOR DISCO: " + monitorDiscoValue);
        Debug.println("ADD TO INVENTORY: " + addToInventoryValue);
        String prefix = null;
        if (prefixValue != null) {
            if (prefixValue.equals("hostname")) {
                prefix = "_agentname";
            } else if (prefixValue.equals("custom")) {
                prefix = customValue;
            }
        }
        Debug.println("PREFIX: " + prefix);
        String monitor = "Y";
        if ("no".equals(monitorDiscoValue)) {
            monitor = "N";
        }
        String writeConfig = null;
        if ("no".equals(addToInventoryValue)) {
            writeConfig = "Y";
        }
        if (discoveryMechanismValue != null) {
            if (DISCOVERY_IP.equals(discoveryMechanismValue)) {
                Setter.startDiscoveryFromIP(isLocal, monitor, agentValue, prefix, IPlistValue, writeConfig);
            } else if (DISCOVERY_INBAND.equals(discoveryMechanismValue)) {
                Setter.startInbandDiscovery(isLocal, monitor, agentValue, prefix, IPlistValue, writeConfig);
            } else if (DISCOVERY_FILE.equals(discoveryMechanismValue)) {
                Setter.startDiscoveryFromFile(isLocal, monitor, agentValue, prefix, IPlistValue, writeConfig);
            }
        }
        HttpSession session = this.getRequestContext().getRequest().getSession();
        session.setAttribute(DO_REFRESH_DISCOVERY, (Object)"true");
        String url = "/" + Connection.getAppName() + "/discovery/DiscoveryList?lastStart=" + lastStart + "&mechanism=" + this.urlencode(discoveryMechanismValue);
        if (agentValue != null) {
            url = url + "&agent=" + this.urlencode(agentValue);
        }
        try {
            event.getRequestContext().getResponse().sendRedirect(url);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void handlePageButtonCancelRequest(RequestInvocationEvent event) {
        String url = "/" + Connection.getAppName() + "/reports/Assets";
        try {
            event.getRequestContext().getResponse().sendRedirect(url);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private String rebuildIPList(String in) {
        if (in == null) {
            return null;
        }
        Debug.println("IP List in: " + in);
        StringTokenizer st = new StringTokenizer(in, ", \r\n");
        String ret = "";
        while (st.hasMoreTokens()) {
            ret = ret + st.nextToken() + ",";
        }
        if (ret.length() > 1) {
            ret = ret.substring(0, ret.length() - 1);
        }
        Debug.println("IP List out: " + ret);
        return ret;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        PAGE_NAME = PAGE_NAME;
        DEFAULT_DISPLAY_URL = DEFAULT_DISPLAY_URL;
        CHILD_PAGETITLE = CHILD_PAGETITLE;
        CHILD_PROPERTYSHEET = CHILD_PROPERTYSHEET;
        CHILD_AGENT = CHILD_AGENT;
        DISCOVERY_IP = DISCOVERY_IP;
        DISCOVERY_INBAND = DISCOVERY_INBAND;
        DISCOVERY_FILE = DISCOVERY_FILE;
        AGENT_KEY = AGENT_KEY;
        DO_REFRESH_DISCOVERY = DO_REFRESH_DISCOVERY;
    }
}

