/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.diagnostics;

import com.sun.netstorage.mgmt.fm.storade.schema.jobs.AnswerQuestionResultDocument;
import com.sun.netstorage.mgmt.fm.storade.ui.util.Connection;
import com.sun.netstorage.mgmt.fm.storade.ui.util.Debug;
import com.sun.netstorage.mgmt.fm.storade.ui.util.XmlUtil;
import java.net.URLEncoder;

public class Setter {
    private Setter() {
    }

    public static String runDiag(String assetID, String testName, String[] opt, String[] values, String agent) {
        String pid = null;
        try {
            String s = Connection.getComboHeader();
            s = s + "?GO=Client::Diag::run";
            s = s + "&test=" + URLEncoder.encode(testName, "UTF-8");
            s = s + "&key=" + URLEncoder.encode(assetID, "UTF-8");
            int i = 0;
            while (i < opt.length) {
                String option = opt[i];
                String value = values[i];
                if (option != null && value != null) {
                    if (option.startsWith("-")) {
                        option = option.substring(1);
                    }
                    s = s + "&opt_" + URLEncoder.encode(option, "UTF-8") + "=" + URLEncoder.encode(value, "UTF-8");
                }
                ++i;
            }
            if (agent != null) {
                s = s + "&hostname=" + URLEncoder.encode(agent, "UTF-8");
            }
            String data = Connection.getData(s);
            Debug.println("REQUEST: " + s);
            Debug.println("DATA: " + data);
            pid = data;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return pid;
    }

    public static String abortDiag(String id, String hostname) {
        String r = null;
        try {
            String s = Connection.getComboHeader();
            s = s + "?GO=Client::Diag::abort";
            s = s + "&pid=" + URLEncoder.encode(id, "UTF-8");
            s = s + "&hostname=" + URLEncoder.encode(hostname, "UTF-8");
            String data = Connection.getData(s);
            Debug.println("REQUEST: " + s);
            Debug.println("DATA: " + data);
            r = data;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return r;
    }

    public static AnswerQuestionResultDocument.AnswerQuestionResult answerQuestion(String pid, String answer) {
        AnswerQuestionResultDocument.AnswerQuestionResult result = null;
        try {
            String s = Connection.getComboHeader();
            s = s + "?GO=Client::Diag::answerQuestion";
            s = s + "&pid=" + URLEncoder.encode(pid, "UTF-8");
            s = s + "&QUESTION=" + URLEncoder.encode(answer, "UTF-8");
            String data = Connection.getData(s);
            Debug.println("REQUEST: " + s);
            Debug.println("DATA: " + data);
            data = XmlUtil.addHeader(data, "answerQuestionResult");
            AnswerQuestionResultDocument resultDoc = AnswerQuestionResultDocument.Factory.parse((String)data);
            result = resultDoc.getAnswerQuestionResult();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }
}

