/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.diagnostics;

import com.sun.netstorage.mgmt.fm.storade.schema.jobs.DiagResultDocument;
import com.sun.netstorage.mgmt.fm.storade.schema.jobs.GetQuestionResultDocument;
import com.sun.netstorage.mgmt.fm.storade.ui.util.Connection;
import com.sun.netstorage.mgmt.fm.storade.ui.util.Debug;
import com.sun.netstorage.mgmt.fm.storade.ui.util.LocalizeUtil;
import com.sun.netstorage.mgmt.fm.storade.ui.util.XmlUtil;
import java.net.URLEncoder;
import java.util.Locale;

public class Getter {
    private Getter() {
    }

    public static DiagResultDocument.DiagResult getDiag(String id, Locale locale) {
        DiagResultDocument.DiagResult result = null;
        try {
            String s = Connection.getComboHeader();
            s = s + "?GO=Client::Diagx::list";
            s = s + "&mode=storade";
            s = s + "&key=" + URLEncoder.encode(id, "UTF-8");
            locale = LocalizeUtil.resolveLocale(locale);
            s = s + "&locale=" + locale.toString();
            s = s + "&GO2=Client::Alarm::summary";
            String data = Connection.getData(s);
            Debug.println("REQUEST: " + s);
            Debug.println("DATA: " + data);
            data = XmlUtil.addHeader(data, "diagResult");
            DiagResultDocument diagDoc = DiagResultDocument.Factory.parse((String)data);
            result = diagDoc.getDiagResult();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public static String getDiagResult(String pid) {
        String result = null;
        try {
            String s = Connection.getComboHeader();
            s = s + "?GO=Client::Diag::status";
            s = s + "&pid=" + pid;
            String data = Connection.getData(s);
            Debug.println("REQUEST: " + s);
            Debug.println("DATA: " + data);
            result = data;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public static GetQuestionResultDocument.GetQuestionResult getGetQuestionResult(String pid) {
        GetQuestionResultDocument.GetQuestionResult result = null;
        try {
            String s = Connection.getComboHeader();
            s = s + "?GO=Client::Diag::getQuestion";
            s = s + "&pid=" + URLEncoder.encode(pid, "UTF-8");
            String data = Connection.getData(s);
            Debug.println("REQUEST: " + s);
            Debug.println("DATA: " + data);
            data = XmlUtil.addHeader(data, "getQuestionResult");
            GetQuestionResultDocument resultDoc = GetQuestionResultDocument.Factory.parse((String)data);
            result = resultDoc.getGetQuestionResult();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }
}

