/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.diagnostics;

import com.iplanet.jato.model.DefaultModel;
import com.sun.netstorage.mgmt.fm.storade.schema.Value;
import com.sun.netstorage.mgmt.fm.storade.schema.jobs.DiagDetailsResultDocument;
import com.sun.netstorage.mgmt.fm.storade.schema.jobs.DiagList;
import com.sun.netstorage.mgmt.fm.storade.schema.jobs.DiagResultDocument;
import com.sun.netstorage.mgmt.fm.storade.schema.jobs.DiagTest;
import com.sun.netstorage.mgmt.fm.storade.schema.jobs.TestInfo;
import com.sun.netstorage.mgmt.fm.storade.schema.jobs.TestOpt;
import com.sun.netstorage.mgmt.fm.storade.ui.util.DateUtil;
import com.sun.netstorage.mgmt.fm.storade.ui.util.Debug;
import com.sun.netstorage.mgmt.fm.storade.ui.util.LocalizeUtil;
import com.sun.netstorage.mgmt.fm.storade.ui.util.PropertySheetUtil;
import com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.diagnostics.DiagnosticField;
import com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.diagnostics.Setter;
import java.util.ArrayList;
import java.util.Locale;

public class DiagnosticsDataHelper {
    private static final String DIAG_NAME = "name";
    private static final String DIAG_SECTION_NAME = "sectionName";
    private static final String DIAG_WARNING = "warning";
    private static final String OPT_DEFAULT = "default";
    private static final String OPT_NAME = "name";
    private static final String OPT_OPT = "opt";
    private static final String OPT_TYPE = "type";
    private static final String OPT_VALUES = "values";
    private static final String OPT_LOCALIZED_VALUES = "values.localized";
    private static final String START_TIME = "info.start_date";
    private static final String END_TIME = "info.end_date";
    private static final String STATUS = "info.status";
    private static final String STORADE_STATUS_RUNNING = "Running";
    private static final String STORADE_STATUS_RUNNING_2 = "running";
    private static final String STORADE_STATUS_WAITING = "Waiting..";
    private static final String STORADE_STATUS_ABORTED = "Done:ABORTED";
    private static final String STORADE_STATUS_ISOLATED = "Done:ISOLATED";
    private static final String STORADE_STATUS_SYNC = "Done:SYNC";
    private static final String STORADE_STATUS_OK = "Done:OK";
    private static final String STORADE_STATUS_ERROR = "Done:ERROR";
    private static final String STORADE_STATUS_DONE = "Done";
    private static final String STATUS_RUNNING = "job.status.running";
    private static final String STATUS_WAITING = "job.status.waiting";
    private static final String STATUS_ABORTED = "job.status.aborted";
    private static final String STATUS_ISOLATED = "job.status.isolated";
    private static final String STATUS_SYNC = "job.status.sync";
    private static final String STATUS_OK = "job.status.ok";
    private static final String STATUS_ERROR = "job.status.error";
    private static final String STATUS_DONE = "job.status.done";

    private DiagnosticsDataHelper() {
    }

    public static final String getLocalizedStatus(String status) {
        if (status == null) {
            return status;
        }
        String r = status;
        if (status.equals(STORADE_STATUS_RUNNING) || status.equals(STORADE_STATUS_RUNNING_2)) {
            r = STATUS_RUNNING;
        } else if (status.equals(STORADE_STATUS_WAITING)) {
            r = STATUS_WAITING;
        } else if (status.equals(STORADE_STATUS_ABORTED)) {
            r = STATUS_ABORTED;
        } else if (status.equals(STORADE_STATUS_ISOLATED)) {
            r = STATUS_ISOLATED;
        } else if (status.equals(STORADE_STATUS_SYNC)) {
            r = STATUS_SYNC;
        } else if (status.equals(STORADE_STATUS_OK)) {
            r = STATUS_OK;
        } else if (status.equals(STORADE_STATUS_ERROR)) {
            r = STATUS_ERROR;
        } else if (status.equals(STORADE_STATUS_DONE)) {
            r = STATUS_DONE;
        }
        return r;
    }

    public static boolean isWaiting(DiagDetailsResultDocument.DiagDetailsResult result) {
        String status;
        boolean isWaiting = false;
        if (result != null && result.getDETAILS() != null && STORADE_STATUS_WAITING.equals(status = result.getDETAILS().getSTATUS())) {
            isWaiting = true;
        }
        return isWaiting;
    }

    public static boolean isRunning(DiagDetailsResultDocument.DiagDetailsResult result) {
        String status;
        boolean isRunning = false;
        if (result != null && result.getDETAILS() != null && STORADE_STATUS_RUNNING.equals(status = result.getDETAILS().getSTATUS())) {
            isRunning = true;
        }
        return isRunning;
    }

    public static String getSectionName(DiagResultDocument.DiagResult result, String testName) {
        DiagTest[] diagTest;
        String testSectionName = null;
        DiagList diagList = result.getDIAGLIST();
        if (diagList != null && (diagTest = diagList.getDIAGTESTArray()) != null) {
            int i = 0;
            while (i < diagTest.length) {
                String s;
                int j;
                Value[] values;
                boolean found = false;
                TestInfo testInfo = diagTest[i].getTESTINFO();
                if (testInfo != null && (values = testInfo.getVALUEArray()) != null) {
                    j = 0;
                    while (j < values.length) {
                        String v;
                        s = values[j].getID();
                        if ("name".equals(s) && testName.equals(v = values[j].getStringValue())) {
                            found = true;
                            break;
                        }
                        ++j;
                    }
                }
                if (found) {
                    Debug.println("Found correct test: " + testName);
                    Value[] v = testInfo.getVALUEArray();
                    j = 0;
                    while (j < v.length) {
                        s = v[j].getID();
                        if (DIAG_SECTION_NAME.equals(s)) {
                            testSectionName = v[j].getStringValue();
                            break;
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        return testSectionName;
    }

    public static String[] getOpt(DiagResultDocument.DiagResult result, String assetID, String testName) throws IllegalArgumentException {
        DiagTest[] diagTest;
        ArrayList<String> options = new ArrayList<String>();
        DiagList diagList = result.getDIAGLIST();
        if (diagList != null && (diagTest = diagList.getDIAGTESTArray()) != null) {
            int i = 0;
            while (i < diagTest.length) {
                int j;
                Value[] values;
                boolean found = false;
                TestInfo testInfo = diagTest[i].getTESTINFO();
                if (testInfo != null && (values = testInfo.getVALUEArray()) != null) {
                    j = 0;
                    while (j < values.length) {
                        String v;
                        String s = values[j].getID();
                        if (DIAG_SECTION_NAME.equals(s) && testName.equals(v = values[j].getStringValue())) {
                            found = true;
                            break;
                        }
                        ++j;
                    }
                }
                if (found) {
                    Debug.println("Found correct test: " + testName);
                    TestOpt[] testOpt = diagTest[i].getTESTOPTArray();
                    if (testOpt != null) {
                        j = 0;
                        while (j < testOpt.length) {
                            DiagnosticField df = new DiagnosticField();
                            Value[] values2 = testOpt[j].getVALUEArray();
                            if (values2 != null) {
                                int k = 0;
                                while (k < values2.length) {
                                    String s = values2[k].getID();
                                    if (OPT_OPT.equals(s)) {
                                        df.setOption(values2[k].getStringValue());
                                    }
                                    ++k;
                                }
                            }
                            if (df.getOption() != null) {
                                options.add(df.getOption());
                            }
                            ++j;
                        }
                    }
                }
                ++i;
            }
        }
        String[] optionsArray = new String[options.size()];
        options.toArray(optionsArray);
        return optionsArray;
    }

    public static String runDiag(String assetID, String testName, String[] opt, String[] values, String agent) {
        return Setter.runDiag(assetID, testName, opt, values, agent);
    }

    public static void populateTestResultTable(DiagDetailsResultDocument.DiagDetailsResult result, DefaultModel testResultTableModel, Locale locale) {
        String startTime = null;
        String endTime = null;
        String status = null;
        String target = null;
        String ports = null;
        if (result != null && result.getDETAILS() != null) {
            startTime = result.getDETAILS().getSTARTDATE();
            endTime = result.getDETAILS().getENDDATE();
            status = result.getDETAILS().getSTATUS();
            if (result.getDETAILS().getINFO() != null) {
                target = result.getDETAILS().getINFO().getTARGET();
                ports = result.getDETAILS().getINFO().getPORTS();
            }
        }
        String localizedStartTime = startTime;
        String localizedEndTime = endTime;
        try {
            localizedStartTime = DateUtil.toString1(DateUtil.toDate1(startTime), locale);
            if (endTime != null && !"".equals(endTime)) {
                localizedEndTime = DateUtil.toString1(DateUtil.toDate1(endTime), locale);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        testResultTableModel.setValue("propertyName", (Object)"asset.test.testresult.startTime");
        testResultTableModel.setValue("propertyValue", (Object)localizedStartTime);
        testResultTableModel.appendRow();
        testResultTableModel.setValue("propertyName", (Object)"asset.test.testresult.endTime");
        testResultTableModel.setValue("propertyValue", (Object)localizedEndTime);
        testResultTableModel.appendRow();
        testResultTableModel.setValue("propertyName", (Object)"asset.test.testresult.status");
        testResultTableModel.setValue("propertyValue", (Object)DiagnosticsDataHelper.getLocalizedStatus(status));
        testResultTableModel.appendRow();
        testResultTableModel.setValue("propertyName", (Object)"asset.test.testresult.target");
        testResultTableModel.setValue("propertyValue", (Object)target);
        if (ports != null && !"".equals(ports)) {
            testResultTableModel.appendRow();
            testResultTableModel.setValue("propertyName", (Object)"asset.test.testresult.ports");
            testResultTableModel.setValue("propertyValue", (Object)ports);
        }
    }

    private static TestOpt[] getTestOpt(DiagResultDocument.DiagResult result, String assetID, String testName, Locale locale) {
        DiagTest[] diagTest;
        TestOpt[] testOpt = null;
        DiagList diagList = result.getDIAGLIST();
        if (diagList != null && (diagTest = diagList.getDIAGTESTArray()) != null) {
            int i = 0;
            while (i < diagTest.length) {
                Value[] values;
                boolean found = false;
                TestInfo testInfo = diagTest[i].getTESTINFO();
                if (testInfo != null && (values = testInfo.getVALUEArray()) != null) {
                    int j = 0;
                    while (j < values.length) {
                        String v;
                        String s = values[j].getID();
                        if ("name".equals(s) && testName.equals(v = values[j].getStringValue())) {
                            found = true;
                            break;
                        }
                        ++j;
                    }
                }
                if (found) {
                    Debug.println("Found correct test: " + testName);
                    testOpt = diagTest[i].getTESTOPTArray();
                }
                ++i;
            }
        }
        return testOpt;
    }

    public static String createPropertySheetTemplate(DiagResultDocument.DiagResult result, String assetID, String testName, String agent, Locale locale) {
        StringBuffer buf = new StringBuffer();
        buf.append(PropertySheetUtil.addPropSheetHeader());
        buf.append(PropertySheetUtil.addSectionHeader("test.opt.context"));
        buf.append(PropertySheetUtil.addStaticText("test.opt.testName", "testName", testName));
        buf.append(PropertySheetUtil.addStaticText("test.opt.monitoringAgent", "agent", agent));
        buf.append(PropertySheetUtil.addSectionFooter());
        buf.append(PropertySheetUtil.addSectionHeader("test.opt.testParameters"));
        TestOpt[] testOpt = DiagnosticsDataHelper.getTestOpt(result, assetID, testName, locale);
        if (testOpt != null) {
            int j = 0;
            while (j < testOpt.length) {
                DiagnosticField df = new DiagnosticField();
                Value[] values = testOpt[j].getVALUEArray();
                if (values != null) {
                    int k = 0;
                    while (k < values.length) {
                        String s = values[k].getID();
                        if (OPT_DEFAULT.equals(s)) {
                            df.setDefault(values[k].getStringValue());
                        } else if ("name".equals(s)) {
                            if ("Register".equals(values[k].getStringValue())) {
                                df.setName(LocalizeUtil.getLocalizedString("test.opt.register", locale));
                            } else {
                                df.setName(values[k].getStringValue());
                            }
                        } else if (OPT_OPT.equals(s)) {
                            df.setOption(values[k].getStringValue());
                        } else if (OPT_TYPE.equals(s)) {
                            df.setType(values[k].getStringValue());
                        } else if (OPT_VALUES.equals(s)) {
                            df.setValues(values[k].getStringValue());
                        } else if (OPT_LOCALIZED_VALUES.equals(s)) {
                            df.setLocalizedValues(values[k].getStringValue());
                        }
                        ++k;
                    }
                }
                if (df.getName() != null) {
                    int i;
                    String[] optValues;
                    String[] optNames;
                    String[] names;
                    if ("checkbox".equals(df.getType())) {
                        boolean selected = false;
                        if ("1".equals(df.getDefault())) {
                            selected = true;
                        }
                        buf.append(PropertySheetUtil.addCheckBox(df.getName(), df.getOption(), selected));
                    } else if ("select".equals(df.getType())) {
                        String[] items = df.getValues();
                        names = df.getLocalizedValues();
                        if (!(items == null || items.length == 0 || items.length == 1 && items[0].trim().equals(""))) {
                            optNames = new String[items.length];
                            optValues = new String[items.length];
                            i = 0;
                            while (i < items.length) {
                                optValues[i] = DiagnosticField.getValue(items[i]);
                                optNames[i] = DiagnosticField.getText(names[i]);
                                ++i;
                            }
                            buf.append(PropertySheetUtil.addDropDown(df.getName(), df.getOption(), df.getDefault(), optNames, optValues));
                        }
                    } else if ("radio".equals(df.getType())) {
                        String[] items = df.getValues();
                        names = df.getLocalizedValues();
                        optNames = new String[items.length];
                        optValues = new String[items.length];
                        i = 0;
                        while (i < items.length) {
                            optValues[i] = DiagnosticField.getValue(items[i]);
                            optNames[i] = DiagnosticField.getText(names[i]);
                            ++i;
                        }
                        buf.append(PropertySheetUtil.addRadio(df.getName(), df.getOption(), optNames, optValues));
                    } else if ("password".equals(df.getType())) {
                        buf.append(PropertySheetUtil.addPassword(df.getName(), df.getOption(), df.getDefault()));
                    } else if ("const".equals(df.getType())) {
                        buf.append(PropertySheetUtil.addStaticTextWithHidden(df.getName(), df.getOption(), df.getDefault()));
                    } else {
                        buf.append(PropertySheetUtil.addInputText(df.getName(), df.getOption(), df.getDefault()));
                    }
                }
                ++j;
            }
        }
        buf.append(PropertySheetUtil.addSectionFooter());
        buf.append(PropertySheetUtil.addPropSheetFooter());
        return buf.toString();
    }

    public static String createEmptyPropertySheetTemplate() {
        StringBuffer buf = new StringBuffer();
        buf.append(PropertySheetUtil.addPropSheetHeader());
        buf.append(PropertySheetUtil.addSectionHeader("Test Parameters"));
        buf.append(PropertySheetUtil.addInputText("0", "0", "0"));
        buf.append(PropertySheetUtil.addSectionFooter());
        buf.append(PropertySheetUtil.addPropSheetFooter());
        return buf.toString();
    }

    static String getDefaultValueFor(DiagResultDocument.DiagResult result, String assetID, String testName, String opt) {
        TestOpt[] testOpt = DiagnosticsDataHelper.getTestOpt(result, assetID, testName, Locale.getDefault());
        if (testOpt != null) {
            int j = 0;
            while (j < testOpt.length) {
                DiagnosticField df = new DiagnosticField();
                Value[] values = testOpt[j].getVALUEArray();
                if (values != null) {
                    int k = 0;
                    while (k < values.length) {
                        String s = values[k].getID();
                        if (OPT_DEFAULT.equals(s)) {
                            df.setDefault(values[k].getStringValue());
                        } else if ("name".equals(s)) {
                            df.setName(values[k].getStringValue());
                        } else if (OPT_OPT.equals(s)) {
                            df.setOption(values[k].getStringValue());
                        } else if (OPT_TYPE.equals(s)) {
                            df.setType(values[k].getStringValue());
                        } else if (OPT_VALUES.equals(s)) {
                            df.setValues(values[k].getStringValue());
                        }
                        ++k;
                    }
                }
                if (opt.equals(df.getOption())) {
                    return df.getDefault();
                }
                ++j;
            }
        }
        return null;
    }

    static String getPreWarningMessage(DiagResultDocument.DiagResult result, String testName, Locale locale) {
        DiagTest[] diagTest;
        String preWarningMessage = null;
        DiagList diagList = result.getDIAGLIST();
        if (diagList != null && (diagTest = diagList.getDIAGTESTArray()) != null) {
            int i = 0;
            while (i < diagTest.length) {
                Value[] values;
                boolean found = false;
                TestInfo testInfo = diagTest[i].getTESTINFO();
                if (testInfo != null && (values = testInfo.getVALUEArray()) != null) {
                    int j = 0;
                    while (j < values.length) {
                        String v;
                        String s = values[j].getID();
                        if ("name".equals(s) && testName.equals(v = values[j].getStringValue())) {
                            found = true;
                            break;
                        }
                        ++j;
                    }
                    if (found) {
                        Debug.println("Found correct test for pre warning: " + testName);
                        preWarningMessage = diagTest[i].getTESTPREWARNING();
                    }
                }
                ++i;
            }
        }
        return preWarningMessage;
    }

    static String getWarningMessage(DiagResultDocument.DiagResult result, String testName, Locale locale) {
        DiagTest[] diagTest;
        String warningMessage = null;
        DiagList diagList = result.getDIAGLIST();
        if (diagList != null && (diagTest = diagList.getDIAGTESTArray()) != null) {
            int i = 0;
            while (i < diagTest.length) {
                Value[] values;
                boolean found = false;
                TestInfo testInfo = diagTest[i].getTESTINFO();
                if (testInfo != null && (values = testInfo.getVALUEArray()) != null) {
                    int j = 0;
                    while (j < values.length) {
                        String v;
                        String s = values[j].getID();
                        if ("name".equals(s) && testName.equals(v = values[j].getStringValue())) {
                            found = true;
                            break;
                        }
                        ++j;
                    }
                    if (found) {
                        Debug.println("Found correct test for warning: " + testName);
                        Value[] v = testInfo.getVALUEArray();
                        int j2 = 0;
                        while (j2 < v.length) {
                            String s = v[j2].getID();
                            if (DIAG_WARNING.equals(s)) {
                                warningMessage = v[j2].getStringValue();
                                break;
                            }
                            ++j2;
                        }
                    }
                }
                ++i;
            }
        }
        return warningMessage;
    }

    static {
        DIAG_NAME = "name";
        DIAG_SECTION_NAME = DIAG_SECTION_NAME;
        DIAG_WARNING = DIAG_WARNING;
        OPT_DEFAULT = OPT_DEFAULT;
        OPT_NAME = "name";
        OPT_OPT = OPT_OPT;
        OPT_TYPE = OPT_TYPE;
        OPT_VALUES = OPT_VALUES;
        OPT_LOCALIZED_VALUES = OPT_LOCALIZED_VALUES;
        START_TIME = START_TIME;
        END_TIME = END_TIME;
        STATUS = STATUS;
        STORADE_STATUS_RUNNING = STORADE_STATUS_RUNNING;
        STORADE_STATUS_RUNNING_2 = STORADE_STATUS_RUNNING_2;
        STORADE_STATUS_WAITING = STORADE_STATUS_WAITING;
        STORADE_STATUS_ABORTED = STORADE_STATUS_ABORTED;
        STORADE_STATUS_ISOLATED = STORADE_STATUS_ISOLATED;
        STORADE_STATUS_SYNC = STORADE_STATUS_SYNC;
        STORADE_STATUS_OK = STORADE_STATUS_OK;
        STORADE_STATUS_ERROR = STORADE_STATUS_ERROR;
        STORADE_STATUS_DONE = STORADE_STATUS_DONE;
        STATUS_RUNNING = STATUS_RUNNING;
        STATUS_WAITING = STATUS_WAITING;
        STATUS_ABORTED = STATUS_ABORTED;
        STATUS_ISOLATED = STATUS_ISOLATED;
        STATUS_SYNC = STATUS_SYNC;
        STATUS_OK = STATUS_OK;
        STATUS_ERROR = STATUS_ERROR;
        STATUS_DONE = STATUS_DONE;
    }
}

