/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.alarms;

import com.sun.netstorage.mgmt.fm.storade.schema.alarms.AlarmDetailsResultDocument;
import com.sun.netstorage.mgmt.fm.storade.schema.alarms.AlarmListResultDocument;
import com.sun.netstorage.mgmt.fm.storade.schema.alarms.AlarmStatisticsListResultDocument;
import com.sun.netstorage.mgmt.fm.storade.schema.alarms.AlarmStatisticsReportGenerationResultDocument;
import com.sun.netstorage.mgmt.fm.storade.ui.util.Connection;
import com.sun.netstorage.mgmt.fm.storade.ui.util.Debug;
import com.sun.netstorage.mgmt.fm.storade.ui.util.LocalizeUtil;
import com.sun.netstorage.mgmt.fm.storade.ui.util.XmlUtil;
import java.net.URLEncoder;
import java.util.Locale;
import java.util.Properties;

public class Getter {
    private Getter() {
    }

    public static AlarmDetailsResultDocument getAlarmDetailsResultDocument(String id, boolean withSubEvents, Locale locale) {
        AlarmDetailsResultDocument result = null;
        try {
            String s = Connection.getComboHeader();
            s = s + "?GO=Client::Alarm::GetAlarm&format=xml" + "&event=" + URLEncoder.encode(id, "UTF-8");
            if (withSubEvents) {
                s = s + "&details=1";
            }
            locale = LocalizeUtil.resolveLocale(locale);
            s = s + "&locale=" + locale.toString();
            s = s + "&GO2=Client::Alarm::summary";
            String data = Connection.getData(s);
            Debug.println("REQUEST: " + s);
            Debug.println("DATA: " + data);
            data = XmlUtil.addHeader(data, "AlarmDetailsResult");
            result = AlarmDetailsResultDocument.Factory.parse((String)data);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public static AlarmListResultDocument getAlarmListResultDocument(Properties alarmProp) {
        AlarmListResultDocument result = null;
        String s = Connection.getComboHeader();
        s = s + "?GO=Client::Control::GetAlarms&format=xml";
        String assetID = alarmProp.getProperty("assetID");
        if (assetID != null) {
            s = s + "&key=" + URLEncoder.encode(assetID);
        }
        s = s + "&GO2=Client::Alarm::summary";
        try {
            String data = Connection.getData(s);
            Debug.println("REQUEST: " + s);
            Debug.println("DATA: " + data);
            data = XmlUtil.addHeader(data, "AlarmListResult");
            result = AlarmListResultDocument.Factory.parse((String)data);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public static AlarmStatisticsListResultDocument.AlarmStatisticsListResult getAlarmStatisticsYmd() {
        AlarmStatisticsListResultDocument.AlarmStatisticsListResult result = null;
        try {
            String s = Connection.getComboHeader();
            s = s + "?GO=Client::Alarm::summary";
            s = s + "&GO2=Client::EventReport::eventsYmd";
            String data = Connection.getData(s);
            Debug.println("REQUEST: " + s);
            Debug.println("DATA: " + data);
            data = XmlUtil.addHeader(data, "AlarmStatisticsListResult");
            AlarmStatisticsListResultDocument resultDoc = AlarmStatisticsListResultDocument.Factory.parse((String)data);
            result = resultDoc.getAlarmStatisticsListResult();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public static AlarmStatisticsListResultDocument.AlarmStatisticsListResult getAlarmStatisticsWeek() {
        AlarmStatisticsListResultDocument.AlarmStatisticsListResult result = null;
        try {
            String s = Connection.getComboHeader();
            s = s + "?GO=Client::Alarm::summary";
            s = s + "&GO2=Client::EventReport::eventsWeek";
            String data = Connection.getData(s);
            Debug.println("REQUEST: " + s);
            Debug.println("DATA: " + data);
            data = XmlUtil.addHeader(data, "AlarmStatisticsListResult");
            AlarmStatisticsListResultDocument resultDoc = AlarmStatisticsListResultDocument.Factory.parse((String)data);
            result = resultDoc.getAlarmStatisticsListResult();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public static AlarmStatisticsListResultDocument.AlarmStatisticsListResult getAlarmStatisticsDayOfWeek() {
        AlarmStatisticsListResultDocument.AlarmStatisticsListResult result = null;
        try {
            String s = Connection.getComboHeader();
            s = s + "?GO=Client::Alarm::summary";
            s = s + "&GO2=Client::EventReport::eventsDow";
            String data = Connection.getData(s);
            Debug.println("REQUEST: " + s);
            Debug.println("DATA: " + data);
            data = XmlUtil.addHeader(data, "AlarmStatisticsListResult");
            AlarmStatisticsListResultDocument resultDoc = AlarmStatisticsListResultDocument.Factory.parse((String)data);
            result = resultDoc.getAlarmStatisticsListResult();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public static AlarmStatisticsReportGenerationResultDocument.AlarmStatisticsReportGenerationResult getStatisticsReportsDate() {
        AlarmStatisticsReportGenerationResultDocument.AlarmStatisticsReportGenerationResult result = null;
        try {
            String s = Connection.getComboHeader();
            s = s + "?GO=Client::Alarm::summary";
            s = s + "&GO2=Client::EventReport::getReportsDate";
            String data = Connection.getData(s);
            Debug.println("REQUEST: " + s);
            Debug.println("DATA: " + data);
            data = XmlUtil.addHeader(data, "AlarmStatisticsReportGenerationResult");
            AlarmStatisticsReportGenerationResultDocument resultDoc = AlarmStatisticsReportGenerationResultDocument.Factory.parse((String)data);
            result = resultDoc.getAlarmStatisticsReportGenerationResult();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }
}

