/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.admin;

import com.iplanet.jato.model.DefaultModel;
import com.sun.netstorage.mgmt.fm.storade.schema.Value;
import com.sun.netstorage.mgmt.fm.storade.schema.admin.EmailContract;
import com.sun.netstorage.mgmt.fm.storade.schema.admin.EmailContractListResultDocument;
import com.sun.netstorage.mgmt.fm.storade.schema.admin.Filter;
import com.sun.netstorage.mgmt.fm.storade.schema.admin.FiltersResultDocument;
import com.sun.netstorage.mgmt.fm.storade.schema.admin.RenvResultDocument;
import com.sun.netstorage.mgmt.fm.storade.ui.common.AlarmConstants;
import com.sun.netstorage.mgmt.fm.storade.ui.model.ActionTableModel;
import com.sun.netstorage.mgmt.fm.storade.ui.util.AbbreviationUtil;
import com.sun.netstorage.mgmt.fm.storade.ui.util.Debug;
import com.sun.netstorage.mgmt.fm.storade.ui.util.LocalizeUtil;
import com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.admin.Getter;
import com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.admin.SNMPContract;
import com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.admin.Setter;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;

public class NotificationDataHelper {
    public static final int ERROR_INTERNAL = -999;
    public static final int ERROR_ADD_CONTRACTEXIST = -1;
    public static final int ERROR_MODIFY_CONTRACTNOTEXIST = -2;
    public static final int NO_ERROR = 0;
    public static final String SNMPACTION_ADD = "add";
    public static final String SNMPACTION_DELETE = "delete";
    public static final String SNMPACTION_MODIFY = "modify";
    public static final String sccs_id = "%Z%%M% %I%     %E% SMI";

    public static void populateEmailsTableModel(EmailContractListResultDocument.EmailContractListResult result, ActionTableModel emailsModel, Locale locale) throws IllegalArgumentException {
        if (result == null || locale == null || emailsModel == null) {
            throw new IllegalArgumentException("at least one parameter is null");
        }
        EmailContract[] emails = new EmailContract[]{};
        try {
            emails = result.getNOTIFICATION().getNOTIFArray();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        ArrayList<String> keys = new ArrayList<String>();
        int i = 0;
        while (i < emails.length) {
            EmailContract email = emails[i];
            if (i != 0) {
                emailsModel.appendRow();
            }
            Value[] values = email.getVALUEArray();
            String active = "Y";
            int j = 0;
            while (j < values.length) {
                Value value = values[j];
                if ("device".equals(value.getID())) {
                    if ("*".equals(value.getStringValue())) {
                        emailsModel.setValue("eventCategoryStr", "eventCategory.all");
                    } else {
                        emailsModel.setValue("eventCategoryStr", value.getStringValue());
                    }
                } else if ("email".equals(value.getID())) {
                    emailsModel.setValue("addressStr", value.getStringValue());
                } else if ("priority".equals(value.getID())) {
                    emailsModel.setValue("priorityStr", "priority." + value.getStringValue());
                } else if ("active".equals(value.getID())) {
                    active = value.getStringValue();
                }
                ++j;
            }
            if ("Y".equals(active)) {
                emailsModel.setValue("activeStr", "boolean.yes");
            } else {
                emailsModel.setValue("activeStr", "boolean.no");
            }
            emailsModel.setValue("EmailDetailsStoradeHREF", email.getID());
            emailsModel.setValue("viewEmailDetailsStr", "email.viewDetails");
            keys.add(email.getID());
            ++i;
        }
        String[] keysArr = new String[keys.size()];
        keys.toArray(keysArr);
        emailsModel.setKeys(keysArr);
    }

    public static void populateEmailDetailsTableModel(DefaultModel emailDetailsModel, String emailID, Locale locale) throws IllegalArgumentException {
        if (emailID == null || locale == null || emailDetailsModel == null) {
            throw new IllegalArgumentException("at least one parameter is null");
        }
        int size = 1;
        int i = 0;
        while (i < size) {
            if (i != 0) {
                emailDetailsModel.appendRow();
            }
            emailDetailsModel.setValue("propertyName", (Object)"table.header.emailAddress");
            emailDetailsModel.setValue("propertyValue", (Object)emailID);
            ++i;
        }
    }

    public static void populateSNMPContractsTableModel(RenvResultDocument.RenvResult result, ActionTableModel snmpsModel, Locale locale) throws IllegalArgumentException {
        if (result == null || locale == null || snmpsModel == null) {
            throw new IllegalArgumentException("at least one parameter is null");
        }
        Value[] values = result.getENV().getVALUEArray();
        Properties p = new Properties();
        int i = 0;
        while (i < values.length) {
            Value v = values[i];
            p.setProperty(v.getID(), v.getStringValue());
            ++i;
        }
        String total = p.getProperty("pro.trap.total");
        int totalInt = 0;
        if (total != null) {
            try {
                totalInt = new Integer(total);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        ArrayList<String> keys = new ArrayList<String>();
        int i2 = 1;
        while (i2 < totalInt + 1) {
            String ipKey = "pro.trap" + i2 + ".ip";
            String portKey = "pro.trap" + i2 + ".port";
            String levelKey = "pro.trap" + i2 + ".level";
            String ipValue = p.getProperty(ipKey);
            Object portValue = p.getProperty(portKey);
            try {
                portValue = Integer.valueOf((String)portValue);
            }
            catch (Exception ex) {
                // empty catch block
            }
            String levelValue = p.getProperty(levelKey);
            String levelString = "";
            int levelValueInt = -999;
            try {
                levelValueInt = new Integer(levelValue);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            levelString = levelValueInt == 0 ? "severity.notice" : AlarmConstants.getSeverityString(levelValueInt);
            if (i2 != 0) {
                snmpsModel.appendRow();
            }
            snmpsModel.setValue("hostStr", ipValue);
            snmpsModel.setValue("portStr", portValue);
            snmpsModel.setValue("minAlertLevelStr", levelString);
            keys.add(ipValue + "|" + portValue + "|" + levelValue);
            ++i2;
        }
        String[] keysArr = new String[keys.size()];
        keys.toArray(keysArr);
        snmpsModel.setKeys(keysArr);
    }

    public static synchronized int SNMPNotificationAction(SNMPContract[] snmps, String actionName) {
        if (snmps == null || actionName == null) {
            return -999;
        }
        ArrayList<SNMPContract> snmpList = new ArrayList<SNMPContract>();
        RenvResultDocument resultDoc = Getter.getRenvResultDocument();
        if (resultDoc == null) {
            return -999;
        }
        RenvResultDocument.RenvResult result = resultDoc.getRenvResult();
        Value[] values = result.getENV().getVALUEArray();
        Properties p = new Properties();
        int i = 0;
        while (i < values.length) {
            Value v = values[i];
            p.setProperty(v.getID(), v.getStringValue());
            ++i;
        }
        String total = p.getProperty("pro.trap.total");
        int totalInt = 0;
        if (total != null) {
            try {
                totalInt = new Integer(total);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        int i2 = 1;
        while (i2 < totalInt + 1) {
            String ipKey = "pro.trap" + i2 + ".ip";
            String portKey = "pro.trap" + i2 + ".port";
            String levelKey = "pro.trap" + i2 + ".level";
            String ipValue = p.getProperty(ipKey);
            String portValue = p.getProperty(portKey);
            String levelValue = p.getProperty(levelKey);
            snmpList.add(new SNMPContract(ipValue, portValue, levelValue));
            ++i2;
        }
        if (SNMPACTION_ADD.equals(actionName)) {
            if (snmps.length != 1) {
                return -999;
            }
            if (snmpList.contains(snmps[0])) {
                return -1;
            }
            snmpList.add(snmps[0]);
        }
        if (SNMPACTION_DELETE.equals(actionName)) {
            int i3 = 0;
            while (i3 < snmps.length) {
                snmpList.remove(snmps[i3]);
                ++i3;
            }
        }
        if (SNMPACTION_MODIFY.equals(actionName)) {
            if (snmps.length != 2) {
                return -999;
            }
            int pos = snmpList.indexOf(snmps[0]);
            if (pos == -1) {
                return -2;
            }
            snmpList.remove(pos);
            snmpList.add(pos, snmps[1]);
        }
        String setterCommand = "pro.trap.total=" + snmpList.size();
        int i4 = 0;
        while (i4 < snmpList.size()) {
            int ii = i4 + 1;
            SNMPContract sc = (SNMPContract)snmpList.get(i4);
            String ipKey = "pro.trap" + ii + ".ip";
            String portKey = "pro.trap" + ii + ".port";
            String levelKey = "pro.trap" + ii + ".level";
            setterCommand = setterCommand + "&" + ipKey + "=" + sc.getIpAddress() + "&" + portKey + "=" + sc.getPort() + "&" + levelKey + "=" + sc.getMinAlertLevel();
            ++i4;
        }
        Debug.println("setterCommand : " + setterCommand);
        Setter.setRenv(setterCommand);
        return 0;
    }

    public static void populateFiltersTableModel(FiltersResultDocument.FiltersResult result, ActionTableModel filtersModel, Locale locale) throws IllegalArgumentException {
        if (result == null || locale == null || filtersModel == null) {
            throw new IllegalArgumentException("at least one parameter is null");
        }
        Filter[] filters = new Filter[]{};
        try {
            filters = result.getFILTERS().getFILTERArray();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        ArrayList<String> keys = new ArrayList<String>();
        int i = 0;
        while (i < filters.length) {
            Filter filter = filters[i];
            if (i != 0) {
                filtersModel.appendRow();
            }
            Value[] values = filter.getVALUEArray();
            String deviceType = "";
            String eventCode = "";
            String dayFilter = "";
            String descrPattern = "";
            String newSeverity = "";
            int j = 0;
            while (j < values.length) {
                Value value = values[j];
                if ("type".equals(value.getID())) {
                    deviceType = value.getStringValue();
                    if ("".equals(deviceType)) {
                        deviceType = "filter.deviceType.all";
                    }
                } else if ("code".equals(value.getID())) {
                    eventCode = value.getStringValue();
                } else if ("pattern".equals(value.getID())) {
                    descrPattern = value.getStringValue();
                } else if ("days".equals(value.getID())) {
                    dayFilter = value.getStringValue();
                } else if ("severity".equals(value.getID())) {
                    newSeverity = value.getStringValue();
                }
                ++j;
            }
            filtersModel.setValue("filterIDStr", filter.getID());
            filtersModel.setValue("deviceTypeStr", AbbreviationUtil.getAbbreviation(deviceType, 2, locale));
            filtersModel.setValue("eventCodeStr", eventCode);
            filtersModel.setValue("dayFilterStr", NotificationDataHelper.getLocalizedDayFilter(dayFilter, locale));
            filtersModel.setValue("descrPatternStr", descrPattern);
            filtersModel.setValue("newSeverityStr", LocalizeUtil.getLocalizedString("filter.severity." + newSeverity, locale));
            keys.add(filter.getID());
            ++i;
        }
        String[] keysArr = new String[keys.size()];
        keys.toArray(keysArr);
        filtersModel.setKeys(keysArr);
    }

    private static String getLocalizedDayFilter(String dayFilter, Locale locale) {
        if (dayFilter == null || "".equals(dayFilter)) {
            return "";
        }
        String ret = "";
        StringTokenizer st = new StringTokenizer(dayFilter);
        int k = 0;
        while (st.hasMoreTokens()) {
            if (k % 3 == 0 && k != 0) {
                ret = ret + "<br>";
            }
            String s = st.nextToken();
            ret = ret + LocalizeUtil.getLocalizedString("dayFilter." + s, locale) + ", ";
            ++k;
        }
        if (ret.length() > 0) {
            ret = ret.substring(0, ret.length() - 2);
        }
        return ret;
    }

    static {
        ERROR_INTERNAL = -999;
        ERROR_ADD_CONTRACTEXIST = -1;
        ERROR_MODIFY_CONTRACTNOTEXIST = -2;
        NO_ERROR = 0;
        SNMPACTION_ADD = SNMPACTION_ADD;
        SNMPACTION_DELETE = SNMPACTION_DELETE;
        SNMPACTION_MODIFY = SNMPACTION_MODIFY;
        sccs_id = sccs_id;
    }
}

