/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.admin;

import com.sun.netstorage.mgmt.fm.storade.schema.admin.AgentStatistic;
import com.sun.netstorage.mgmt.fm.storade.schema.admin.AgentStatisticsResultDocument;
import com.sun.netstorage.mgmt.fm.storade.ui.model.ActionTableModel;
import com.sun.netstorage.mgmt.fm.storade.ui.util.AgentUtil;
import com.sun.netstorage.mgmt.fm.storade.ui.util.DeviceUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;

public class AgentStatisticsDataHelper {
    private AgentStatisticsDataHelper() {
    }

    public static void populateStatistics(AgentStatisticsResultDocument.AgentStatisticsResult result, ActionTableModel tableModel) {
        AgentStatistic[] elements;
        if (result != null && result.getAGENTSTATS() != null && (elements = result.getAGENTSTATS().getAGENTSTATArray()) != null) {
            ArrayList<String> hosts = new ArrayList<String>();
            int i = 0;
            while (i < elements.length) {
                hosts.add(elements[i].getHOST());
                ++i;
            }
            boolean unique = AgentUtil.unique(hosts);
            int i2 = 0;
            while (i2 < elements.length) {
                if (i2 != 0) {
                    tableModel.appendRow();
                }
                SimpleDateFormat formatter = new SimpleDateFormat("mm:ss");
                SimpleDateFormat formatter2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                Date lastRunDate = new Date();
                Date lastDuration = new Date();
                Date maxDuration = new Date();
                Date maxDurationDate = new Date();
                Date average = new Date();
                Object nbrRuns = elements[i2].getNUMBEROFRUNS();
                try {
                    lastRunDate = formatter2.parse(elements[i2].getLASTRUNDATE());
                    lastDuration = formatter.parse(elements[i2].getLASTDURATION());
                    maxDuration = formatter.parse(elements[i2].getMAXDURATION());
                    maxDurationDate = formatter2.parse(elements[i2].getMAXDURATIONDATE());
                    average = formatter.parse(elements[i2].getAVERAGE());
                    nbrRuns = Integer.valueOf((String)nbrRuns);
                }
                catch (ParseException ex) {
                    ex.printStackTrace();
                }
                String hostName = elements[i2].getHOST();
                if (unique) {
                    hostName = AgentUtil.getShortName(hostName);
                }
                String device = DeviceUtil.getDeviceName(elements[i2].getDEVICE());
                tableModel.setValue("agent", hostName);
                tableModel.setValue("device", device);
                tableModel.setValue("nbrRuns", nbrRuns);
                tableModel.setValue("lastRun", lastRunDate);
                tableModel.setValue("lastDuration", lastDuration);
                tableModel.setValue("maxDuration", maxDuration);
                tableModel.setValue("maxDurationDate", maxDurationDate);
                tableModel.setValue("average", average);
                ++i2;
            }
        }
    }
}

