/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.fm.storade.ui.util;

import com.sun.netstorage.mgmt.fm.storade.ui.util.Debug;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.HashMap;
import java.util.StringTokenizer;

public class Roles {
    private static final String ROLES_FILE = "/opt/SUNWstade/DATA/Roles";
    private static HashMap map;

    private static void loadProperties() {
        if (map == null) {
            map = new HashMap();
            Roles.readFile();
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void readFile() {
        File file = new File(ROLES_FILE);
        if (file.exists()) {
            try {
                String line;
                BufferedReader r = new BufferedReader(new FileReader(file));
                while ((line = r.readLine()) != null) {
                    void var2_3;
                    if (var2_3.length() == 0) continue;
                    StringTokenizer st = new StringTokenizer((String)var2_3, "\t");
                    String role = null;
                    String credential = null;
                    if (st.hasMoreTokens()) {
                        role = st.nextToken();
                        if (st.hasMoreTokens()) {
                            credential = st.nextToken();
                        }
                    }
                    if (role == null || credential == null) continue;
                    map.put(role, credential);
                }
            }
            catch (Exception ex) {
                Debug.println("Error reading Storade role file");
            }
        } else {
            Debug.println("Storade role file does not exist");
        }
    }

    public static String getRoleCredential(String user) {
        Roles.loadProperties();
        return (String)map.get(user);
    }

    public static String getRoleCredentialForPeer() {
        return Roles.getRoleCredential("peer");
    }

    static {
        ROLES_FILE = ROLES_FILE;
    }
}

