/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.fm.storade.ui.util;

import com.sun.netstorage.mgmt.fm.storade.ui.util.Debug;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

public class DelimUtil {
    private static final String DELIM = ":";
    private static final String DELIM_RESOURCES = "com.sun.netstorage.mgmt.fm.storade.ui.util.Delim";
    private static ResourceBundle rb;

    private DelimUtil() {
    }

    public static final String aggregate(String[] values) {
        if (values == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < values.length) {
            try {
                String value = values[i];
                if (value == null) {
                    value = "";
                }
                buffer.append(URLEncoder.encode(value, "UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            if (i != values.length - 1) {
                buffer.append(DELIM);
            }
            ++i;
        }
        return buffer.toString();
    }

    public static final String[] desaggregate(String value) {
        if (value == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(value, DELIM);
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            try {
                s = URLDecoder.decode(s, "UTF-8");
            }
            catch (UnsupportedEncodingException ex) {
                // empty catch block
            }
            list.add(s);
        }
        String[] valuesArray = new String[list.size()];
        list.toArray(valuesArray);
        return valuesArray;
    }

    public static final String compose(String header, String[] values) {
        if (header == null || values == null) {
            return null;
        }
        String ret = header + ".";
        int i = 0;
        while (i < values.length - 1) {
            ret = ret + URLEncoder.encode(values[i]) + DELIM;
            ++i;
        }
        ret = ret + URLEncoder.encode(values[values.length - 1]);
        return ret;
    }

    public static final String decompose(String inStr) {
        if (inStr == null) {
            return null;
        }
        if (rb == null) {
            try {
                rb = ResourceBundle.getBundle(DELIM_RESOURCES);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        int dotPos = inStr.indexOf(".");
        String header = inStr.substring(0, dotPos);
        String body = inStr.substring(dotPos + 1);
        String ret = "";
        String nameFormat = rb.getString(header);
        StringTokenizer value_st = new StringTokenizer(body, DELIM);
        StringTokenizer name_st = new StringTokenizer(nameFormat, DELIM);
        if (name_st.countTokens() != value_st.countTokens()) {
            Debug.println("DelimUtil Error: the size of name and value not match");
        } else {
            int urlMarker = 63;
            while (name_st.hasMoreTokens()) {
                ret = ret + (char)urlMarker + name_st.nextToken() + "=" + value_st.nextToken();
                urlMarker = 38;
            }
        }
        return ret;
    }

    public static void main(String[] args) {
        String toTableStr = DelimUtil.compose("TestLink", new String[]{"1234", "dsp1", "2"});
        System.out.println(toTableStr);
        String linkStr = DelimUtil.decompose(toTableStr);
        System.out.println(linkStr);
    }

    static {
        DELIM = DELIM;
        DELIM_RESOURCES = DELIM_RESOURCES;
    }
}

