/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.fm.storade.ui.util;

import com.sun.netstorage.mgmt.fm.storade.ui.util.Debug;
import com.sun.netstorage.mgmt.fm.storade.ui.util.SecureConnection;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.URL;
import sun.misc.BASE64Encoder;

public class Connection {
    private static final String HTTPS = "https";
    private static String fqhostname;
    private static boolean authAttempt;
    private static String auth;
    private static final String IPC_ROLE_PATH = "/opt/SUNWstade/DATA/IPC_Access";

    public static HttpURLConnection getConnection(String s) throws Exception {
        URL url = new URL(s);
        HttpURLConnection uc = url.getProtocol().equals(HTTPS) ? SecureConnection.get(url, url.getHost()) : (HttpURLConnection)url.openConnection();
        uc.setRequestProperty("User-Agent", " storade_7654");
        uc.setRequestProperty("Authorization", "Basic " + Connection.getIPCAuthentication());
        uc.setDoOutput(true);
        return uc;
    }

    public static InputStream getInputStream(String s) throws Exception {
        long start = System.currentTimeMillis();
        URL url = new URL(s);
        HttpURLConnection uc = url.getProtocol().equals(HTTPS) ? SecureConnection.get(url, url.getHost()) : (HttpURLConnection)url.openConnection();
        uc.setRequestProperty("Authorization", "Basic " + Connection.getIPCAuthentication());
        InputStream in = uc.getInputStream();
        long end = System.currentTimeMillis();
        Debug.println("RETRIEVAL TIME: " + (end - start));
        return in;
    }

    public static String getData(String s) throws Exception {
        int bytesRead;
        long start = System.currentTimeMillis();
        InputStream is = Connection.getInputStream(s);
        StringBuffer buffer = new StringBuffer();
        InputStreamReader isr = new InputStreamReader(is, "UTF-8");
        BufferedReader in = new BufferedReader(isr);
        char[] cbuf = new char[2048];
        while ((bytesRead = in.read(cbuf)) != -1) {
            buffer.append(cbuf, 0, bytesRead);
        }
        in.close();
        long end = System.currentTimeMillis();
        Debug.println("GET DATA TIME: " + (end - start));
        return buffer.toString();
    }

    public static String postData(String s, String data) throws Exception {
        int bytesRead;
        long start = System.currentTimeMillis();
        URL url = new URL(s);
        HttpURLConnection uc = url.getProtocol().equals(HTTPS) ? SecureConnection.get(url, url.getHost()) : (HttpURLConnection)url.openConnection();
        uc.setDoOutput(true);
        uc.setRequestMethod("POST");
        uc.setRequestProperty("Authorization", "Basic " + Connection.getIPCAuthentication());
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        PrintWriter out = new PrintWriter(byteStream, true);
        out.print(data);
        out.flush();
        uc.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        uc.connect();
        byteStream.writeTo(uc.getOutputStream());
        BufferedInputStream is = new BufferedInputStream(uc.getInputStream());
        StringBuffer buffer = new StringBuffer();
        InputStreamReader isr = new InputStreamReader((InputStream)is, "UTF-8");
        BufferedReader in = new BufferedReader(isr);
        char[] cbuf = new char[2048];
        while ((bytesRead = in.read(cbuf)) != -1) {
            buffer.append(cbuf, 0, bytesRead);
        }
        in.close();
        long end = System.currentTimeMillis();
        Debug.println("GET DATA TIME: " + (end - start));
        return buffer.toString();
    }

    public static Reader getReader(String s) throws Exception {
        URL url = new URL(s);
        HttpURLConnection uc = url.getProtocol().equals(HTTPS) ? SecureConnection.get(url, url.getHost()) : (HttpURLConnection)url.openConnection();
        uc.setRequestProperty("Authorization", "Basic " + Connection.getIPCAuthentication());
        InputStream in = uc.getInputStream();
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        return reader;
    }

    public static String getHostname() {
        String hostname = System.getProperty("storade.host");
        if (hostname == null || hostname.trim().equals("")) {
            return "localhost";
        }
        return hostname;
    }

    public static String getPort() {
        String port = System.getProperty("storade.port");
        if (port == null || port.trim().equals("")) {
            return "7654";
        }
        return port;
    }

    public static String getProtocol() {
        String protocol = System.getProperty("storade.protocol");
        if (protocol == null || protocol.trim().equals("")) {
            return "http";
        }
        return protocol;
    }

    public static String getHeader() {
        String header = System.getProperty("storade.urlHeader");
        if (header == null || header.trim().equals("")) {
            return "rashttp";
        }
        return header;
    }

    public static String getRascgiHeader() {
        return "rascgi";
    }

    public static String getRascgiComboHeader() {
        return Connection.getProtocol() + "://" + Connection.getHostname() + ":" + Connection.getPort() + "/" + Connection.getRascgiHeader();
    }

    public static String getComboHeader() {
        return Connection.getProtocol() + "://" + Connection.getHostname() + ":" + Connection.getPort() + "/" + Connection.getHeader();
    }

    public static String getAppName() {
        String name = System.getProperty("storade.name");
        if (name == null || name.trim().equals("")) {
            return "storade";
        }
        return name;
    }

    public static String getFullyQualifiedHostname() {
        return fqhostname;
    }

    public static void setFullyQualifiedHostname(String fqh) {
        fqhostname = fqh;
    }

    public static String getMyBestIP() {
        String ip;
        if ("localhost".equals(Connection.getHostname()) && (ip = Connection.getFullyQualifiedHostname()) != null && !ip.equals("")) {
            return ip;
        }
        ip = "localhost";
        try {
            ip = InetAddress.getLocalHost().getHostName();
            if (ip.indexOf(46) == -1) {
                ip = InetAddress.getLocalHost().getHostAddress();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return ip;
    }

    public static String getMyIP() {
        String ip = "localhost";
        try {
            ip = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return ip;
    }

    public static String getMyProtocol() {
        return HTTPS;
    }

    public static String getMyPort() {
        return "6789";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized String getIPCAuthentication() {
        FileInputStream fis;
        block10: {
            if (authAttempt) {
                return auth;
            }
            fis = null;
            File ipcFile = new File(IPC_ROLE_PATH);
            if (ipcFile.exists()) {
                fis = new FileInputStream(IPC_ROLE_PATH);
                BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)fis, "UTF8"));
                String userPasswd = in.readLine().trim();
                auth = new BASE64Encoder().encode(userPasswd.getBytes());
                break block10;
            }
            String userPasswd = "peer:peer";
            auth = new BASE64Encoder().encode(userPasswd.getBytes());
        }
        Object var5_6 = null;
        authAttempt = true;
        if (fis == null) return auth;
        try {
            fis.close();
            return auth;
        }
        catch (Exception e2) {}
        return auth;
        {
            catch (Exception e) {
                auth = null;
                Object var5_7 = null;
                authAttempt = true;
                if (fis == null) return auth;
                try {
                    fis.close();
                    return auth;
                }
                catch (Exception e2) {}
                return auth;
            }
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            authAttempt = true;
            if (fis == null) throw throwable;
            try {
                fis.close();
                throw throwable;
            }
            catch (Exception e2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    static {
        HTTPS = HTTPS;
        System.setProperty("java.protocol.handler.pkgs", "javax.net.ssl");
        IPC_ROLE_PATH = IPC_ROLE_PATH;
    }
}

