/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.fm.storade.ui.util;

import com.sun.netstorage.mgmt.fm.storade.ui.util.App;
import com.sun.netstorage.mgmt.fm.storade.ui.util.Debug;
import com.sun.netstorage.mgmt.fm.storade.ui.util.Nav;
import com.sun.netstorage.mgmt.fm.storade.ui.util.NavMap;
import com.sun.netstorage.mgmt.fm.storade.ui.util.SubTask;
import com.sun.netstorage.mgmt.fm.storade.ui.util.Task;
import java.io.FileReader;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class ApplicationsParser {
    private static String APP = "app";
    private static String NAME = "name";
    private static String TASK = "task";
    private static String SUBTASK = "subTask";
    private static String NAVMAP = "navMap";
    private static String NAV = "nav";
    private static String KEY = "key";
    private static String TARGET = "target";
    private static String DEFAULTTARGET = "defaultTarget";
    private static String DEFAULTPAGENAME = "defaultPageName";
    private static String USECONTEXT = "useContext";
    private static String CHECKPASSWORD = "checkPassword";
    private static String AMP = "amp";
    private static String LT = "lt";
    private static String GT = "gt";
    private static String QUOT = "\"";

    private String getText(Node node) {
        NodeList nodeList = node.getChildNodes();
        String text = null;
        int i = 0;
        while (i < nodeList.getLength()) {
            Node cnode = nodeList.item(i);
            switch (cnode.getNodeType()) {
                case 1: {
                    break;
                }
                case 3: {
                    if (text == null) {
                        text = cnode.getNodeValue().trim();
                        break;
                    }
                    text = text + cnode.getNodeValue().trim();
                }
                case 4: {
                    break;
                }
                case 2: {
                    break;
                }
                case 5: {
                    if (AMP.equals(cnode.getNodeName())) {
                        text = text + '&';
                        break;
                    }
                    if (LT.equals(cnode.getNodeName())) {
                        text = text + '<';
                        break;
                    }
                    if (GT.equals(cnode.getNodeName())) {
                        text = text + '>';
                        break;
                    }
                    if (!QUOT.equals(cnode.getNodeName())) break;
                    text = text + '\"';
                }
            }
            ++i;
        }
        return text;
    }

    private NavMap parseNavMap(Node node) {
        Node defaultPageName;
        NavMap navMap = new NavMap();
        NamedNodeMap attributes = node.getAttributes();
        Node defaultTarget = attributes.getNamedItem(DEFAULTTARGET);
        if (defaultTarget != null) {
            navMap.defaultTarget = defaultTarget.getNodeValue().trim();
        }
        if ((defaultPageName = attributes.getNamedItem(DEFAULTPAGENAME)) != null) {
            navMap.defaultPageName = defaultPageName.getNodeValue().trim();
        }
        NodeList children = node.getChildNodes();
        int j = 0;
        while (j < children.getLength()) {
            Node cnode = children.item(j);
            switch (cnode.getNodeType()) {
                case 1: {
                    String n = cnode.getNodeName();
                    if (!NAV.equalsIgnoreCase(n)) break;
                    Nav nav = this.parseNav(cnode);
                    navMap.navs.add(nav);
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    break;
                }
            }
            ++j;
        }
        return navMap;
    }

    private Nav parseNav(Node node) {
        Nav nav = new Nav();
        NodeList children = node.getChildNodes();
        int j = 0;
        while (j < children.getLength()) {
            Node cnode = children.item(j);
            switch (cnode.getNodeType()) {
                case 1: {
                    String n = cnode.getNodeName().trim();
                    if (KEY.equalsIgnoreCase(n)) {
                        nav.key = this.getText(cnode);
                        break;
                    }
                    if (!TARGET.equalsIgnoreCase(n)) break;
                    nav.target = this.getText(cnode);
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    break;
                }
            }
            ++j;
        }
        return nav;
    }

    private SubTask parseSubTask(Node node) {
        SubTask subTask = new SubTask();
        NodeList children = node.getChildNodes();
        int j = 0;
        while (j < children.getLength()) {
            Node cnode = children.item(j);
            switch (cnode.getNodeType()) {
                case 1: {
                    String n = cnode.getNodeName().trim();
                    if (NAME.equalsIgnoreCase(n)) {
                        subTask.name = this.getText(cnode);
                        break;
                    }
                    if (NAVMAP.equalsIgnoreCase(n)) {
                        subTask.navMap = this.parseNavMap(cnode);
                        break;
                    }
                    if (USECONTEXT.equalsIgnoreCase(n)) {
                        subTask.useContext = this.getText(cnode);
                        break;
                    }
                    if (!CHECKPASSWORD.equalsIgnoreCase(n)) break;
                    subTask.checkPassword = this.getText(cnode);
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    break;
                }
            }
            ++j;
        }
        return subTask;
    }

    private Task parseTask(Node node) {
        Task task = new Task();
        NodeList children = node.getChildNodes();
        int j = 0;
        while (j < children.getLength()) {
            Node cnode = children.item(j);
            switch (cnode.getNodeType()) {
                case 1: {
                    String n = cnode.getNodeName().trim();
                    if (NAME.equalsIgnoreCase(n)) {
                        task.name = this.getText(cnode);
                        break;
                    }
                    if (SUBTASK.equalsIgnoreCase(n)) {
                        SubTask subTask = this.parseSubTask(cnode);
                        task.subTasks.add(subTask);
                        break;
                    }
                    if (NAVMAP.equalsIgnoreCase(n)) {
                        task.navMap = this.parseNavMap(cnode);
                        break;
                    }
                    if (USECONTEXT.equalsIgnoreCase(n)) {
                        task.useContext = this.getText(cnode);
                        break;
                    }
                    if (!CHECKPASSWORD.equalsIgnoreCase(n)) break;
                    task.checkPassword = this.getText(cnode);
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    break;
                }
            }
            ++j;
        }
        return task;
    }

    private App parseApp(Node node) {
        App app = new App();
        NodeList children = node.getChildNodes();
        int j = 0;
        while (j < children.getLength()) {
            Node cnode = children.item(j);
            switch (cnode.getNodeType()) {
                case 1: {
                    String n = cnode.getNodeName();
                    if (NAME.equalsIgnoreCase(n)) {
                        app.name = this.getText(cnode);
                        break;
                    }
                    if (TASK.equalsIgnoreCase(n)) {
                        Task task = this.parseTask(cnode);
                        app.tasks.add(task);
                        break;
                    }
                    if (NAVMAP.equalsIgnoreCase(n)) {
                        app.navMap = this.parseNavMap(cnode);
                        break;
                    }
                    if (USECONTEXT.equalsIgnoreCase(n)) {
                        app.useContext = this.getText(cnode);
                        break;
                    }
                    if (!CHECKPASSWORD.equalsIgnoreCase(n)) break;
                    app.checkPassword = this.getText(cnode);
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    break;
                }
            }
            ++j;
        }
        return app;
    }

    public ArrayList parse(String fileName) throws Exception {
        ArrayList<App> applications = new ArrayList<App>();
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setValidating(false);
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.parse(new InputSource(new FileReader(fileName)));
        Element node = doc.getDocumentElement();
        if ("applications".equalsIgnoreCase(node.getNodeName())) {
            NodeList children = node.getChildNodes();
            int j = 0;
            while (j < children.getLength()) {
                Node cnode = children.item(j);
                if (APP.equalsIgnoreCase(cnode.getNodeName())) {
                    App app = this.parseApp(cnode);
                    applications.add(app);
                }
                ++j;
            }
        }
        return applications;
    }

    public static void main(String[] args) throws Exception {
        ApplicationsParser p = new ApplicationsParser();
        ArrayList l = p.parse(args[0]);
        int i = 0;
        while (i < l.size()) {
            App app = (App)l.get(i);
            Debug.println("APP NAME: " + app.name);
            Debug.println("APP Default Target:  " + app.navMap.defaultTarget);
            Debug.println("APP Default Page Name:  " + app.navMap.defaultPageName);
            int e = 0;
            while (e < app.navMap.navs.size()) {
                Nav nav = (Nav)app.navMap.navs.get(e);
                Debug.println("APP Targets:  " + nav.key + " " + nav.target);
                ++e;
            }
            int j = 0;
            while (j < app.tasks.size()) {
                Task task = (Task)app.tasks.get(j);
                Debug.println("  TASK NAME: " + task.name);
                Debug.println("  TASK Default Target:  " + task.navMap.defaultTarget);
                Debug.println(" TASK Default Page Name:  " + task.navMap.defaultPageName);
                int f = 0;
                while (f < task.navMap.navs.size()) {
                    Nav nav = (Nav)task.navMap.navs.get(f);
                    Debug.println("  TASK Targets:  " + nav.key + " " + nav.target);
                    ++f;
                }
                int k = 0;
                while (k < task.subTasks.size()) {
                    SubTask subTask = (SubTask)task.subTasks.get(k);
                    Debug.println("     SUBTASK NAME: " + subTask.name);
                    Debug.println("     SUBTASK Default Target:  " + subTask.navMap.defaultTarget);
                    Debug.println("     SUBTASK Default Page Name:  " + subTask.navMap.defaultPageName);
                    int m = 0;
                    while (m < subTask.navMap.navs.size()) {
                        Nav nav = (Nav)subTask.navMap.navs.get(m);
                        Debug.println("       SUBTASK Targets:  " + nav.key + " " + nav.target);
                        ++m;
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }
}

