/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.fm.storade.ui.common;

import com.sun.netstorage.mgmt.fm.storade.ui.util.Connection;
import com.sun.web.ui.view.alarm.CCAlarmObject;

public class AlarmConstants {
    public static final int SEVERITY_DOWN = 3;
    public static final int SEVERITY_CRITICAL = 2;
    public static final int SEVERITY_MAJOR = 1;
    public static final int SEVERITY_MINOR = Integer.MIN_VALUE;
    public static final int SEVERITY_INFO = 1;
    public static final String SEVERITY_DOWN_STR = "severity.down";
    public static final String SEVERITY_CRITICAL_STR = "severity.critical";
    public static final String SEVERITY_MAJOR_STR = "severity.major";
    public static final String SEVERITY_MINOR_STR = "severity.minor";
    private static final String SEVERITY_DOWN_IMAGE = "/images/down_medium.gif";
    private static final String SEVERITY_CRITICAL_IMAGE = "/images/critical_medium.gif";
    private static final String SEVERITY_MAJOR_IMAGE = "/images/major_medium.gif";
    private static final String SEVERITY_MINOR_IMAGE = "/images/minor_medium.gif";

    private AlarmConstants() {
    }

    public static String getSeverityImage(int severityInt) {
        String severityImage = "/" + Connection.getAppName() + SEVERITY_MINOR_IMAGE;
        switch (severityInt) {
            case 3: {
                severityImage = "/" + Connection.getAppName() + SEVERITY_DOWN_IMAGE;
                break;
            }
            case 1: {
                severityImage = "/" + Connection.getAppName() + SEVERITY_MAJOR_IMAGE;
                break;
            }
            case 2: {
                severityImage = "/" + Connection.getAppName() + SEVERITY_CRITICAL_IMAGE;
            }
        }
        return severityImage;
    }

    public static String getSeverityString(int severityInt) {
        String severityStr = SEVERITY_MINOR_STR;
        switch (severityInt) {
            case 3: {
                severityStr = SEVERITY_DOWN_STR;
                break;
            }
            case 1: {
                severityStr = SEVERITY_MAJOR_STR;
                break;
            }
            case 2: {
                severityStr = SEVERITY_CRITICAL_STR;
            }
        }
        return severityStr;
    }

    public static CCAlarmObject getSeverityObject(int severityInt) {
        CCAlarmObject alarm = new CCAlarmObject(4);
        switch (severityInt) {
            case 3: {
                alarm = new CCAlarmObject(1);
                break;
            }
            case 1: {
                alarm = new CCAlarmObject(3);
                break;
            }
            case 2: {
                alarm = new CCAlarmObject(2);
            }
        }
        return alarm;
    }

    static {
        SEVERITY_DOWN = 3;
        SEVERITY_CRITICAL = 2;
        SEVERITY_MAJOR = 1;
        SEVERITY_MINOR = Integer.MIN_VALUE;
        SEVERITY_INFO = 1;
        SEVERITY_DOWN_STR = SEVERITY_DOWN_STR;
        SEVERITY_CRITICAL_STR = SEVERITY_CRITICAL_STR;
        SEVERITY_MAJOR_STR = SEVERITY_MAJOR_STR;
        SEVERITY_MINOR_STR = SEVERITY_MINOR_STR;
        SEVERITY_DOWN_IMAGE = SEVERITY_DOWN_IMAGE;
        SEVERITY_CRITICAL_IMAGE = SEVERITY_CRITICAL_IMAGE;
        SEVERITY_MAJOR_IMAGE = SEVERITY_MAJOR_IMAGE;
        SEVERITY_MINOR_IMAGE = SEVERITY_MINOR_IMAGE;
    }
}

