/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.util.rmi;

import com.sun.netstorage.mgmt.esm.util.rmi.RMISSLConstants;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.ServerSocket;
import java.rmi.RemoteException;
import java.rmi.server.RMIServerSocketFactory;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.Properties;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.TrustManagerFactory;

public final class RMISSLServerSocketFactory
implements RMIServerSocketFactory,
RMISSLConstants {
    private SSLContext sslContext;
    private final Object stateLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerSocket createServerSocket(int n) throws IOException {
        try {
            Object object = this.stateLock;
            synchronized (object) {
                if (this.sslContext == null) {
                    this.initializeSSLContext();
                }
            }
            SSLServerSocket sSLServerSocket = (SSLServerSocket)this.sslContext.getServerSocketFactory().createServerSocket(n);
            sSLServerSocket.setNeedClientAuth(true);
            return sSLServerSocket;
        }
        catch (Exception exception) {
            throw new RemoteException("Failure creating server socket", exception);
        }
    }

    private void initializeSSLContext() throws IOException, GeneralSecurityException {
        this.initializeKeystorePasswords();
        char[] cArray = System.getProperty("esm.util.rmi.keystore_pwd").toCharArray();
        FileInputStream fileInputStream = new FileInputStream(System.getProperty("esm.util.rmi.keystore"));
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        keyStore.load(fileInputStream, cArray);
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        keyManagerFactory.init(keyStore, cArray);
        char[] cArray2 = System.getProperty("esm.util.rmi.truststore_pwd").toCharArray();
        FileInputStream fileInputStream2 = new FileInputStream(System.getProperty("esm.util.rmi.truststore"));
        KeyStore keyStore2 = KeyStore.getInstance(KeyStore.getDefaultType());
        keyStore2.load(fileInputStream2, cArray2);
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(keyStore2);
        this.sslContext = SSLContext.getInstance("TLS");
        this.sslContext.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), null);
    }

    private void initializeKeystorePasswords() {
        if (System.getProperty("esm.util.rmi.pwd_filename") == null) {
            return;
        }
        try {
            Properties properties = new Properties();
            properties.load(new FileInputStream(System.getProperty("esm.util.rmi.pwd_filename")));
            System.setProperty("esm.util.rmi.keystore_pwd", properties.getProperty("keystore_pwd", System.getProperty("esm.util.rmi.keystore_pwd")));
            System.setProperty("esm.util.rmi.truststore_pwd", properties.getProperty("truststore_pwd", System.getProperty("esm.util.rmi.truststore_pwd")));
        }
        catch (Exception exception) {
            return;
        }
    }
}

