/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.util.javadoc.taglets;

import com.sun.javadoc.Tag;
import com.sun.netstorage.mgmt.esm.util.javadoc.taglets.TagScopes;
import com.sun.tools.doclets.Taglet;
import java.util.Map;

public abstract class AbstractTaglet
implements Taglet {
    private static final String SCCS_ID = "@(#)AbstractTaglet.java 1.2   03/04/25 SMI";
    private final String myName;
    private final boolean myInlineTag;
    private final TagScopes myTagScopes = new TagScopes();
    private final String myTitle;
    private String myHeader = null;
    private String myHeaderColor = null;
    private boolean myHeaderBold = true;
    private boolean myHeaderItalic = false;

    public static void register(Map map, Taglet taglet) {
        String string = taglet.getName();
        Taglet taglet2 = (Taglet)map.get(string);
        if (taglet2 != null) {
            map.remove(string);
        }
        map.put(string, taglet);
    }

    protected AbstractTaglet(String string, String string2, boolean bl) {
        this.myName = string;
        this.myTitle = string2;
        this.myInlineTag = bl;
    }

    protected AbstractTaglet(String string, String string2) {
        this(string, string2, false);
    }

    protected AbstractTaglet(String string, boolean bl) {
        this(string, null, bl);
    }

    protected AbstractTaglet(String string) {
        this(string, false);
    }

    protected final TagScopes getTagScopes() {
        return this.myTagScopes;
    }

    protected final String getTitle() {
        return this.myTitle;
    }

    protected final String getHeader() {
        if (this.myHeader == null) {
            this.buildHeader();
        }
        return this.myHeader;
    }

    protected final void setHeader(String string) {
        this.myHeader = string;
    }

    protected abstract void buildHeader();

    protected final boolean hasHeaderColor() {
        return this.myHeaderColor != null;
    }

    protected final String getHeaderColor() {
        if (this.myHeaderColor == null) {
            this.myHeaderColor = "black";
        }
        return this.myHeaderColor;
    }

    protected final void setHeaderColor(String string) {
        this.myHeaderColor = string;
    }

    protected final boolean isHeaderBold() {
        return this.myHeaderBold;
    }

    protected final void setHeaderBold(boolean bl) {
        this.myHeaderBold = bl;
    }

    protected final boolean isHeaderItalic() {
        return this.myHeaderItalic;
    }

    protected final void setHeaderItalic(boolean bl) {
        this.myHeaderItalic = bl;
    }

    protected String markupTags(Tag[] tagArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (tagArray != null && n < tagArray.length) {
            String string;
            Tag tag = tagArray[n];
            String string2 = string = tag != null ? this.markupTagText(tag.text()) : "null";
            if (n > 0) {
                stringBuffer.append(", <br>");
            }
            stringBuffer.append(string);
            ++n;
        }
        return stringBuffer.toString();
    }

    protected String markupTagText(String string) {
        return string;
    }

    public final String getName() {
        return this.myName;
    }

    public final boolean isInlineTag() {
        return this.myInlineTag;
    }

    public final boolean inOverview() {
        return this.getTagScopes().getOverviewScope().isTagAllowed();
    }

    public final boolean inPackage() {
        return this.getTagScopes().getPackageScope().isTagAllowed();
    }

    public final boolean inType() {
        return this.getTagScopes().getTypeScope().isTagAllowed();
    }

    public final boolean inConstructor() {
        return this.getTagScopes().getConstructorScope().isTagAllowed();
    }

    public final boolean inMethod() {
        return this.getTagScopes().getMethodScope().isTagAllowed();
    }

    public final boolean inField() {
        return this.getTagScopes().getFieldScope().isTagAllowed();
    }

    public String toString(Tag tag) {
        return this.toString(new Tag[]{tag});
    }

    public String toString(Tag[] tagArray) {
        if (tagArray == null || tagArray.length == 0) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<dt>");
        if (this.isHeaderBold()) {
            stringBuffer.append("<b>");
        }
        if (this.isHeaderItalic()) {
            stringBuffer.append("<i>");
        }
        if (this.hasHeaderColor()) {
            stringBuffer.append("<font color=\"");
            stringBuffer.append(this.getHeaderColor());
            stringBuffer.append("\">");
        }
        stringBuffer.append(this.getHeader());
        if (this.hasHeaderColor()) {
            stringBuffer.append("</font>");
        }
        if (this.isHeaderItalic()) {
            stringBuffer.append("</i>");
        }
        if (this.isHeaderBold()) {
            stringBuffer.append("</b>");
        }
        stringBuffer.append("</dt>");
        stringBuffer.append("\n");
        stringBuffer.append("<dd>");
        stringBuffer.append(this.markupTags(tagArray));
        stringBuffer.append("</dd>");
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }
}

