/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.component.model.api.cim;

import com.sun.netstorage.mgmt.component.model.PersistentObject;
import com.sun.netstorage.mgmt.component.model.api.cim.CIMAggregationModelBean;
import com.sun.netstorage.mgmt.component.model.api.cim.CIMAssociationModelBean;
import com.sun.netstorage.mgmt.component.model.api.cim.CIMModelBean;
import com.sun.netstorage.mgmt.component.model.api.cim.Context;
import com.sun.netstorage.mgmt.component.model.api.cim.ContextImpl;
import com.sun.netstorage.mgmt.component.model.api.cim.DiscoveryStatus;
import com.sun.netstorage.mgmt.component.model.engine.PersistenceException;
import com.sun.netstorage.mgmt.component.model.engine.PersistenceManager;
import com.sun.netstorage.mgmt.component.model.engine.Transaction;
import com.sun.netstorage.mgmt.component.model.engine.TransactionException;
import com.sun.netstorage.mgmt.component.model.query.EqualsFilter;
import com.sun.netstorage.mgmt.component.model.query.Filter;
import com.sun.netstorage.mgmt.component.model.query.OrFilter;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;

public class CIMPersistenceManager {
    private static CIMPersistenceManager theInstance_ = null;
    static final String sccs_id = "@(#)CIMPersistenceManager.java 1.21   02/02/13 SMI";

    private CIMPersistenceManager() {
    }

    public static synchronized CIMPersistenceManager getInstance() {
        if (theInstance_ == null) {
            theInstance_ = new CIMPersistenceManager();
        }
        return theInstance_;
    }

    public static Context createContext() {
        return new ContextImpl();
    }

    public static Transaction createTransaction() throws TransactionException {
        try {
            return PersistenceManager.getInstance().getTransaction();
        }
        catch (PersistenceException persistenceException) {
            throw new TransactionException(persistenceException);
        }
    }

    public static void releaseTransaction(Transaction transaction) {
        try {
            PersistenceManager.getInstance().releaseTransaction(transaction);
        }
        catch (PersistenceException persistenceException) {}
    }

    public CIMModelBean[] get(Context context, Class clazz, Filter filter) throws PersistenceException {
        Transaction transaction = context.getTransaction();
        ArrayList<PersistentObject> arrayList = new ArrayList<PersistentObject>();
        HashSet<String> hashSet = new HashSet<String>();
        try {
            PersistentObject[] persistentObjectArray = transaction.get(clazz, filter);
            int n = 0;
            while (n < persistentObjectArray.length) {
                CIMModelBean cIMModelBean = (CIMModelBean)persistentObjectArray[n];
                String string = cIMModelBean.getStoredClassName();
                if (!cIMModelBean.getFullyQualifiedBeanName().equals(string)) {
                    if (!hashSet.contains(string)) {
                        hashSet.add(string);
                        Class<?> clazz2 = Class.forName(string);
                        PersistentObject[] persistentObjectArray2 = transaction.get(clazz2, filter);
                        arrayList.addAll(Arrays.asList(persistentObjectArray2));
                    }
                } else {
                    arrayList.add(cIMModelBean);
                }
                ++n;
            }
            return arrayList.toArray(new CIMModelBean[arrayList.size()]);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new PersistenceException(classNotFoundException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CIMModelBean[] get(Class clazz, Filter filter) throws PersistenceException, TransactionException {
        CIMModelBean[] cIMModelBeanArray;
        Transaction transaction = null;
        try {
            Context context = CIMPersistenceManager.createContext();
            transaction = CIMPersistenceManager.createTransaction();
            context.setTransaction(transaction);
            cIMModelBeanArray = this.get(context, clazz, filter);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            CIMPersistenceManager.releaseTransaction(transaction);
            throw throwable;
        }
        CIMPersistenceManager.releaseTransaction(transaction);
        return cIMModelBeanArray;
    }

    public CIMModelBean[] getAll(Class clazz) throws PersistenceException, TransactionException {
        return this.get(clazz, null);
    }

    public CIMModelBean[] getAll(Context context, Class clazz) throws PersistenceException {
        return this.get(context, clazz, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CIMModelBean[] getAllAssociations(Context context, CIMModelBean cIMModelBean) throws PersistenceException {
        CIMModelBean[] cIMModelBeanArray;
        Transaction transaction = context.getTransaction();
        Statement statement = null;
        try {
            try {
                ArrayList<CIMModelBean> arrayList = new ArrayList<CIMModelBean>();
                String string = "select distinct AssociationName from " + new CIMAssociationModelBean().getBeanName();
                statement = transaction.sendStatement(string);
                ResultSet resultSet = statement.getResultSet();
                if (resultSet != null) {
                    while (resultSet.next()) {
                        cIMModelBeanArray = resultSet.getString("AssociationName");
                        Class<?> clazz = Class.forName("com.sun.netstorage.mgmt.component.model.domain." + (String)cIMModelBeanArray);
                        CIMModelBean[] cIMModelBeanArray2 = this.getAssociations(cIMModelBean, clazz);
                        arrayList.addAll(Arrays.asList(cIMModelBeanArray2));
                    }
                }
                cIMModelBeanArray = arrayList.toArray(new CIMModelBean[arrayList.size()]);
                Object var12_12 = null;
                if (statement == null) return cIMModelBeanArray;
            }
            catch (Exception exception) {
                throw new PersistenceException(exception);
            }
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            if (statement == null) throw throwable;
            try {
                statement.close();
                throw throwable;
            }
            catch (Exception exception2) {
                throw throwable;
            }
        }
        try {}
        catch (Exception exception) {
            // empty catch block
            return cIMModelBeanArray;
        }
        statement.close();
        return cIMModelBeanArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CIMModelBean[] getAllAssociations(CIMModelBean cIMModelBean) throws PersistenceException, TransactionException {
        Transaction transaction = null;
        try {
            Context context = CIMPersistenceManager.createContext();
            transaction = CIMPersistenceManager.createTransaction();
            context.setTransaction(transaction);
            CIMModelBean[] cIMModelBeanArray = this.getAllAssociations(context, cIMModelBean);
            Object var6_5 = null;
            PersistenceManager.getInstance().releaseTransaction(transaction);
            return cIMModelBeanArray;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            PersistenceManager.getInstance().releaseTransaction(transaction);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CIMModelBean[] getAssociations(CIMModelBean cIMModelBean, Class clazz) throws PersistenceException, TransactionException {
        CIMModelBean[] cIMModelBeanArray;
        Transaction transaction = null;
        try {
            Context context = CIMPersistenceManager.createContext();
            transaction = CIMPersistenceManager.createTransaction();
            context.setTransaction(transaction);
            transaction.begin();
            cIMModelBeanArray = this.getAssociations(context, cIMModelBean, clazz);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            CIMPersistenceManager.releaseTransaction(transaction);
            throw throwable;
        }
        CIMPersistenceManager.releaseTransaction(transaction);
        return cIMModelBeanArray;
    }

    public CIMModelBean[] getAssociations(Context context, CIMModelBean cIMModelBean, Class clazz) throws PersistenceException {
        try {
            Object object;
            CIMAssociationModelBean cIMAssociationModelBean = (CIMAssociationModelBean)clazz.newInstance();
            String[] stringArray = cIMAssociationModelBean.getReferenceColumnNames();
            Object object2 = null;
            ArrayList arrayList = new ArrayList();
            int n = 0;
            while (n < stringArray.length) {
                object = new EqualsFilter(stringArray[n], cIMModelBean.getObjectPath());
                if (n > 0) {
                    object = new OrFilter((Filter)object, (Filter)object2);
                }
                object2 = object;
                ++n;
            }
            object = this.get(context, clazz, (Filter)object2);
            return Arrays.asList(object).toArray(new CIMModelBean[((CIMModelBean[])object).length]);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new PersistenceException(illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            throw new PersistenceException(instantiationException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CIMModelBean[] getAllAggregations(CIMModelBean cIMModelBean) throws PersistenceException, TransactionException {
        CIMModelBean[] cIMModelBeanArray;
        Transaction transaction = null;
        try {
            Context context = CIMPersistenceManager.createContext();
            transaction = CIMPersistenceManager.createTransaction();
            context.setTransaction(transaction);
            transaction.begin();
            cIMModelBeanArray = this.getAllAggregations(context, cIMModelBean);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            CIMPersistenceManager.releaseTransaction(transaction);
            throw throwable;
        }
        CIMPersistenceManager.releaseTransaction(transaction);
        return cIMModelBeanArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CIMModelBean[] getAllAggregations(Context context, CIMModelBean cIMModelBean) throws PersistenceException {
        CIMModelBean[] cIMModelBeanArray;
        Transaction transaction = context.getTransaction();
        Statement statement = null;
        try {
            try {
                ArrayList<CIMModelBean> arrayList = new ArrayList<CIMModelBean>();
                String string = "select distinct AggregationName from " + new CIMAggregationModelBean().getBeanName();
                statement = transaction.sendStatement(string);
                ResultSet resultSet = statement.getResultSet();
                if (resultSet != null) {
                    while (resultSet.next()) {
                        cIMModelBeanArray = resultSet.getString("AggregationName");
                        Class<?> clazz = Class.forName("com.sun.netstorage.mgmt.component.model.domain." + (String)cIMModelBeanArray);
                        CIMModelBean[] cIMModelBeanArray2 = this.getAggregations(context, cIMModelBean, clazz);
                        arrayList.addAll(Arrays.asList(cIMModelBeanArray2));
                    }
                }
                cIMModelBeanArray = arrayList.toArray(new CIMModelBean[arrayList.size()]);
                Object var12_12 = null;
                if (statement == null) return cIMModelBeanArray;
            }
            catch (Exception exception) {
                throw new PersistenceException(exception);
            }
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            if (statement == null) throw throwable;
            try {
                statement.close();
                throw throwable;
            }
            catch (Exception exception2) {
                throw throwable;
            }
        }
        try {}
        catch (Exception exception) {
            // empty catch block
            return cIMModelBeanArray;
        }
        statement.close();
        return cIMModelBeanArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CIMModelBean[] getAggregations(CIMModelBean cIMModelBean, Class clazz) throws PersistenceException, TransactionException {
        CIMModelBean[] cIMModelBeanArray;
        Transaction transaction = null;
        try {
            Context context = CIMPersistenceManager.createContext();
            transaction = CIMPersistenceManager.createTransaction();
            context.setTransaction(transaction);
            cIMModelBeanArray = this.getAggregations(context, cIMModelBean, clazz);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            CIMPersistenceManager.releaseTransaction(transaction);
            throw throwable;
        }
        CIMPersistenceManager.releaseTransaction(transaction);
        return cIMModelBeanArray;
    }

    public CIMModelBean[] getAggregations(Context context, CIMModelBean cIMModelBean, Class clazz) throws PersistenceException {
        try {
            Object object;
            CIMAggregationModelBean cIMAggregationModelBean = (CIMAggregationModelBean)clazz.newInstance();
            String[] stringArray = cIMAggregationModelBean.getReferenceColumnNames();
            Object object2 = null;
            int n = 0;
            while (n < stringArray.length) {
                object = new EqualsFilter(stringArray[n], cIMModelBean.getObjectPath());
                if (n > 0) {
                    object = new OrFilter((Filter)object, (Filter)object2);
                }
                object2 = object;
                ++n;
            }
            object = this.get(context, clazz, (Filter)object2);
            return Arrays.asList(object).toArray(new CIMModelBean[((CIMModelBean[])object).length]);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new PersistenceException(illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            throw new PersistenceException(instantiationException);
        }
    }

    public void put(Context context, CIMModelBean cIMModelBean) throws PersistenceException {
        Transaction transaction = context.getTransaction();
        transaction.put(cIMModelBean);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(CIMModelBean cIMModelBean) throws PersistenceException, TransactionException {
        Transaction transaction = null;
        try {
            Context context = CIMPersistenceManager.createContext();
            transaction = CIMPersistenceManager.createTransaction();
            transaction.begin();
            context.setTransaction(transaction);
            this.put(context, cIMModelBean);
            transaction.commit();
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            CIMPersistenceManager.releaseTransaction(transaction);
            throw throwable;
        }
        CIMPersistenceManager.releaseTransaction(transaction);
    }

    public void putAll(Context context, CIMModelBean[] cIMModelBeanArray) throws PersistenceException {
        Transaction transaction = context.getTransaction();
        int n = 0;
        while (n < cIMModelBeanArray.length) {
            transaction.put(cIMModelBeanArray[n]);
            ++n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putAll(CIMModelBean[] cIMModelBeanArray) throws PersistenceException, TransactionException {
        Transaction transaction = null;
        try {
            Context context = CIMPersistenceManager.createContext();
            transaction = CIMPersistenceManager.createTransaction();
            transaction.begin();
            context.setTransaction(transaction);
            this.putAll(context, cIMModelBeanArray);
            transaction.commit();
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            CIMPersistenceManager.releaseTransaction(transaction);
            throw throwable;
        }
        CIMPersistenceManager.releaseTransaction(transaction);
    }

    public void delete(CIMModelBean cIMModelBean) throws PersistenceException, TransactionException {
        this.delete(cIMModelBean.getClass(), new EqualsFilter("objectPath", cIMModelBean.getObjectPath()));
    }

    public void delete(Context context, CIMModelBean cIMModelBean) throws PersistenceException {
        this.delete(context, cIMModelBean.getClass(), new EqualsFilter("objectPath", cIMModelBean.getObjectPath()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(Class clazz, Filter filter) throws PersistenceException, TransactionException {
        Transaction transaction = null;
        try {
            Context context = CIMPersistenceManager.createContext();
            transaction = CIMPersistenceManager.createTransaction();
            context.setTransaction(transaction);
            this.delete(context, clazz, filter);
            transaction.commit();
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            CIMPersistenceManager.releaseTransaction(transaction);
            throw throwable;
        }
        CIMPersistenceManager.releaseTransaction(transaction);
    }

    public void delete(Context context, Class clazz, Filter filter) throws PersistenceException {
        Transaction transaction = context.getTransaction();
        transaction.delete(clazz, filter);
    }

    public void deleteAll(Context context, Class clazz) throws PersistenceException {
        Transaction transaction = context.getTransaction();
        transaction.deleteAll(clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAll(Class clazz) throws PersistenceException, TransactionException {
        Transaction transaction = null;
        try {
            Context context = CIMPersistenceManager.createContext();
            transaction = CIMPersistenceManager.createTransaction();
            context.setTransaction(transaction);
            this.deleteAll(context, clazz);
            transaction.commit();
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            CIMPersistenceManager.releaseTransaction(transaction);
            throw throwable;
        }
        CIMPersistenceManager.releaseTransaction(transaction);
    }

    public void update(Context context, CIMModelBean cIMModelBean) throws PersistenceException {
        Transaction transaction = context.getTransaction();
        int n = transaction.update(cIMModelBean.getClass(), cIMModelBean.getUpdateValues(), new EqualsFilter("objectPath", cIMModelBean.getObjectPath()));
        if (n == 0) {
            transaction.put(cIMModelBean);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(CIMModelBean cIMModelBean) throws PersistenceException, TransactionException {
        Transaction transaction = null;
        try {
            Context context = CIMPersistenceManager.createContext();
            transaction = CIMPersistenceManager.createTransaction();
            context.setTransaction(transaction);
            transaction.begin();
            this.update(context, cIMModelBean);
            transaction.commit();
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            CIMPersistenceManager.releaseTransaction(transaction);
            throw throwable;
        }
        CIMPersistenceManager.releaseTransaction(transaction);
    }

    public void update(Context context, CIMModelBean cIMModelBean, String[] stringArray) throws PersistenceException {
        Transaction transaction = context.getTransaction();
        HashMap hashMap = cIMModelBean.getUpdateValues();
        HashMap hashMap2 = new HashMap();
        int n = 0;
        while (n < stringArray.length) {
            Object v = hashMap.get(stringArray[n]);
            if (v != null) {
                hashMap2.put(stringArray[n], v);
            }
            ++n;
        }
        int n2 = transaction.update(cIMModelBean.getClass(), hashMap2, new EqualsFilter("objectPath", cIMModelBean.getObjectPath()));
        if (n2 == 0) {
            transaction.put(cIMModelBean);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(CIMModelBean cIMModelBean, String[] stringArray) throws PersistenceException, TransactionException {
        Transaction transaction = null;
        try {
            Context context = CIMPersistenceManager.createContext();
            transaction = CIMPersistenceManager.createTransaction();
            context.setTransaction(transaction);
            transaction.begin();
            this.update(context, cIMModelBean, stringArray);
            transaction.commit();
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            CIMPersistenceManager.releaseTransaction(transaction);
            throw throwable;
        }
        CIMPersistenceManager.releaseTransaction(transaction);
    }

    public int beginDiscovery() throws PersistenceException {
        Transaction transaction = null;
        Statement statement = null;
        try {
            int n;
            transaction = CIMPersistenceManager.createTransaction();
            statement = transaction.sendStatement("SELECT begin_discovery()");
            transaction.commit();
            ResultSet resultSet = statement.getResultSet();
            resultSet.next();
            int n2 = n = resultSet.getInt("begin_discovery");
            return n2;
        }
        catch (PersistenceException persistenceException) {
            throw persistenceException;
        }
        catch (Exception exception) {
            throw new PersistenceException(exception);
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception) {}
            }
            CIMPersistenceManager.releaseTransaction(transaction);
        }
    }

    public void endDiscovery(int n, DiscoveryStatus discoveryStatus) throws PersistenceException {
        Transaction transaction = null;
        Statement statement = null;
        try {
            transaction = CIMPersistenceManager.createTransaction();
            statement = transaction.sendStatement("SELECT end_discovery(" + n + ", '" + discoveryStatus.toString() + "')");
            if (discoveryStatus == DiscoveryStatus.COMPLETED) {
                statement.execute("SELECT refresh_virtualtables()");
            }
            transaction.commit();
            statement.execute("ROLLBACK");
            statement.execute("vacuum analyze");
        }
        catch (PersistenceException persistenceException) {
            throw persistenceException;
        }
        catch (Exception exception) {
            throw new PersistenceException(exception);
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception) {}
            }
            CIMPersistenceManager.releaseTransaction(transaction);
        }
    }
}

