/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.util.log;

import com.sun.jade.util.log.LogFormatter;
import com.sun.jade.util.log.LogFormatterImpl;
import com.sun.jade.util.log.Logger;
import com.sun.jade.util.unittest.UnitTest;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.StringTokenizer;

public class LoggerPrintStreamImpl
implements Logger {
    private static PrintStream fileStream;
    private boolean allTags;
    private boolean noDefaultTag;
    private boolean loggingEnabled;
    private LogFormatter formatter;
    private PrintStream output;
    private HashSet tagSet = new HashSet();
    private String name;
    private static PrintStream classOutput;

    public LoggerPrintStreamImpl(PrintStream printStream, LogFormatter logFormatter, boolean bl) {
        this.output = printStream;
        this.formatter = logFormatter;
        this.loggingEnabled = bl;
    }

    public LoggerPrintStreamImpl(PrintStream printStream, LogFormatter logFormatter, boolean bl, String string) {
        String string2;
        this.output = printStream;
        this.formatter = logFormatter;
        this.loggingEnabled = bl;
        this.name = string;
        String string3 = System.getProperty("jade.log." + string);
        if (string3 != null && !string3.equals("")) {
            this.loggingEnabled = string3.equals("enable");
        }
        if (fileStream != null) {
            this.output = fileStream;
        } else {
            string2 = System.getProperty("jade.log.output");
            if (string2 != null && !string2.equals("")) {
                try {
                    fileStream = this.getOutput(string2);
                }
                catch (IOException iOException) {
                    System.err.println("Error opening log file. (" + string2 + ") " + iOException.getLocalizedMessage());
                }
                if (fileStream != null) {
                    this.output = fileStream;
                }
            }
        }
        string2 = System.getProperty("jade.log.tag");
        if (string2 != null && !string2.equals("")) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ":");
            while (stringTokenizer.hasMoreTokens()) {
                String string4 = stringTokenizer.nextToken();
                if ("ALL".equals(string4)) {
                    this.allTags = true;
                    continue;
                }
                if ("NODEFAULT".equals(string4)) {
                    this.noDefaultTag = true;
                    continue;
                }
                this.addTag(string4);
            }
        }
    }

    public boolean isEnabled() {
        return this.loggingEnabled && !this.noDefaultTag;
    }

    public boolean isEnabled(String string) {
        return this.loggingEnabled && (this.allTags || this.tagSet.contains(string));
    }

    public void log(Throwable throwable, Object object) {
        if (this.loggingEnabled && !this.noDefaultTag) {
            this.output.println(this.formatter.format(object.toString()));
            throwable.printStackTrace(this.output);
        }
    }

    public void log(Object object) {
        if (this.loggingEnabled && !this.noDefaultTag) {
            this.output.println(this.formatter.format(object.toString()));
        }
    }

    public void log(String string, Throwable throwable, Object object) {
        if (this.loggingEnabled && (this.allTags || this.tagSet.contains(string))) {
            this.output.println(this.formatter.format(object.toString()));
            throwable.printStackTrace(this.output);
        }
    }

    public void log(String string, Object object) {
        if (this.loggingEnabled && (this.allTags || this.tagSet.contains(string))) {
            this.output.println(this.formatter.format(object.toString()));
        }
    }

    public void disableLogging() {
        this.loggingEnabled = false;
    }

    public void enableLogging() {
        this.loggingEnabled = true;
    }

    public void addTag(String string) {
        this.tagSet.add(string);
    }

    public void clearTag(String string) {
        this.tagSet.remove(string);
    }

    public void setFormatter(LogFormatter logFormatter) {
        if (logFormatter == null) {
            return;
        }
        this.formatter = logFormatter;
    }

    private PrintStream getOutput(String string) throws IOException {
        if (classOutput != null) {
            return classOutput;
        }
        return new PrintStream(new FileOutputStream(new File(string)));
    }

    public static class Test
    extends UnitTest {
        public void testAll() throws IOException {
            Integer n = new Integer("1");
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            LogFormatterImpl logFormatterImpl = new LogFormatterImpl("X");
            logFormatterImpl.setCaption(null);
            LoggerPrintStreamImpl loggerPrintStreamImpl = new LoggerPrintStreamImpl(new PrintStream(byteArrayOutputStream), logFormatterImpl, true);
            loggerPrintStreamImpl.log("msga");
            loggerPrintStreamImpl.log(n);
            loggerPrintStreamImpl.disableLogging();
            loggerPrintStreamImpl.log("msgb");
            loggerPrintStreamImpl.enableLogging();
            loggerPrintStreamImpl.addTag("a");
            loggerPrintStreamImpl.log("a", (Object)"msgc");
            loggerPrintStreamImpl.log("b", (Object)"msgd");
            loggerPrintStreamImpl.clearTag("b");
            loggerPrintStreamImpl.clearTag("a");
            loggerPrintStreamImpl.log("a", (Object)"msge");
            this.assertEquals("msga\n1\nmsgc\n", byteArrayOutputStream.toString());
        }
    }
}

