/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.util.locale;

import com.sun.jade.util.locale.LocalizedMessage;
import com.sun.jade.util.locale.Localizer;
import com.sun.jade.util.unittest.UnitTest;
import java.io.Serializable;
import java.util.Locale;

public class LocalizableMessage
implements LocalizedMessage,
Serializable,
Cloneable {
    private Class context;
    private Locale fallbackLocale;
    private Serializable[] params;
    private String key;
    private String defaultMessage;
    private static final String sccs_id = "@(#)LocalizableMessage.java\t1.4 04/16/02 SMI";
    static /* synthetic */ Class class$com$sun$jade$util$locale$LocalizableMessage;

    public LocalizableMessage(Class clazz, String string, Serializable[] serializableArray, Locale locale) {
        if (clazz == null || string == null || string.equals("")) {
            throw new IllegalArgumentException();
        }
        this.context = clazz;
        this.fallbackLocale = locale;
        this.params = serializableArray;
        this.key = string;
        if (this.fallbackLocale == null) {
            this.fallbackLocale = Locale.getDefault();
        }
        Localizer localizer = new Localizer(this.fallbackLocale, this.getBundleName(), false);
        this.defaultMessage = localizer.getFormattedString(string, serializableArray);
    }

    public Locale getFallbackLocale() {
        return this.fallbackLocale;
    }

    public String getLocalizedMessage() {
        return this.getLocalizedText(true);
    }

    public String getLocalizedMessage(Locale locale) {
        return this.getLocalizedText(locale, true);
    }

    public String getLocalizedText(boolean bl) {
        return this.getLocalizedText(Locale.getDefault(), bl);
    }

    public String getLocalizedText(Locale locale, boolean bl) {
        try {
            Localizer localizer = new Localizer(this.getBundleName());
            localizer.setLocale(locale);
            return localizer.getFormattedString(this.key, this.params);
        }
        catch (Exception exception) {
            if (bl) {
                return this.defaultMessage;
            }
            throw new LocalizationError(exception.getLocalizedMessage(), exception);
        }
    }

    private String getBundleName() {
        String string;
        String string2 = string = this.context.getName();
        int n = string.lastIndexOf(46);
        if (n > 0) {
            string2 = string.substring(n);
        }
        String string3 = this.context.getPackage().getName();
        return string3 + ".resources" + string2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class Test
    extends UnitTest {
        public void test() {
            LocalizableMessage localizableMessage = new LocalizableMessage(class$com$sun$jade$util$locale$LocalizableMessage == null ? (class$com$sun$jade$util$locale$LocalizableMessage = LocalizableMessage.class$("com.sun.jade.util.locale.LocalizableMessage")) : class$com$sun$jade$util$locale$LocalizableMessage, "default", null, null);
            LocalizableMessage localizableMessage2 = new LocalizableMessage(class$com$sun$jade$util$locale$LocalizableMessage == null ? (class$com$sun$jade$util$locale$LocalizableMessage = LocalizableMessage.class$("com.sun.jade.util.locale.LocalizableMessage")) : class$com$sun$jade$util$locale$LocalizableMessage, "arg", new Serializable[]{new Integer(9)}, null);
            this.assertEquals("Default Property", localizableMessage.getLocalizedText(true));
            this.assertEquals("Arg is 9", localizableMessage2.getLocalizedText(true));
        }
    }

    public class LocalizationError
    extends Error {
        private Throwable e;

        LocalizationError(String string, Throwable throwable) {
            super(string);
            this.e = throwable;
        }

        public Throwable getTargetException() {
            return this.e;
        }
    }
}

