package TO::SE2;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

use TO::SE;
use base 'TO::SE';
use strict;

sub leaf { 1 }
sub type { "se2" }


sub topoPort {
  my( $node, $portWWN, $hba,$Config, $devs, $dev_no) = @_;
  my $port = substr($portWWN, 2, 2);
  my $dev = @$devs[$dev_no];
  my $rport = 0;

  if($port >10 && $port < 19){
        $rport =  $port - 11;
  }elsif($port >20 && $port < 29){
     $rport = $port - 13;
  }elsif($port >30 && $port < 39){
     $rport = $port - 15;
  }elsif($port >40 && $port < 39){
     $rport = $port - 17;
  }
  if($dev->{ProductID} =~ /SE6920/){
     return($rport, ,$rport);
  }else{
    return($rport);
  }
}

sub addPorts {
  my($class, $obj, $LINKS, $syns, $se_key) = @_;

  my $p;

  # Must normalize port indexing so that inband can match 
  # with out of band data.
  # Will assume each blade has 8 ports and there are 4 blades
  # For a total of 32 ports
  for ($p=0; $p < 33 ; $p++) {
     next if (!$LINKS->{"fcPort.$p.LocalPortWWN"});

     my $wwn = $LINKS->{"fcPort.$p.PortWWN"} || $LINKS->{"fcPort.$p.RemoteWWN"};
     my $blade = substr($LINKS->{"fcPort.$p.PortId"}, 1,3) ;
     $blade =~ s/p//;

     my $rport;


     if($blade >10 && $blade < 19){
        $rport =  $blade - 11;
  }elsif($blade >20 && $blade < 29){
     $rport = $blade - 13;
  }elsif($blade >30 && $blade < 39){
     $rport = $blade - 15;
  }elsif($blade >40 && $blade < 39){
     $rport = $blade - 17;
  }


     if (!$obj->{portInfo}[$rport]) {
       $obj->{portInfo}[$rport]  = {
               PortWWN        => $wwn,
               RemotePortWWN  => $LINKS->{"fcPort.$p.RemoteWWN"},
               LocalPortWWN   => $LINKS->{"fcPort.$p.LocalPortWWN"},
               sw_PortType    => $LINKS->{"fcPort.$p.PortType"},
               PortState      => $LINKS->{"fcPort.$p.PortState"},
               PortStatus     => $LINKS->{"fcPort.$p.PortStatus"},
               Name           => $LINKS->{"fcPort.$p.Name"},
               PortId         => $LINKS->{"fcPort.$p.PortId"},
              };
     } else {
       $obj->{portInfo}[$rport]{PortWWN}      = $wwn;
       $obj->{portInfo}[$rport]{RemotePortWWN}= $LINKS->{"fcPort.$p.RemoteWWN"};
       $obj->{portInfo}[$rport]{LocalPortWWN} = $LINKS->{"fcPort.$p.LocalPortWWN"};
       $obj->{portInfo}[$rport]{sw_PortType}  = $LINKS->{"fcPort.$p.PortType"};
       $obj->{portInfo}[$rport]{PortState}    = $LINKS->{"fcPort.$p.PortState"};
       $obj->{portInfo}[$rport]{PortStatus}   = $LINKS->{"fcPort.$p.PortStatus"};
       $obj->{portInfo}[$rport]{Name}         = $LINKS->{"fcPort.$p.Name"};
       $obj->{portInfo}[$rport]{PortId}       = $LINKS->{"fcPort.$p.PortId"};
     }
  }
}






1;
