package TO::6130;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

use base 'TO::STORAGE';
use strict;
sub type { '6130'}
sub leaf { 1 }

sub isKnownDevice {
  my($class, $dev) = @_;
  if ($dev->{ProductID} =~ /CSM100_R_FC/ || 
      $dev->{ProductID} =~ /INF-01-00/) {
     return 1;
  } 
  return 0;
}


sub topoPort {
     my( $node, $portWWN, $hba, $Config, $devs, $dev_no) = @_;

     my $dev     = $devs->[$dev_no];
     my $nodeWWN = $dev->{NodeWWN};
     return &_topoPort($portWWN, $nodeWWN);
}

sub _topoPort {
  my($portWWN, $nodeWWN) = @_;

     # Find  port
     # byte 6 = even, Controller A
     # byte 6 = odd, Controller B
     # byte 0 = ethernet MAC + 1, Port 0
     # byte 0 = ethernet MAC + 2, Port 1
     # ethernet MAC is NODE WWN
     my $endnumN = substr($nodeWWN,10);
     my $endnumP = substr($portWWN,10);

     my $port = hex($endnumP) - hex($endnumN);
     #Find controller
     if(substr($nodeWWN,2,2) eq substr($portWWN,2,2) ){
       #Controller A
     }else{
       #Controller B
       $port += 2;
     }
     $port = $port - 1;
     if(($port < 0) || ($port >4)){
       $port = 0;
     }
     return ($port);
}


sub newFromDev {
  my($class, $to, $dev, $arg) = @_;

  my $renv = System->get_renv();
  my $host = $renv->{hostname};
 
  my $k = $dev->{type} . ":" . $dev->{key};
  my $exists = $to->nodeByName($k);

  my $storages  =  $to->[2];
  my $key       = $dev->{key};
  my $type      = $dev->{type};

  my $obj = $exists || {};
  my $org_name          = $obj->{info}{name};
  $obj->{info}{type}    = $type;
  $obj->{info}{class}   = "storage.$type";
  $obj->{info}{name}    = "$type:$key";
  $obj->{info}{BoxName} = $dev->{name};
  $obj->{info}{ipAddr}  = $dev->{ipno};


  TO->host_array2($obj->{info}, {host => $host, host_type => $arg->{host_type} || "ib"});

  $obj->{info}{VendorID}= "SUN";
  $obj->{info}{NodeWWN} = $dev->{wwn} if ($dev->{wwn});
  $obj->{info}{LGroup}  = "Sun $type";

  my($report);
  if ($arg->{report}) {   # GET THE REPORT IF AVAILABLE ALREADY
    $report = $arg->{report};
  } else {
    if (!$arg->{wwns}) {  # GET THE WWNS IF NOT THERE ALREADY
       my $rcs = Java::Discovery->deviceSearch({ ip => $dev->{ipno} }, "6130");
       $arg = $rcs->[0];
    }
    my(@ports) = split(/,/, $arg->{wwns});  # PARSE WWNS IN THE REPORT.
    my($x);
    for ($x=0; $x <= $#ports; $x++) {
       my $p = $x+1;
       $report->{"fcport.$p.NodeWWN"}      = $dev->{wwn};
       $report->{"fcport.$p._WWN"}         = $ports[$x];
       $report->{"fcport.$p._ElementName"} = $x;
    }
  }

  $obj->{port}= [];
  #
  # ADD PORTS FROM REPORT TO NODE.
  my($x);
  $obj->{info}{port_cnt} = $report->{'fcport.count'};

  for ($x=1; $x <= 20; $x++) {
      last if (!exists  $report->{"fcport.$x._WWN"});

      my $portWWN = lc($report->{"fcport.$x._WWN"});
      my $nodeWWN = lc($report->{"fcport.$x.NodeWWN"});
      my ($port)  = &_topoPort($portWWN, $nodeWWN);

      $obj->{portInfo}[$port] = {
                 PortWWN => $portWWN,
            LocalPortWWN => $portWWN,
                      Id => $report->{"fcport.$x._ElementName"},
                 };
      $to->addSyn($portWWN, "$k:$port");
  }

  bless($obj, uc("TO::$type"));

  $to->addSyn($key, "$type:$key");
  $storages->{"$type:$key"} = $obj;
  
  return $obj;
}


sub iconLayout {
  my($obj) = @_;
  my $rows_of_disk     = 1;  # need to be adjusted
  my $disks_per_row    = 14;
  my $device_type      = "6130";
  my $node_type        = "a";     # a for array.
  my $node_color       = "E0C0D0";
  my $node_gif         = "6130.gif"; # taken from htdocs/Topo/TopoGif/
  my $external_ports   = $obj->{info}{port_cnt} || 4;

  my ($x, $row_labels, $external_ports_labels);

  for ($x=1; $x <= $external_ports; $x++) {
    $external_ports_labels .= $x;
  }
  for ($x=1; $x <= $rows_of_disk; $x++) {
    $row_labels .= "row$x/";
  }
  chop($row_labels) if ($row_labels);
  

  my $cat = "$node_type,$device_type,$external_ports/$external_ports_labels,".
         "$disks_per_row,$row_labels,_,,$node_color/$node_gif";

  my $label2 = "Sun 6130";
  my $ses    = 1;

  return ($cat, $label2, $ses);
}

1;
