package TO::5210;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

use base 'TO::STORAGE';
use strict;
sub type { '5210'}
sub leaf { 1 }

sub isKnownDevice {
  my($class, $dev) = @_;
  return 1 if ($dev->{ProductID} =~ /5210/);
}

#sub addFromConfig {
#  my($class, $topo, $Config) = @_;
#
#  my $devs = $Config->myDevices();
#  my $renv = $Config->renv();
#
#  foreach my $dev (@$devs) {
#     next if ($dev->{type} ne $class->type());
#     next if (!$dev->isMineToMonitor());
#     my $k = $dev->{type} . ":" . $dev->key();
#     my $exists = $topo->nodeByName($k);
#     if (!$exists) {
#        my $wwn = $dev->{wwn} || $dev->{wwn2} || $dev->{wwn3} || $dev->{wwn4};
#        $exists = $topo->nodeByKeySkipN($wwn,4);
#     }
#     $class->new($topo, $renv->{hostname}, $dev, $exists);
#  }
#}

sub newFromDev {
  my($class, $to, $dev, $args) = @_;

  my $renv = System->get_renv();
  my $host = $renv->{hostname};
  
  my $k = $dev->{type} . ":" . $dev->{key};
  my $exists = $to->nodeByName($k);
  if (!$exists) {
    my $wwn = $dev->{wwn} || $dev->{wwn2} || $dev->{wwn3} || $dev->{wwn4};
    $exists = $to->nodeBySynonym($wwn);
  }

  my $storages  =  $to->[2];
  my $syns      =  $to->[4];
  my $key       = $dev->{key};
  my $type              = $dev->{type};

  my $obj = $exists || {};
  my $org_name =  $obj->{info}{name};
  $obj->{info}{type}    = $type;
  $obj->{info}{class}   = "storage.$type";
  $obj->{info}{name}    = "$type:$key";
  $obj->{info}{BoxName} = $dev->{name};
  $obj->{info}{host}    = $host;
  $obj->{info}{host_type} = "oob";
  $obj->{info}{VendorID}= "SUN";
  $obj->{info}{LGroup}  = "Sun $type";
  $DB::single= 1;

  require Agent::5210;
  my $rc = Agent::5210->getInfoForTopology($dev->{ip});
 
  my $numUnits = $rc->{'enclCount'};
  my $numDisk = $rc->{'diskCount'};
  my $numPort = $rc->{'portCount'};

  $obj->{info}{units} = $numUnits;
  $obj->{info}{disk_cnt} = $numDisk;
  $obj->{info}{port_cnt} =$numPort;

  
  bless($obj, "TO::$type");
  $syns->{$key} = "$type:$key";
  delete $storages->{$org_name} if ($org_name);
  $storages->{"$type:$key"} = $obj;
  return $obj if ($exists); 
 
}

sub iconLayout {
  my($obj) = @_;
  my ($cat, $label2, $ses);
  my $maxDiskPerRow = 6;
  my $disks = $obj->{info}{disk_cnt} || 6;
  my $rows = int($obj->{info}{disk_cnt} / $maxDiskPerRow);
  my $diskForSinglEncl= 6; # Merge it into Count variable

  my $modulo = int($obj->{info}{disk_cnt} % $maxDiskPerRow);
  if ($modulo && ($modulo > 0)) {
     $rows = $rows + 1;	
  }

  my $ports = $obj->{info}{port_cnt} || 2;
  my $units = $obj->{info}{units} || 1;

  if ($units > 1) {
     my ($dd, $x);
     my $ext = $units > 2 ? "x4" : "exp";
     for ($x=0; $x < $rows; $x++) {
        $dd .= "/";
     }
     chop($dd);
     $cat = "a,5210,$ports/    ,$maxDiskPerRow,$dd,A,alert_log,E0D0F0/5210".$ext.".gif";
     $ses = 2;
  } else {
     $cat = "a,5210,$ports/   ,$diskForSinglEncl,0,A,alert_log,E0D0F0/5210.gif";
     $ses = 1;
  }

  #$cat = "a,5210,$ports/  ,$cnt,$dd,_,,E0D0F0/3310.gif";

  $label2 = $obj->{info}{LGroup};

  return ($cat, $label2, $ses);
}

# "a,$t3,2/12,-$dt,$dd,LMPVA,Loop/Midplane/Power/Volumes/Alerts,D0D0F0/t3pg.gif";

1;

