package NWS::A3500FC;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

#  $Name: bld21_029 $ 
#  $Id: A3500FC.pm,v 1.3 2005/01/12 18:51:32 mckenney Exp $

use Report;
use CIM::Instance;
use Data::Dumper;
use strict;
use Ilist;
use PDM;
use NWS;
sub revision {'$Revision: 1.3 $'}

sub getKey {
  my($class, $rep) = @_;

  return "a3500fc." . ($rep->get('controller.a.serial') || $rep->get('controller.b.serial'));
}

sub newSystem {
  my ($class, $rep, $category) = @_;
  my(@pil, $i, $dd, $a, $j, $k, $k1, $v);
  my($CTRL);
  my $key = $class->getKey($rep);

  my($p1) = CIM::Instance->new('NWS_System',[
                    [Name 				=> $key               ],
                    [FruCtlrCount 		=> 2],
                    [SystemName         => $key     ],
                    [FruDiskDriveCount 	=> $rep->get('disk.count')],
                    [VolCount 			=> $rep->get('lun.count')],
                    [SysRevision 		=> $rep->get('device_info.a.firmware_version')],
                    [BootLevel          => $rep->get('device_info.a.Boot_Level')],
                    [FibreLevel         => $rep->get('device_info.a.Fibre_Level')],
                    [FirmwareLevel      => $rep->get('device_info.a.Firmware_Level')],
                    [Caption            => uc($category)],
                ]);

  my($p2) = CIM::Instance->new('CIM_PhysicalFrame', [
                  [Tag 					=> $key],
                  [Name					=> $key],
                  [Manufacturer 		=> $rep->get("device_info.a.Vendor_ID")],
                  [Model 				=> $rep->get("device_info.a.ProductID")],
                  ]);

  my($a2) = CIM::Instance->new('CIM_ComputerSystemPackage', [
                  [Antecedent            => $p1],
                  [Dependent             => $p2],
                  ]);

  my($l1) = NWS->location($rep);
  
  my($al1) = CIM::Instance->new('NWS_PhysicalFrameLocation', [
                  [Element 				=> $p2],
                  [PhysicalLocation 	=> $l1],
                  ]);
               
  push (@pil, $p1, $p2, $a2, $l1, $al1);

  $CTRL =  $rep->get('controller.count');

  foreach $i ('a','b') {
    if ($rep->get("controller.$i.device")) {
      $dd = $class->newController($rep,"controller.$i", $category);
      $a = CIM::Instance->new('CIM_Container', [
                   [GroupComponent  => $p2],
                   [PartComponent => $dd->[1]],
                   [LocationWithinContainer => "ctr.$i"],
                   ]);
      push (@pil, @$dd);
      push (@pil, $a);
    }
  }

  my(@vols);
  my($volCnt) = 0;
  my(@DSK) = ();
  for ($i = 0; $i < $rep->get('lun.count'); $i++) {
     my($p) = "lun.$i";
     $vols[$i] = CIM::Instance->new('NWS_StorageVolume', [
                    [ SystemName        => "LUN"         ],
                    [ DeviceID          => "$key.lun.$i"     ],
                    [ Name              => "$key.lun.$i"     ],
                    [ VolIndex          => $i],
                    [ VolId             => $i],
                    [ VolRaidLevel      => $rep->get("$p.raid_level") ],
                    [ VolStatus         => $rep->get("$p.status") ],
                    [ Capacity          => $rep->get("$p.capacity") ],
                    [ LunGroup          => $rep->get("$p.group") ],
                    [ OtherIdentifyingInfo => $rep->get("$p.device") ],
                    ]);
      push (@pil,$vols[$i] );
      $volCnt++;
  }
  
  for ($j = 0; $j< $rep->get('disk.count'); $j++) {
     next if (!$rep->get("disk.$j.serial"));
     $dd = $class->newDiskDrive($rep,"disk.$j", $category);
     $a = CIM::Instance->new('CIM_Container', [
                   [GroupComponent  => $p2],
                   [PartComponent => $dd->[1]],
                   [LocationWithinContainer => "disk.$j"],
                   ]);
     $DSK[$j] = $dd->[0];
     push (@pil, @$dd, $a);
  }
    
  for ($k1 = 0;$k1 < $rep->get('lun.count'); $k1++) {

       my($l_group) = $rep->get("lun.$k1.group");
       for ($k=0; $k < $rep->get('disk.count'); $k++) {
          next if (!$rep->get("disk.$k.serial"));
          my($d_group) = $rep->get("disk.$k.group");
          $d_group = substr($d_group,1,-1) if (substr($d_group,0,1) eq "[");
          $d_group = ",$d_group,";
          
          if (index($d_group, ",$l_group,") >= 0) {
            push(@pil, 
                  CIM::Instance->new('CIM_MediaPresent', [
                       [Antecedent => $DSK[$k]     ],  # the NWS_DiskDrive
                       [Dependent  => $vols[$k1]   ],
                       ]));
          }
      }
  }

  return Ilist->new(\@pil);

}

# cd = "lun.0"

sub newVolume {
  my($class, $rep, $cd, $category) = @_;
  my (@pil);
  my $key = $class->getKey($rep);
  my $i = substr($cd,4);

  my $vol = CIM::Instance->new('NWS_StorageVolume', [
                    [ SystemName        => "LUN"         ],
                    [ DeviceID          => "$key.$cd"     ],
                    [ Name              => "$key.$cd"     ],
                    [ VolIndex          => $i],
                    [ VolId             => $i],
                    [ VolRaidLevel      => $rep->get("$cd.raid_level") ],
                    [ VolStatus         => $rep->get("$cd.status") ],
                    [ Capacity          => $rep->get("$cd.capacity") ],
                    [ LunGroup          => $rep->get("$cd.group") ],
                    [ OtherIdentifyingInfo => $rep->get("$cd.device") ],
                    ]);

  push (@pil,$vol);
  my $l_group = $rep->get("$cd.group");

  my $p2 = CIM::Instance->new('CIM_PhysicalFrame', [
                  [Tag 					=> $key],
                  [Name					=> $key],
                  [Manufacturer 		=> $rep->get("device_info.a.Vendor_ID")],
                  [Model 				=> $rep->get("device_info.a.ProductID")],
                  ]);

  my($k, $j);
  for ($j = 0; $j< $rep->get('disk.count'); $j++) {
     next if (!$rep->get("disk.$j.serial"));

     my $dd = $class->newDiskDrive($rep,"disk.$j", $category);
     my $d_group  = $rep->get("disk.$j.group");
     $d_group = substr($d_group,1,-1) if (substr($d_group,0,1) eq "[");

     my $a = CIM::Instance->new('CIM_Container', [
                   [GroupComponent     => $p2      ],
                   [PartComponent      => $dd->[1] ],
                   [LocationWithinContainer => "disk.$j"],
                   ]);

     if (index(",$d_group," , ",$l_group,") >= 0) {
         push (@pil, @$dd, $a);
         push(@pil, 
              CIM::Instance->new('CIM_MediaPresent', [
                   [Antecedent => $dd->[0]     ],  # the NWS_DiskDrive
                   [Dependent  => $vol         ],
                   ]));
      }
  }
  return Ilist->new(\@pil);

}


# create instances of NWS_DiskDrive, CIM_Realizes, CIM_PhysicalPackage, 
# CIM_MediaPresent and CIM_StorageExtent, CIM_SoftwareElement, CIM_DeviceSoftware
#  $disk = NWS::T3->newDiskDrive($rep, "u1d1");

sub newDiskDrive {
  my($class, $rep, $cd, $category) = @_;
  my(@il, $p1, $c1, $a1, $c2, $a2);

  my($serial_no) = $rep->get("$cd.vendor") . "." . $rep->get("$cd.serial");

  my($status) = $rep->get("$cd.status");

  my($map) = PDM->getDeviceStateMap("$category.availability");
  my($state) = $map->get("disk.status.$status");

  $p1 = CIM::Instance->new('NWS_DiskDrive', [
                [SystemName 		=> $rep->get("$cd.vendor")." DiskDrive"],
                [DeviceID 			=> $serial_no],
                [Name     			=> $serial_no],
                [FruDiskRole        => $rep->get("$cd.fruDiskRole")],
                [FruDiskIsExpendable=> $rep->get("$cd.fruDiskIsExpendable")],
                [FruDiskIsRebuildable=> $rep->get("$cd.fruDiskIsRebuildable")],
                [FruDiskTemperature => $rep->get("$cd.fruDiskTemp")],
                [FruDiskCapacity    => $rep->get("$cd.fruDiskCapacity")],
                [FruErrors          => $rep->get("$cd.fruErrors")],
                [Port1State         => $rep->get("$cd.fruDiskPort1State")],
                [Port2State         => $rep->get("$cd.fruDiskPort2State")],
                [StatusInfo         => $status],
                [Status             => $state],
                 ]);
  push(@il,$p1);

  $c1 = CIM::Instance->new('CIM_PhysicalPackage', [
                [Removable 				=> "Yes"],
                [Replaceable 			=> $rep->get("$cd.fruDiskIsExpendable")],
                [Tag 					=> $serial_no],
                [Name    				=> $serial_no],
                [SerialNumber 			=> $rep->get("$cd.serial")],
                [Manufacturer 			=> $rep->get("$cd.vendor")],  
                [Model 					=> $rep->get("$cd.product_id")],  
                [Version 				=> $rep->get("$cd.firmware_version")],  
                    ]);

  push(@il, $c1);
  $a1 = CIM::Instance->new('CIM_Realizes', [
                    [Antecedent => $c1],
                    [Dependent => $p1],
                    ]);
                    
  push(@il,$a1);

  return Ilist->new(\@il);

}

# create instances of NWS_Controller, CIM_Realizes, CIM_Card, CIM_SoftwareElement and
#CIM_DeviceSoftware (Note: All attributes related to T3's software will be in the
#controller's CIM_SoftwareElement class.

sub newController {
  my($class, $rep, $cd, $category) = @_;
  my(@il, $p1, $c1, $a1);
  
  $DB::step = 1;
  my($port) = substr($cd,-1);
  my($serial_no)    = $rep->get("device_info.$port.Vendor_ID") . "." . 
                      $rep->get("$cd.serial");

  $port = substr($cd,11,-3) . "p1";
  my($status) = $rep->get("${cd}.state");

  my($map)   = PDM->getDeviceStateMap("$category.availability");
  my($state) = $map->get("controller.state.$status");

  $p1 = CIM::Instance->new('NWS_Controller', [
                    [SystemName  =>  $rep->get("device_info.a.Vendor_ID") . " $category controller"],
                    [DeviceID     => $serial_no],
                    [Name         => $serial_no],
                    [StatusInfo   => $status],
                    [Status       => $state],
                    ]);
  push(@il,$p1);

  $c1 = CIM::Instance->new('CIM_Card', [
                [Removable 			=> "Yes"],
                [Replaceable 		=> $rep->get("${cd}.fruCtlrIsExpendable")],
                [Tag 				=> $serial_no],
                [Name  				=> $serial_no],
                [SerialNumber 		=> $rep->get("$cd.serial")],
                [Manufacturer 		=> $rep->get("${cd}.Vendor_ID")],  
                [Model 				=> $rep->get("${cd}.ProductID")],  
                [Version 			=> $rep->get("${cd}.Firmware_Level")],  
                    ]);

  push(@il, $c1);
  $a1 = CIM::Instance->new('CIM_Realizes', [
                [Antecedent => $c1],
                [Dependent => $p1],
                    ]);
                    
  push(@il,$a1);

  return Ilist->new(\@il);

}


1;
