# $Id: Report.pm,v 1.5 2005/01/11 23:10:04 jkremer Exp $
# Copyright 2004, Sun Microsystems, Inc. All rights reserved.
package Java::Report;

use Java::JrexMsg;
use Java::JrexClient;
use System;
use Debug;
use strict;

use Data::Dumper;

# sub instrument
# this function returns a hash with the instrumentation data obtained
# from the Java framework.
#
# INPUT : a config_device
# OUTPUT: a hash with device_specific data and
# 'rc.error' => "Probing error"
# 'rc.key' => "key of the device as found by the probe'
#
sub instrument {
  my($class, $device) = @_;

  my $client = new Java::JrexClient();

  my $report = $client->invoke
  ("com.sun.netstorage.fm.storade.agent.helper.DeviceHelper",
	"instrument",
	[$device]
  );
  my $error = $client->error();
  if ($error){
	 my $er = { "rc.error" => $error->{faultdetail}->{trace},
					"rc.key" => $device->{key}
				 };
	 return $er;
  }
  return $report;
}

sub instrumentDevice {
  my($class, $device) = @_;

  my $client = new Java::JrexClient();

  my $devrep = $client->invoke
  ("com.sun.netstorage.fm.storade.agent.helper.DeviceHelper",
	"instrumentDevice",
	[$device]
  );
  my $error = $client->error();
  if ($error){
	 my $er = { "rc.error" => $error->{faultdetail}->{trace},
					"rc.key"   => $device->{key}
				 };
	 return { device => $device,
				 report => $er };
  }
  # $devrep->{report} is new report.
  # $devrep->{device} is updated device properties.
  return $devrep;
}

sub message {
  my($class, $marker, $device) = @_;
  my $client = new Java::JrexClient();
  my $msgs = $client->invoke
  ("com.sun.netstorage.fm.storade.agent.helper.DeviceHelper",
	"getMessages",
	[$marker, $device]
  );

  if (!$msgs){
	 return { "error" => $client->error };
  }
  return $msgs;
}

sub marker {
  my($class, $device) = @_;
  my $client = new Java::JrexClient();
  my $marker = $client->invoke
  ("com.sun.netstorage.fm.storade.agent.helper.DeviceHelper",
	"getMarker",
	[$device]
  );
  if (!$marker){
	 return 0;
  }
  return $marker;
}

1;
