package Health::Domain;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

#  $Id: Domain.pm,v 1.2 2005/04/20 17:23:32 sbrooks Exp $

use base 'Health';
use NWS::SE;
use Ilist;
use Message;
use Catalog;
use Report;
use System;
use Events;
use strict;
use Debug;

sub revision {'$Revision: 1.2 $'}


sub all_logic {
  my($hm, $report) = @_;
  my($ev, $ed, $pertains, $x ,$y, $contain, $sd);
  my($orep, $key);
# DO NOTHING FOR NOW
  my $renv     = System->get_renv();

  #return if (!$renv->{include_se_device});

  my $rep      = $report->content;
  my $oreport  = PDM->getOldReport($report->fileKey);
  my($ip)      = $report->id('ip');
  $DB::single = 1;
  my $wwn      = $report->id('deviceName');
  my($id)      = $report->id('display');
  my $shortid  = $report->name();
  my $mgmtLevel = $report->value('id.mgmtLevel') || 'D';
  my $se        = $report->category();

  CIM->version("1.1");

  if ($hm->connectionEvent($wwn, $report, {method => 2, threshold_severity => 1} )) {  # IB / OOB
     return;
  }
  my $freq  = $renv->{audit_freq} || 7;
  my $audit = System->get_audit() ? "YES" : Timer->isXdays("Audit$wwn", $freq);

  if (!$oreport || $audit eq "YES" ) {  
                                                        # new t300 or audit time.
     my($etype) = $audit eq "YES" ? "$se.AuditEvent" : "$se.DiscoveryEvent";
     my($title) = $audit eq "YES" ? "Auditing":"Discovering";
     my($dt)    = "A" if (!$audit);
     Grid->setCode($etype);
     $ev = CIM::Instance->new('NWS_Event', [
                  [ EventType   => $etype  ],
                  [ Target      => "$se:$wwn"    ],
                  [ TargetName  => $id     ],
                  [ MgmtLevel   => $mgmtLevel],
                  [ SourceIP    => $ip     ],
                  [ EventId     => PDM->getEventSequence  ],
                  [ Description => "$title  $id"],
                  [ Data        => $hm->serial($rep) ],
                         ]);

     $sd = Events->sourceDetector({ event => $ev , host => 1, rep => $rep});
      
     my($p) = NWS::SE->newSystem($rep);

     $pertains = CIM::Instance->new('NWS_EventPertainsToSystem', [
                  [ Event       => $ev  ],
                  [ Element     => $p->[0] ],
                  [ DiscoveryType => $dt],
                    ]);
     my($monitors) = CIM::Instance->new('NWS_AgentMonitors', [
                  [ Agent       => $sd->[0]  ],
                  [ Element     => $p->[0] ],
                    ]);

     $ed = Message->new( {  id        => $report->id,
                            instances => [$ev, @$sd, @$p, $monitors, $pertains ],
                            severity  => Message::SEVERITY_NORMAL });

     PDM->saveMessage($ed);
  }

  $orep = ($oreport)? $oreport->content() : $rep; # same report if new disco.

  $hm->locationChangeEvent($report, $rep, $orep, $wwn);

  my($physicalFrame) = CIM::Key->new( ['CIM_PhysicalFrame',   # key of the frame
                        Tag               => $rep->get("id.wwn") ,
                        CreationClassName => 'CIM_PhysicalFrame' ]);

  my($SLOTS) = $rep->get('info.slotTotal');
  my($OSLOTS) = $orep->get('info.slotTotal');
  my($comp);
  my($okey, $nkey);
  my $MAX = ($SLOTS > $OSLOTS) ? $SLOTS : $OSLOTS;

  for ($x = 1; $x < $MAX; $x++) {
     $comp = "slot.$x";
     $okey = $orep->get("$comp.dev-key");
     $nkey =  $rep->get("$comp.dev-key");

     if ($okey eq $nkey) {
         my $S = $nkey;
         Grid->setCode("$se.StateChangeEvent.slot");
         $hm->sevStateEvent($comp, $report, $rep, $orep, 'NWS_Slot', $S, $wwn, 
              {logical => 1 });
     } else {
         if ($okey) {
           Grid->setCode("$se.ComponentRemoveEvent.slot");
           $hm->removeCompEvent($comp,$physicalFrame, $report, $orep, 'CIM_Card',$okey, $wwn, {system => 1});
         }
         if ($nkey) {
           my($ctrl) = NWS::SE->newSlot($rep, $comp);
           Grid->setCode("$se.ComponentInsertEvent.slot");
           $hm->insertCompEvent($comp,$physicalFrame, $report, $orep, $ctrl, $nkey, $wwn, {system => 1});
         }
     }
  }
  for ($x=$SLOTS+1; $x < $OSLOTS; $x++) {
     $comp = "slot.$x";
     $okey = $orep->get("$comp.dev-key");
     Grid->setCode("$se.ComponentRemoveEvent.slot");
     $hm->removeCompEvent($comp,$physicalFrame, $report, $orep, 'CIM_Card',$okey, $wwn, {system => 1});
  }

}

  
sub status {
   my($hm, $rep, $orep, $comp) = @_;

   my $osev = $orep->get("$comp.status-sev") || 0;
   my $nsev =  $rep->get("$comp.status-sev") || 0;

   my $old =  $orep->get("$comp.status-desc");
   my $new =  $rep->get("$comp.status-desc");

   my $oavail =  $orep->get("$comp.status-avail");
   my $navail =  $rep->get("$comp.status-avail");

   return ($old, $new, $osev, $nsev, $oavail, $navail);
}



1;
