package Health::6130;
use NWS::6130;
use strict;

use Health::COMMON;
use base 'Health::COMMON';

sub NWS_module {
  return "NWS::6130";
}

sub component_lists {
  return {
    physical => ["ctrl,device,disk,pcu,midplane,sfp,iom",    "_Realized"],
    logical  => ["volume,lun,pool,vdisk,fan,battery,fcport", "_DeviceID"],
         };
}

# Returns an array of component types that have internal fibre ports.
# That is ports that are on the internal loop.
sub internal_port_components {

#  return [ "ctrl", "disk", "iom"]
# The counters have been removed.
  return [ ]
}


#
# ADD EXTRA EVENTS
#

# hm		Reference to the
# key	    	The unique key for this device
# display_id	The display name.
# rep		The current report
# orep		The last report
#
sub EXTRA_LOGIC 
{
  my($hm, $key, $display_id, $rep, $orep, $report) = @_;
  
  my $type     = $report->id('category');
  my $short_id = $report->name();

  foreach my $el (keys %$rep) 
  {
     my @tokens = split(/\./, $el);
     my $component = "$tokens[0].$tokens[1]";

     # Volume failover
     if  ($el =~ "onPreferredManager")
     {
        Grid->setCode("$type.ValueChangeEvent.volumeFailover");
	my $readable = $orep->get("$component._ElementName");

        my $arg = { comp_name => $readable };

        $hm->mapValueChangeEvent($report, $orep, $type, $component, "onPreferredManager", $short_id, $short_id, $key, undef, $arg);
     }

     elsif  ($el =~ "hasDegradedChannel")
     {
        Grid->setCode("$type.ValueChangeEvent.diskChannel");
	my $readable = $orep->get("$component._ElementName");

        my $arg = { comp_name => $readable };

        $hm->mapValueChangeEvent($report, $orep, $type, $component, "hasDegradedChannel", $short_id, $short_id, $key, undef, $arg);
     }

     elsif  ($el =~ "nonRedundantAccess")
     {
        Grid->setCode("$type.ValueChangeEvent.diskAccess");
	my $readable = $orep->get("$component._ElementName");

        my $arg = { comp_name => $readable };

        $hm->mapValueChangeEvent($report, $orep, $type, $component, "nonRedundantAccess", $short_id, $short_id, $key, undef, $arg);
     }

     elsif  ($el =~ "uncertified")
     {

        Grid->setCode("$type.ValueChangeEvent.certification");
	my $readable = $rep->get("$component._ElementName");

	my $oldComponent = undef;

	MATCH: foreach my $el2 (keys %$orep) 
	{
	   if ($el2 =~ "_ElementName")
	   {
	      if ($readable eq $orep->get("$el2"))
	      {
	         my @tokens2 = split(/\./, $el2);
                 $oldComponent = "$tokens2[0].$tokens2[1]";

		 last MATCH; # like a break
	      }
	   }
	}

        my $arg = { old_status => $orep->get("$oldComponent.uncertified"),
                    new_status => $rep->get("$component.uncertified")
                    comp_name => $readable };


        $hm->mapValueChangeEvent($report, $orep, $type, $component, "uncertified", $short_id, $short_id, $key, undef, $arg);
     }

     elsif  ($el =~ "ethernetStatus")
     {

        my $arg = { comp_name => $readable };

        Grid->setCode("$type.ValueChangeEvent.ethernetStatus");
	my $readable = $orep->get("$component._ElementName");
        $hm->mapValueChangeEvent($report, $orep, $type, $component, "ethernetStatus", $short_id, $short_id, $key, undef, $arg);
     }


  }

}

1;

