package Client::Perf;

use Client;
use Roles;
use Util;
use strict 'vars';
use System;
use Perf;

sub array {
  my($q) = @_;

  print Client->http_OK();

  my $VALID_DEVS = ",6020,6120,dsp,";

  my $Config  = PDM::ConfigFile->read();
  my $devices = $Config->devices();
  my(%DEV);

  foreach my $d (@$devices) {
    next if (index($VALID_DEVS, ",$d->{type},") < 0);
    my $id = "$d->{type}:$d->{key}";
    $DEV{$id} = $d;
  }

  my $file = $q->{mode} eq "C" ? "stat1" : "stat3"; #Current=1, Hourly=3
  
  if ($q->{data} eq "R") {
     $file = $q->{mode} eq "C" ? "currentReplication" : "hourlyReplication";
  }

  my $T = Perf->read($file);

  my $date = Perf->getDate($file);

  print "<DEVICES>\n";
  foreach my $n (sort keys %DEV) {
    my $d = $DEV{$n};
    if ($q->{dev} eq "ALL" || $q->{dev} eq $n) {
      &display_totals($q, $d, $T, $date);
    }
  }
  print "</DEVICES>\n";

}

#
# DSP   : 0 = BytesRead, 1 = BytesWritten
# Array : 0 = MegsRead,  1 = megsWritten
# stat1 (total) is the io of the last probe
#
sub display_totals {
  my($q, $dev, $T, $date) = @_;

  my($day,$time) = split(/ /, $date);
  my $renv = System->get_renv();
  my (%EL, %G, $cols, $maxr);

  foreach my $k (sort keys %$T) {
    my($mode, $name, $el) = split(/\./, $k);
    next if ($name ne $dev->{name});

    my $secs = $T->{$k}[0];
    my $count = $T->{$k}[11]; # Count


    my $meg_r;
    my $meg_w;
    if ($q->{data} eq "I") { # IOPS (IO per seconds)
      $meg_r = $secs ? $T->{$k}[7] / $secs : 0; # megs / sec read
      $meg_w = $secs ? $T->{$k}[8] / $secs : 0; # megs / sec written
    } elsif ($q->{data} eq "M") { # Megs (Megabytes per seconds)
      $meg_r = $secs ? $T->{$k}[1] / $secs : 0; # megs / sec read
      $meg_w = $secs ? $T->{$k}[2] / $secs : 0; # megs / sec written
    } elsif ($q->{data} eq "R") { # Replication (Megabytes)
      $meg_r = $T->{$k}[1] ? $T->{$k}[1] : 0; # Queue Depth megs
      $meg_w = $T->{$k}[2] ? $T->{$k}[2] : 0; # Queue Size megs
    } else {  # Port Utilization      
      $meg_r = $count ? $T->{$k}[9]  / $count :0; # Average Port/Volume Utilization during read
      $meg_w = $count ? $T->{$k}[10]  / $count :0; # Average Port/Volume Utilization during write
    }

    $EL{$el} = 1;
    $G{$mode}{$el} = [$meg_r, $meg_w];
    $maxr = $meg_r if ($meg_r > $maxr);
    $maxr = $meg_w if ($meg_w > $maxr);
  }

  print "  <DEVICE NAME=\"$dev->{name}\">\n";

  $maxr = 1 if (!$maxr);

  foreach my $m (sort keys %G) {
    my $V = $G{$m};
    $day = &day($m);

    my $hour = &hour($m);
    my $time = &time($m);
    print "    <HOUR VALUE=\"$day $time\">\n";
    foreach my $e (sort keys %EL) {
      my $v0 = $G{$m}{$e}[0];
      my $v1 = $G{$m}{$e}[1];
      my $h_r = int($v0/$maxr * 100) || 1;
      my $h_w = int($v1/$maxr * 100) || 1;
      my $r_v = sprintf("%.1f", $v0);
      my $w_v = sprintf("%.1f", $v1);
      print "      <UNIT>";
      print "<NAME>$e</NAME>";
      print "<READ>$r_v</READ>";
      print "<WRITE>$w_v</WRITE>";
      print "</UNIT>\n";
    }
    print "    </HOUR>\n";
  }
  print "  </DEVICE>\n";

}

sub day {
  my($v) = @_;
  my $v0 = substr($v,0,10);
  return "$v0";
}

sub hour {
  my($v) = @_;
  my $v0 = substr($v,0,10);
  my $v1 = substr($v,11,2);
  return "$v0 $v1";
}

sub time {
  my($v) = @_;
  my $v0 = substr($v,0,5);
  if ($v0 eq "total") {
    return $v0;
  }
  my $v1 = substr($v,11,2);
  return "$v1:00:00";
}


1;


