/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.contour;

import java.util.Arrays;
import java.util.Date;
import java.util.Vector;
import org.jfree.data.Range;
import org.jfree.data.contour.ContourDataset;
import org.jfree.data.xy.AbstractXYZDataset;

public class DefaultContourDataset
extends AbstractXYZDataset
implements ContourDataset {
    protected String seriesName = null;
    protected Number[] xValues = null;
    protected Number[] yValues = null;
    protected Number[] zValues = null;
    protected int[] xIndex = null;
    boolean[] dateAxis = new boolean[3];

    public DefaultContourDataset() {
    }

    public DefaultContourDataset(String seriesName, Object[] xData, Object[] yData, Object[] zData) {
        this.seriesName = seriesName;
        this.initialize(xData, yData, zData);
    }

    public void initialize(Object[] xData, Object[] yData, Object[] zData) {
        this.xValues = new Double[xData.length];
        this.yValues = new Double[yData.length];
        this.zValues = new Double[zData.length];
        Vector<Integer> tmpVector = new Vector<Integer>();
        double x = 1.123452E31;
        int k = 0;
        while (k < this.xValues.length) {
            if (xData[k] != null) {
                Number xNumber;
                if (xData[k] instanceof Number) {
                    xNumber = (Number)xData[k];
                } else if (xData[k] instanceof Date) {
                    this.dateAxis[0] = true;
                    Date xDate = (Date)xData[k];
                    xNumber = new Long(xDate.getTime());
                } else {
                    xNumber = new Integer(0);
                }
                this.xValues[k] = new Double(xNumber.doubleValue());
                if (x != this.xValues[k].doubleValue()) {
                    tmpVector.add(new Integer(k));
                    x = this.xValues[k].doubleValue();
                }
            }
            ++k;
        }
        Object[] inttmp = tmpVector.toArray();
        this.xIndex = new int[inttmp.length];
        int i = 0;
        while (i < inttmp.length) {
            this.xIndex[i] = (Integer)inttmp[i];
            ++i;
        }
        int k2 = 0;
        while (k2 < this.yValues.length) {
            this.yValues[k2] = (Double)yData[k2];
            if (zData[k2] != null) {
                this.zValues[k2] = (Double)zData[k2];
            }
            ++k2;
        }
    }

    public static Object[][] formObjectArray(double[][] data) {
        Object[][] object = new Double[data.length][data[0].length];
        int i = 0;
        while (i < object.length) {
            int j = 0;
            while (j < object[i].length) {
                object[i][j] = new Double(data[i][j]);
                ++j;
            }
            ++i;
        }
        return object;
    }

    public static Object[] formObjectArray(double[] data) {
        Object[] object = new Double[data.length];
        int i = 0;
        while (i < object.length) {
            object[i] = new Double(data[i]);
            ++i;
        }
        return object;
    }

    public int getItemCount(int series) {
        if (series > 0) {
            System.out.println("Only one series for contour");
        }
        return this.zValues.length;
    }

    public double getMaxZValue() {
        double zMax = -1.0E20;
        int k = 0;
        while (k < this.zValues.length) {
            if (this.zValues[k] != null) {
                zMax = Math.max(zMax, this.zValues[k].doubleValue());
            }
            ++k;
        }
        return zMax;
    }

    public double getMinZValue() {
        double zMin = 1.0E20;
        int k = 0;
        while (k < this.zValues.length) {
            if (this.zValues[k] != null) {
                zMin = Math.min(zMin, this.zValues[k].doubleValue());
            }
            ++k;
        }
        return zMin;
    }

    public Range getZValueRange(Range x, Range y) {
        double minX = x.getLowerBound();
        double minY = y.getLowerBound();
        double maxX = x.getUpperBound();
        double maxY = y.getUpperBound();
        double zMin = 1.0E20;
        double zMax = -1.0E20;
        int k = 0;
        while (k < this.zValues.length) {
            if (this.xValues[k].doubleValue() >= minX && this.xValues[k].doubleValue() <= maxX && this.yValues[k].doubleValue() >= minY && this.yValues[k].doubleValue() <= maxY && this.zValues[k] != null) {
                zMin = Math.min(zMin, this.zValues[k].doubleValue());
                zMax = Math.max(zMax, this.zValues[k].doubleValue());
            }
            ++k;
        }
        return new Range(zMin, zMax);
    }

    public double getMinZValue(double minX, double minY, double maxX, double maxY) {
        double zMin = 1.0E20;
        int k = 0;
        while (k < this.zValues.length) {
            if (this.zValues[k] != null) {
                zMin = Math.min(zMin, this.zValues[k].doubleValue());
            }
            ++k;
        }
        return zMin;
    }

    public int getSeriesCount() {
        return 1;
    }

    public String getSeriesName(int series) {
        if (series > 0) {
            System.out.println("Only one series for contour");
        }
        return this.seriesName;
    }

    public int[] getXIndices() {
        return this.xIndex;
    }

    public Number[] getXValues() {
        return this.xValues;
    }

    public Number getX(int series, int item) {
        if (series > 0) {
            System.out.println("Only one series for contour");
        }
        return this.xValues[item];
    }

    public Number getXValue(int item) {
        return this.xValues[item];
    }

    public Number[] getYValues() {
        return this.yValues;
    }

    public Number getY(int series, int item) {
        if (series > 0) {
            System.out.println("Only one series for contour");
        }
        return this.yValues[item];
    }

    public Number[] getZValues() {
        return this.zValues;
    }

    public Number getZ(int series, int item) {
        if (series > 0) {
            System.out.println("Only one series for contour");
        }
        return this.zValues[item];
    }

    public int[] indexX() {
        int[] index = new int[this.xValues.length];
        int k = 0;
        while (k < index.length) {
            index[k] = this.indexX(k);
            ++k;
        }
        return index;
    }

    public int indexX(int k) {
        int i = Arrays.binarySearch(this.xIndex, k);
        if (i >= 0) {
            return i;
        }
        return -1 * i - 2;
    }

    public int indexY(int k) {
        return k / this.xValues.length;
    }

    public int indexZ(int i, int j) {
        return this.xValues.length * j + i;
    }

    public boolean isDateAxis(int axisNumber) {
        if (axisNumber < 0 || axisNumber > 2) {
            return false;
        }
        return this.dateAxis[axisNumber];
    }

    public void setSeriesNames(String[] seriesNames) {
        if (seriesNames.length > 1) {
            System.out.println("Contours only support one series");
        }
        this.seriesName = seriesNames[0];
        this.fireDatasetChanged();
    }
}

