/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.fm.wbem.client;

import com.sun.netstorage.fm.storade.resource.report.ReportClass;
import com.sun.netstorage.fm.util.Options;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.Principal;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.wbem.cim.CIMDataType;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMNameSpace;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.client.CIMClient;
import javax.wbem.client.PasswordCredential;
import javax.wbem.client.UserPrincipal;

public class Report {
    public static final String CIM_COMPUTER_SYSTEM = "CIM_ComputerSystem";
    public static final String DEVICE_CLASS = "CIM_ComputerSystem";
    private Logger logger = Logger.getLogger("com.sun.netstorage.fm.wbem.client");
    private ReportClass system_rc;
    private static final String[] ELEMENT_PROPS = new String[]{"Caption", "Description", "ElementName", "Name"};
    private static final String[] LOGICAL_PROPS = new String[]{"Status", "OperationalStatus", "StatusDescriptions", "EnabledState", "RequestedState", "TimeOfLastStateChange", "EnabledDefault"};
    private static final String[] PHYSICAL_PROPS = new String[]{"Manufacturer", "Model", "SerialNumber", "Version", "PartNumber", "SKU", "ManufactureDate", "Tag", "RemovalConditions"};
    private static final String[][] PHYSICAL_PROPS_LIST = new String[][]{ELEMENT_PROPS, PHYSICAL_PROPS};
    private static final String[] SYSTEM_PROPS = new String[]{"Dedicated", "NameFormat", "Roles"};
    private static final String[][] SYSTEM_PROPS_LIST = new String[][]{SYSTEM_PROPS, LOGICAL_PROPS, ELEMENT_PROPS};
    private static final String[] DEVICE_PROPS = new String[]{"Avalibility", "DeviceID"};
    private static final String[][] DEVICE_PROPS_LIST = new String[][]{ELEMENT_PROPS, LOGICAL_PROPS, DEVICE_PROPS};
    private static final String[] VOLUME_PROPS = new String[]{"DataOrganization", "Purpose", "Access", "ErrorMethodology", "BlockSize", "NumberOfBlocks", "ConsumableBlocks", "IsBasedOnUnderlyingRedundancy", "SequentialAccess", "DataRedundancy", "DeltaReservation", "ExtentStatus", "NoSinglePointOfFailure", "Primordial", "VolumeStatus", "Capabilities", "MaxMediaSize", "DefaultBlockSize", "MaxBlockSize", "MinBlockSize"};
    private static final String[][] VOLUME_PROPS_LIST = new String[][]{ELEMENT_PROPS, LOGICAL_PROPS, DEVICE_PROPS, VOLUME_PROPS};
    private static final String[] FCPORT_PROPS = new String[]{"PortType", "Speed", "MaxSpeed", "PortNumber", ":PermanentAddress=PortWWN", "NetworkAddresses", "SupportedCOS", "ActiveCOS", "SupportedFC4Types", "ActiveFC4Types"};
    private static final String[] FCPORT_STAT_PROPS = new String[]{"LIPCount", "NOSCount", "ErrorFrames", "DumpedFrames", "LinkFailures", "LossOfSignalCounter", "LossOfSyncCounter", "PrimitiveSeqProtocolErrCount", "CRCErrors", "InvalidTransmissionWords", "FramesTooShort", "FramesTooLong", "AddressErrors", "BufferCreditNotProvided", "BufferCreditNotReceived", "DelimiterErrors", "EncodingDisparityErrors", "LinkResetsReceived", "LinkResetsTransmitted", "MulticastFramesReceived", "MulticastFramesTransmitted", "FBSYFrames", "PBSYFrames", "FRJTFrames", "PRJTFrames", "TxFrameRate", "RxFrameRate", "TxRate", "RxRate", "BytesTransmitted", "BytesReceived", "PacketsTransmitted", "PacketsReceived"};
    private static final String[][] FCPORT_PROPS_LIST = new String[][]{ELEMENT_PROPS, LOGICAL_PROPS, DEVICE_PROPS, FCPORT_PROPS};
    private static final String[] CTRL_PROPS = new String[]{"TimeOfLastReset", "ProtocolSupported", "MaxTransferRate", "MaxDataWidth"};
    private static final String[][] CTRL_PROPS_LIST = new String[][]{ELEMENT_PROPS, LOGICAL_PROPS, DEVICE_PROPS, CTRL_PROPS};
    private static final String[][] MODULE_PROPS_LIST = new String[][]{ELEMENT_PROPS, LOGICAL_PROPS, DEVICE_PROPS, {"ModuleNumber"}};
    private static final String[] IGNORE_PROPS = new String[]{"CreationClassName", "SystemName", "SystemCreationClassName"};
    Map classMap = new HashMap();
    static boolean debug;
    private boolean stdOnly;
    private boolean useXML = true;
    private CIMClient cimClient;
    private CIMNameSpace nameSpace;
    private String name;
    private String systemClassName = "CIM_ComputerSystem";
    private String hostName;
    private String user;
    private String pass;
    private String cimNameSpace;
    public static final String sccs_id = "@(#)Report.java\t1.4 09/18/03 SMI";

    public Report(String url) {
        this.hostName = url;
        this.user = "guest";
        this.pass = "";
    }

    public Report(String hostName, String user, String pass) throws CIMException {
        this.hostName = hostName;
        this.user = user;
        this.pass = pass;
    }

    public void setNameSpace(String nameSpace) {
        this.cimNameSpace = nameSpace;
    }

    public void useRMIProtocolFirst(boolean rmi) {
        this.useXML = !rmi;
    }

    private void connect() throws CIMException {
        this.nameSpace = new CIMNameSpace(this.hostName, this.cimNameSpace);
        UserPrincipal principal = new UserPrincipal(this.user);
        PasswordCredential credential = new PasswordCredential(this.pass);
        String protocol = this.useXML ? "cim-xml" : "cim-rmi";
        String altproto = this.useXML ? "cim-rmi" : "cim-xml";
        this.logger.fine("Connect:" + this.hostName + "/" + this.cimNameSpace + "&" + this.user + "@" + this.pass);
        try {
            this.cimClient = new CIMClient(this.nameSpace, (Principal)principal, (Object)credential, protocol);
        }
        catch (Exception e) {
            this.cimClient = new CIMClient(this.nameSpace, (Principal)principal, (Object)credential, altproto);
        }
    }

    public void close() throws CIMException {
        this.cimClient.close();
    }

    public synchronized ReportClass getSystemReport() {
        ReportClass rc;
        this.system_rc = rc = new ReportClass("system");
        CIMObjectPath cop = new CIMObjectPath(this.systemClassName);
        cop.addKey("Name", new CIMValue((Object)this.name));
        cop.addKey("CreationClassName", new CIMValue((Object)this.systemClassName));
        rc.setProperty("_Name", this.name);
        rc.setProperty("_ElementName", this.name);
        rc.setKey(this.systemClassName + ":" + this.name);
        try {
            if (this.cimClient == null) {
                this.connect();
            }
            CIMInstance system = this.cimClient.getInstance(cop, false, true, true);
            this.logger.fine("System:" + system);
            this.addComputerSystem(rc, system);
            this.addSubSystem(rc, system);
        }
        catch (Exception e) {
            rc.setProperty("_Status", "Unknown");
            this.addError(rc, e, "Major");
        }
        return rc;
    }

    private ReportClass addError(ReportClass rc, Exception e, String sev) {
        Date now = new Date();
        long millis = now.getTime();
        String msgid = "" + millis + ':' + e.getClass().getName() + 64 + Integer.toHexString(e.hashCode());
        ReportClass msg_rc = rc.newSubInstance("error", msgid);
        StringWriter sw = new StringWriter();
        PrintWriter out = new PrintWriter(sw);
        e.printStackTrace(out);
        msg_rc.setProperty("_Type", "Defect");
        msg_rc.setProperty("_Time", now.toString());
        msg_rc.setProperty("_Source", "StorADE");
        msg_rc.setProperty("_Severity", sev);
        msg_rc.setProperty("_Description", "Java Exception:" + e.getMessage());
        msg_rc.setProperty("Trace", sw.toString());
        return msg_rc;
    }

    private void printReferences(CIMObjectPath cop) {
        try {
            Enumeration refs = this.cimClient.references(cop);
            while (refs.hasMoreElements()) {
                CIMInstance ci = (CIMInstance)refs.nextElement();
                System.out.println("  " + ci.toMOF());
            }
        }
        catch (CIMException ce) {
            System.out.println("printReferences " + cop + " ERROR " + ce.getMessage());
        }
    }

    private void printAssocs(CIMObjectPath cop) {
        try {
            Enumeration assocs = this.cimClient.associators(cop);
            while (assocs.hasMoreElements()) {
                CIMInstance ci = (CIMInstance)assocs.nextElement();
                cop = ci.getObjectPath();
                System.out.println("  " + cop);
            }
        }
        catch (CIMException ce) {
            System.out.println("printAssocs " + cop + " ERROR " + ce.getMessage());
        }
    }

    private void addSubSystem(ReportClass rc, CIMInstance system) {
        try {
            CIMInstance[] subsystems = this.traverseAssocs(system, "CIM_ComponentCS", "GroupComponent");
            for (int i = 0; i < subsystems.length; ++i) {
                CIMInstance ci = subsystems[i];
                this.logger.fine("Subsystem:" + ci);
                ReportClass subrc = rc.newSubInstance("unit", this.getStringValue(ci, "Name"));
                this.addComputerSystem(subrc, ci);
            }
        }
        catch (Exception ce) {
            this.addError(rc, ce, "Minor");
        }
    }

    private void addComputerSystem(ReportClass rc, CIMInstance system) {
        this.fillReportClass(rc, system, SYSTEM_PROPS_LIST);
        String[] infoDesc = this.getStringValues(system, "IdentifyingDescriptions");
        if (infoDesc.length > 0) {
            String[] info = this.getStringValues(system, "OtherIdentifyingInfo");
            for (int i = 0; i < infoDesc.length; ++i) {
                if (!"IP Address".equals(infoDesc[i])) continue;
                rc.setProperty("IPAddress", info[i]);
            }
        }
        this.addComputerSystemPackage(rc, system);
        this.addSystemDevice(rc, system);
    }

    private void addComputerSystemPackage(ReportClass rc, CIMInstance system) {
        CIMObjectPath cop = system.getObjectPath();
        CIMInstance pack_ci = this.traverseAssoc(system, "CIM_ComputerSystemPackage", "Dependent");
        if (pack_ci != null) {
            this.fillPhysicalPackage(rc, pack_ci);
        }
    }

    private void fillPhysicalPackage(ReportClass rc, CIMInstance phy) {
        this.fillReportClass(rc, phy, PHYSICAL_PROPS_LIST);
        this.logger.fine("Package:" + phy.getObjectPath());
        CIMInstance loc_ci = this.traverseAssoc(phy, "CIM_ElementLocation", "Element");
        if (loc_ci != null) {
            this.logger.fine("Location:" + loc_ci.getObjectPath());
            this.setProperty(rc, loc_ci, "_Location", "Name");
            this.setStdProp(rc, loc_ci, "PhysicalPosition");
            this.setStdProp(rc, loc_ci, "Address");
        }
    }

    private void addSystemDevice(ReportClass rc, CIMInstance system) {
        try {
            HashMap<String, ReportClass> frumap = new HashMap<String, ReportClass>();
            CIMInstance[] sysdevs = this.getAssocs(system, "CIM_SystemDevice", "GroupComponent");
            for (int di = 0; di < sysdevs.length; ++di) {
                CIMInstance ext_ci;
                CIMValue partval;
                CIMInstance sysdev = sysdevs[di];
                CIMProperty partprop = sysdev.getProperty("PartComponent");
                if (partprop == null || (partval = partprop.getValue()) == null) continue;
                CIMObjectPath partref = (CIMObjectPath)partval.getValue();
                CIMInstance ci = this.cimClient.getInstance(partref, false, true, true);
                String devType = this.getDeviceType(ci);
                this.logger.fine("Device:" + ci.getObjectPath());
                ReportClass devrc = new ReportClass(devType, this.getStringValue(ci, "DeviceID"));
                if ("volume".equals(devType)) {
                    this.fillReportClass(devrc, ci, VOLUME_PROPS_LIST);
                    ext_ci = this.traverseAssocs(ci, "CIM_BasedOn", "Dependent");
                    if (((CIMInstance[])ext_ci).length > 0) {
                        StringBuffer sb = new StringBuffer();
                        for (int i = 0; i < ((CIMInstance[])ext_ci).length; ++i) {
                            sb.append("\"");
                            sb.append(this.getStringValue(ext_ci[i], "DeviceID"));
                            sb.append("\"");
                            if (i + 1 >= ((CIMInstance)ext_ci).length) continue;
                            sb.append(", ");
                        }
                        devrc.setProperty("_BasedOn", sb.toString());
                    }
                } else if ("extent".equals(devType)) {
                    CIMInstance md_ci = this.traverseAssoc(ci, "CIM_MediaPresent", "Dependent");
                    if (md_ci != null) {
                        devrc = null;
                    } else {
                        this.fillReportClass(devrc, ci, VOLUME_PROPS_LIST);
                    }
                } else if ("pool".equals(devType)) {
                    this.fillReportClass(devrc, ci, VOLUME_PROPS_LIST);
                } else if ("vdisk".equals(devType)) {
                    this.fillReportClass(devrc, ci, VOLUME_PROPS_LIST);
                } else if ("disk".equals(devType)) {
                    this.fillReportClass(devrc, ci, DEVICE_PROPS_LIST);
                    ext_ci = this.traverseAssoc(ci, "CIM_MediaPresent", "Antecedent");
                    if (ext_ci != null) {
                        this.fillReportClass(devrc, ext_ci, VOLUME_PROPS_LIST);
                    }
                } else if ("port".equals(devType)) {
                    this.fillReportClass(devrc, ci, DEVICE_PROPS_LIST);
                } else if ("fcport".equals(devType)) {
                    CIMInstance mod_ci;
                    this.fillReportClass(devrc, ci, FCPORT_PROPS_LIST);
                    CIMInstance[] fc_stats = this.traverseAssocs(ci, "CIM_ElementStatisticalData", "ManagedElement");
                    if (fc_stats != null) {
                        for (int i = 0; i < fc_stats.length; ++i) {
                            this.fillReportClass(devrc, fc_stats[i], FCPORT_STAT_PROPS);
                        }
                    }
                    if ((mod_ci = this.traverseAssoc(ci, "CIM_ModulePort", "PartComponent")) != null) {
                        devrc.setProperty("_ModuleNumber", this.getStringValue(mod_ci, "ModuleNumber"));
                    }
                    this.addSAP(devrc, ci);
                } else if ("fcport".equals(devType)) {
                    this.fillReportClass(devrc, ci, MODULE_PROPS_LIST);
                } else {
                    this.fillReportClass(devrc, ci, DEVICE_PROPS_LIST);
                }
                if (devrc == null) continue;
                rc.addChild(devrc);
                CIMInstance phy_ci = this.traverseAssoc(ci, "CIM_Realizes", "Dependent");
                if (phy_ci == null) continue;
                String frukey = this.getStringValue(phy_ci, "Tag");
                devrc.setProperty("_Realized", frukey);
                if (frumap.get(frukey) != null) continue;
                ReportClass frurc = rc.newSubInstance("fru", frukey);
                this.fillPhysicalPackage(frurc, phy_ci);
                frumap.put(frukey, frurc);
            }
        }
        catch (CIMException ce) {
            this.addError(rc, (Exception)((Object)ce), "Major");
        }
    }

    private CIMInstance traverseAssoc(CIMInstance ci, String assocName, String role) {
        block3: {
            try {
                Object nextElem;
                Enumeration e = this.cimClient.associators(ci.getObjectPath(), assocName, null, role, null, true, true, null);
                if (e.hasMoreElements() && (nextElem = e.nextElement()) instanceof CIMInstance) {
                    return (CIMInstance)nextElem;
                }
            }
            catch (CIMException e) {
                if ("CIM_ERR_NOT_FOUND".equals(e.getMessage())) break block3;
                ReportClass error = this.addError(this.system_rc, (Exception)((Object)e), "Minor");
                error.setProperty("Association", assocName);
                error.setProperty("Role", role);
            }
        }
        return null;
    }

    private CIMInstance[] traverseAssocs(CIMInstance ci, String assocName, String role) {
        LinkedList list;
        block3: {
            list = new LinkedList();
            try {
                Enumeration e = this.cimClient.associators(ci.getObjectPath(), assocName, null, role, null, true, true, null);
                while (e.hasMoreElements()) {
                    Object nextElem = e.nextElement();
                    if (!(nextElem instanceof CIMInstance)) continue;
                    list.add(nextElem);
                }
            }
            catch (CIMException e) {
                if ("CIM_ERR_NOT_FOUND".equals(e.getMessage())) break block3;
                ReportClass error = this.addError(this.system_rc, (Exception)((Object)e), "Minor");
                error.setProperty("Association", assocName);
                error.setProperty("Role", role);
            }
        }
        CIMInstance[] ciList = new CIMInstance[list.size()];
        list.toArray(ciList);
        return ciList;
    }

    private CIMInstance[] getAssocs(CIMInstance ci, String assocName, String role) {
        LinkedList list;
        block3: {
            list = new LinkedList();
            try {
                Enumeration e = this.cimClient.references(ci.getObjectPath(), assocName, role, true, true, null);
                while (e.hasMoreElements()) {
                    Object nextElem = e.nextElement();
                    if (!(nextElem instanceof CIMInstance)) continue;
                    list.add(nextElem);
                }
            }
            catch (CIMException e) {
                if ("CIM_ERR_NOT_FOUND".equals(e.getMessage())) break block3;
                ReportClass error = this.addError(this.system_rc, (Exception)((Object)e), "Minor");
                error.setProperty("Association", assocName);
                error.setProperty("Role", role);
            }
        }
        CIMInstance[] ciList = new CIMInstance[list.size()];
        list.toArray(ciList);
        return ciList;
    }

    private void addSAP(ReportClass rc, CIMInstance port) {
        try {
            CIMInstance[] sap_ci = this.traverseAssocs(port, "CIM_DeviceSAPImplementation", "Antecedent");
            if (sap_ci.length == 0) {
                String wwn = this.getStringValue(port, "PermanentAddress");
                rc.setProperty("_PortWWN", this.parseWWN(wwn));
            }
            for (int i = 0; i < sap_ci.length; ++i) {
                CIMInstance aci = sap_ci[i];
                CIMInstance[] remote_sap_ci = this.traverseAssocs(aci, "CIM_ActiveConnection", null);
                String aciName = this.getStringValue(aci, "Name");
                if (aciName.indexOf("#") != -1) {
                    aciName = aciName.charAt(0) == '\"' ? aciName.substring(1, aciName.lastIndexOf("#")) : aciName.substring(0, aciName.lastIndexOf("#"));
                }
                if (aci.getClassName().equals("Brocade_SANProtocolEndPoint")) {
                    aciName = this.parseWWN(aciName);
                }
                rc.setProperty("_PortWWN", aciName);
                for (int j = 0; j < remote_sap_ci.length; ++j) {
                    CIMInstance ci = remote_sap_ci[j];
                    String ciName = ci.getProperty("Name").getValue().toString();
                    if (ciName.indexOf("#") != -1) {
                        if ((ciName = ciName.substring(ciName.indexOf("#") + 1)).indexOf("#") != -1 && (ciName = ciName.substring(ciName.indexOf("#") + 1)).indexOf("#") != -1) {
                            ciName = ciName.substring(0, ciName.indexOf("#"));
                        }
                        ci.setProperty("Name", new CIMValue((Object)ciName));
                    }
                    if (ci.getClassName().equals("Brocade_SANProtocolEndPoint")) {
                        ciName = this.parseWWN(ciName);
                    }
                    rc.setProperty("_RemoteWWN", ciName);
                }
            }
        }
        catch (CIMException ce) {
            this.addError(this.system_rc, (Exception)((Object)ce), "Minor");
        }
    }

    private String parseWWN(String wwn) {
        int fi = wwn.indexOf("\"");
        int li = wwn.lastIndexOf("\"");
        if (fi >= 0 && li >= 0) {
            return wwn.substring(fi, li);
        }
        return wwn;
    }

    private String getDeviceType(CIMInstance ci) {
        Vector v = ci.getProperties();
        String devType = "dev";
        for (int i = 0; i < v.size(); ++i) {
            CIMProperty cp = (CIMProperty)v.get(i);
            String oc = cp.getOriginClass();
            if ("CIM_StorageExtent".equals(oc) && devType.equals("dev")) {
                devType = "extent";
            }
            if ("CIM_StorageVolume".equals(oc)) {
                devType = "volume";
            }
            if ("CIM_StorageVolumeSet".equals(oc)) {
                return "vdisk";
            }
            if ("CIM_LogicalDisk".equals(oc)) {
                return "disk";
            }
            if ("CIM_MediaAccessDevice".equals(oc)) {
                devType = "disk";
            }
            if ("CIM_TapeDrive".equals(oc)) {
                devType = "tape";
            }
            if ("CIM_ProtocolController".equals(oc)) {
                return "ctrl";
            }
            if ("CIM_Controller".equals(oc)) {
                return "ctrl";
            }
            if ("CIM_PowerSupply".equals(oc)) {
                return "pcu";
            }
            if ("CIM_LogicalPort".equals(oc)) {
                devType = "port";
            }
            if ("CIM_FCPort".equals(oc)) {
                return "fcport";
            }
            if (!"CIM_LogicalModule".equals(oc)) continue;
            return "module";
        }
        return devType;
    }

    private void setStdProp(ReportClass rc, CIMInstance ci, String name) {
        rc.setProperty("_" + name, this.getStringValue(ci, name));
    }

    private void setProperty(ReportClass rc, CIMInstance ci, String name) {
        rc.setProperty(name, this.getStringValue(ci, name));
    }

    private void setProperties(ReportClass rc, CIMInstance ci, String[] names) {
        for (int i = 0; i < names.length; ++i) {
            this.setProperty(rc, ci, names[i]);
        }
    }

    private void setProperty(ReportClass rc, CIMInstance ci, String name, String rname) {
        rc.setProperty(rname, this.getStringValue(ci, name));
    }

    private String getStringValue(CIMInstance ci, String var) {
        return this.getStringValue(ci.getProperty(var));
    }

    private String getStringValue(CIMProperty cp) {
        Object value;
        CIMValue cv;
        if (cp != null && (cv = cp.getValue()) != null && (value = cv.getValue()) != null) {
            if (cv.isArrayValue()) {
                return cv.toString();
            }
            CIMDataType type = cv.getType();
            switch (type.getType()) {
                case 8: 
                case 9: {
                    return "" + value;
                }
            }
            return cv.toString();
        }
        return null;
    }

    private String[] getStringValues(CIMInstance ci, String var) {
        Object value;
        CIMValue cv;
        CIMProperty cp = ci.getProperty(var);
        if (cp != null && (cv = cp.getValue()) != null && (value = cv.getValue()) != null) {
            if (cv.isArrayValue()) {
                Vector vec = (Vector)value;
                String[] retval = new String[vec.size()];
                for (int i = 0; i < vec.size(); ++i) {
                    Object aval = vec.get(i);
                    retval[i] = aval == null ? null : aval.toString();
                }
                return retval;
            }
            CIMDataType type = cv.getType();
            switch (type.getType()) {
                case 8: 
                case 9: {
                    return new String[]{"" + value};
                }
            }
            return new String[]{cv.toString()};
        }
        return new String[0];
    }

    private void fillReportClass(ReportClass rc, CIMInstance ci) {
        Vector pv = ci.getProperties();
        for (int i = 0; i < pv.size(); ++i) {
            CIMProperty p = (CIMProperty)pv.get(i);
            rc.setProperty(p.getName(), this.getStringValue(p));
        }
    }

    private void fillReportClass(ReportClass rc, CIMInstance ci, String[] std) {
        Vector pv = ci.getProperties();
        for (int i = 0; i < pv.size(); ++i) {
            CIMProperty p = (CIMProperty)pv.get(i);
            String name = p.getName();
            String value = this.getStringValue(p);
            boolean isStd = false;
            for (int j = 0; j < std.length; ++j) {
                if (std[j].startsWith(":")) {
                    int index = std[j].indexOf("=");
                    if (!std[j].substring(0, index).equals(name)) continue;
                    name = "_" + std[j].substring(index + 1);
                    isStd = true;
                    break;
                }
                if (!std[j].equals(name)) continue;
                name = "_" + name;
                isStd = true;
                break;
            }
            if (this.stdOnly && !isStd) continue;
            rc.setProperty(name, value);
        }
    }

    private void fillReportClass(ReportClass rc, CIMInstance ci, String[][] astd) {
        Vector pv = ci.getProperties();
        for (int i = 0; i < pv.size(); ++i) {
            CIMProperty p = (CIMProperty)pv.get(i);
            String name = p.getName();
            String value = this.getStringValue(p);
            if (value == null) continue;
            boolean isStd = false;
            block1: for (int j = 0; j < astd.length; ++j) {
                String[] std = astd[j];
                for (int k = 0; k < std.length; ++k) {
                    if (std[k].startsWith(":")) {
                        int index = std[k].indexOf("=");
                        if (!std[k].substring(0, index).equals(name)) continue;
                        name = "_" + std[k].substring(index + 1);
                        isStd = true;
                        continue block1;
                    }
                    if (!std[k].equals(name)) continue;
                    name = "_" + name;
                    isStd = true;
                    continue block1;
                }
            }
            if (this.stdOnly && !isStd) continue;
            rc.setProperty(name, value);
        }
    }

    public static void usage() {
        System.out.println("Usage: GenReport [options] host");
        System.out.println("\t-u <user>      CIMOM user name");
        System.out.println("\t-p <passowd>   CIMOM password");
        System.out.println("\t-c <class>     CIM Classname");
        System.out.println("\t-s <name>      System name required.");
        System.out.println("\t-n <namespace> CIM Namespace");
        System.out.println("\t-h <hostname>  CIMOM hostname");
    }

    public static void main(String[] args) {
        try {
            Options opts = new Options("u:p:c:s:n:h:SRD");
            args = opts.parseOptions(args);
            String userName = opts.getOption("u", "administrator");
            String password = opts.getOption("p", "");
            String sysClass = opts.getOption("c", "CIM_System");
            String sysName = opts.getOption("s");
            String nameSpace = opts.getOption("n", "\\root\\cimv2");
            String cimomHost = opts.getOption("h", "localhost");
            boolean useRMI = opts.getFlagOption("R");
            debug = opts.getFlagOption("D");
            if (sysName == null) {
                Report.usage();
                System.exit(-1);
            }
            if (debug) {
                Handler[] h = Logger.getLogger("").getHandlers();
                for (int i = 0; i < h.length; ++i) {
                    h[i].setLevel(Level.FINEST);
                }
            }
            Report report = new Report(cimomHost, userName, password);
            if (debug) {
                report.logger.setLevel(Level.FINEST);
            }
            report.stdOnly = opts.getFlagOption("S");
            report.setNameSpace(nameSpace);
            report.setSystem(sysClass, sysName);
            if (useRMI) {
                report.useRMIProtocolFirst(true);
            }
            ReportClass rc = report.getSystemReport();
            rc.toTab(System.out);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setSystem(String sysClassName, String sysName) {
        this.systemClassName = sysClassName;
        this.name = sysName;
    }
}

