/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.fm.storade.resource.diags;

import com.sun.netstorage.fm.storade.agent.AgentConfig;
import com.sun.netstorage.fm.storade.agent.catalog.Loader;
import com.sun.netstorage.fm.storade.resource.diags.Diagnosable;
import com.sun.netstorage.fm.storade.resource.diags.DiagnosticResult;
import com.sun.netstorage.fm.storade.resource.diags.DiagnosticSetting;
import com.sun.netstorage.fm.storade.resource.diags.DiagnosticTest;
import com.sun.netstorage.fm.storade.resource.diags.TestProperties;
import com.sun.netstorage.fm.util.LocalizedString;
import com.sun.netstorage.fm.util.Options;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;

public class DiagnosticRunner {
    private String testName;
    private String deviceId;
    private String component;
    private Properties options;
    private Properties devProps;
    private DiagnosticTest test;
    public static String locale;
    private static boolean debug;
    public static final String _SOURCE_REVISION = "$Revision: 1.6 $";

    public DiagnosticRunner(String testName, String deviceId, String component, Properties options) {
        this.testName = testName;
        this.deviceId = deviceId;
        this.component = component;
        this.options = options;
    }

    public DiagnosticResult runDiag() {
        DiagnosticResult result = new DiagnosticResult();
        StringBuffer buf = result.getOutput();
        try {
            if (debug) {
                buf.append("Getting diag " + this.testName + " for " + this.deviceId);
                if (this.component != null) {
                    buf.append(":" + this.component);
                }
                buf.append("\n");
            }
            this.test = this.getDiag();
            if (debug) {
                buf.append("Getting test settings...\n");
            }
            DiagnosticSetting config = this.getSettings();
            if (debug) {
                buf.append("Test = " + this.test.getClass().getName());
                buf.append("Starting test...\n");
            }
            this.test.runTest(config, result);
            LocalizedString synopsis = result.getSynopsis();
            if (synopsis != null) {
                if (locale != null) {
                    Locale here = new Locale(locale);
                    buf.append(synopsis.getMessage(here));
                } else {
                    buf.append(synopsis.getMessage());
                }
            }
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            buf.append(sw.toString());
            result.setState(4);
            result.setPercentComplete(100);
            result.setLast(new Date());
            result.setSynopsis(DiagnosticResult.FAILED_MESSAGE);
        }
        this.test = null;
        return result;
    }

    public synchronized void abort() {
        if (this.test != null) {
            this.test.abortTest();
        }
    }

    private synchronized DiagnosticTest getDiag() throws Exception {
        if (this.test != null) {
            throw new IllegalStateException();
        }
        AgentConfig config = new AgentConfig();
        config.readConfig();
        this.devProps = config.findDevice("key", this.deviceId);
        if (this.devProps == null) {
            throw new IllegalArgumentException("key='" + this.deviceId + "'");
        }
        Loader loader = new Loader(this.devProps.getProperty("type"));
        Diagnosable diagnoser = (Diagnosable)loader.getImpl("Diagnostic");
        DiagnosticTest[] dts = diagnoser.getTests(this.devProps);
        for (int i = 0; i < dts.length; ++i) {
            TestProperties tp = dts[i].getTestProperties();
            if (!this.testName.equals(tp.getClassName())) continue;
            return dts[i];
        }
        return null;
    }

    private DiagnosticSetting getSettings() {
        DiagnosticSetting ds = new DiagnosticSetting(this.testName, this.deviceId, this.component, this.options);
        ds.setDeviceProperties(this.devProps);
        return ds;
    }

    public static void main(String[] args) {
        try {
            Options opts = new Options("n:p:c:l:D");
            args = opts.parseOptions(args);
            String userName = opts.getOption("n");
            String password = opts.getOption("p");
            String component = opts.getOption("c");
            locale = opts.getOption("l");
            debug = opts.getFlagOption("D");
            if (args.length < 2) {
                DiagnosticRunner.usage();
                System.exit(-1);
            }
            String deviceKey = args[0];
            String testName = args[1];
            Properties options = new Properties();
            for (int i = 2; i < args.length; ++i) {
                int index = args[i].indexOf("=");
                try {
                    options.setProperty(args[i].substring(0, index), args[i].substring(index + 1));
                    continue;
                }
                catch (Exception e) {
                    options.setProperty(args[i], "");
                }
            }
            DiagnosticRunner runner = new DiagnosticRunner(testName, deviceKey, component, options);
            Runtime.getRuntime().addShutdownHook(new ShutdownHook(runner));
            DiagnosticResult result = runner.runDiag();
            StringBuffer sb = result.getOutput();
            if (sb != null) {
                System.out.println(sb.toString());
            }
            System.exit(result.getState());
        }
        catch (Exception e) {
            e.printStackTrace();
            DiagnosticRunner.usage();
            System.exit(-1);
        }
    }

    private static void usage() {
        DiagnosticRunner.echo("DiagnosticRunner [exec options] <device> <test> [[opt=value]...]");
    }

    private static void echo(String msg) {
        System.out.println(msg);
    }

    private static class ShutdownHook
    extends Thread {
        private DiagnosticRunner dr;

        ShutdownHook(DiagnosticRunner dr) {
            this.dr = dr;
        }

        public void run() {
            this.dr.abort();
        }
    }
}

