/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.fm.storade.device.storage.treefrog.collector;

import com.sun.netstorage.fm.storade.device.storage.treefrog.common.Translator;
import com.sun.netstorage.fm.storade.device.storage.treefrog.common.Utility;
import devmgr.versioned.symbol.ComponentBundle;
import devmgr.versioned.symbol.ComponentRef;
import devmgr.versioned.symbol.Controller;
import devmgr.versioned.symbol.ControllerRef;
import devmgr.versioned.symbol.Drive;
import devmgr.versioned.symbol.DriveRef;
import devmgr.versioned.symbol.Esm;
import devmgr.versioned.symbol.Location;
import devmgr.versioned.symbol.ObjectBundle;
import devmgr.versioned.symbol.Tray;
import java.util.Iterator;
import java.util.TreeMap;

public class Util {
    public static String createName(ObjectBundle bundle, DriveRef ref) {
        String name = null;
        byte[] target = ref.getRefToken();
        Drive[] drives = bundle.getDrive();
        for (int i = 0; i < drives.length; ++i) {
            byte[] current = drives[i].getDriveRef().getRefToken();
            if (!Utility.rawCompare(target, current)) continue;
            Location location = drives[i].getPhysicalLocation();
            Tray physicalTray = Utility.findTray(bundle, location.getTrayRef());
            name = physicalTray != null ? "Tray." + physicalTray.getTrayId() + ".Drive." + location.getSlot() : "Tray.<null>.Drive." + location.getSlot();
        }
        return name;
    }

    public static String createSortableName(ObjectBundle bundle, DriveRef ref) {
        String name = null;
        byte[] target = ref.getRefToken();
        Drive[] drives = bundle.getDrive();
        for (int i = 0; i < drives.length; ++i) {
            String prefix;
            int id;
            byte[] current = drives[i].getDriveRef().getRefToken();
            if (!Utility.rawCompare(target, current)) continue;
            Location location = drives[i].getPhysicalLocation();
            Tray physicalTray = Utility.findTray(bundle, location.getTrayRef());
            if (physicalTray != null) {
                id = physicalTray.getTrayId() * 100 + location.getSlot();
                prefix = "";
                if (id < 10) {
                    prefix = "000";
                } else if (id < 100) {
                    prefix = "00";
                } else if (id < 1000) {
                    prefix = "0";
                }
                name = "Drive" + prefix + id;
                continue;
            }
            id = location.getSlot();
            prefix = "";
            if (id < 10) {
                prefix = "0";
            }
            name = "Drive??" + prefix + id;
        }
        return name;
    }

    public static Drive[] sortDriveArray(Drive[] drives, ObjectBundle bundle, StringBuffer buf) {
        Drive[] sortedArray = new Drive[drives.length];
        try {
            TreeMap<String, Drive> map = new TreeMap<String, Drive>();
            for (int x = 0; x < drives.length; ++x) {
                Drive drive = drives[x];
                String key = Util.createSortableName(bundle, drive.getDriveRef());
                map.put(key, drive);
            }
            int i = 0;
            Iterator iter = map.keySet().iterator();
            while (iter.hasNext()) {
                sortedArray[i++] = (Drive)map.get(iter.next());
            }
        }
        catch (Exception e) {
            sortedArray = drives;
        }
        return sortedArray;
    }

    public static String createShortName(ObjectBundle bundle, DriveRef ref) {
        String name = null;
        byte[] target = ref.getRefToken();
        Drive[] drives = bundle.getDrive();
        for (int i = 0; i < drives.length; ++i) {
            byte[] current = drives[i].getDriveRef().getRefToken();
            if (!Utility.rawCompare(target, current)) continue;
            Location location = drives[i].getPhysicalLocation();
            Tray physicalTray = Utility.findTray(bundle, location.getTrayRef());
            name = physicalTray != null ? "Tray." + physicalTray.getTrayId() + ".Drive." + location.getSlot() : "Drive [<null>," + location.getSlot() + "]";
        }
        return name;
    }

    public static String createName(ObjectBundle bundle, ControllerRef ref) {
        String name = null;
        byte[] target = ref.getRefToken();
        Controller[] controllers = bundle.getController();
        for (int i = 0; i < controllers.length; ++i) {
            byte[] current = controllers[i].getControllerRef().getRefToken();
            if (!Utility.rawCompare(target, current)) continue;
            Location location = controllers[i].getPhysicalLocation();
            Tray physicalTray = Utility.findTray(bundle, location.getTrayRef());
            name = physicalTray != null ? "Tray." + physicalTray.getTrayId() + ".Controller." + Translator.getSlotName(location.getSlot()) : "Tray.<null>.Controller." + Translator.getSlotName(location.getSlot());
        }
        return name;
    }

    public static String createIOMName(ObjectBundle bundle, ComponentRef ref) {
        String name = null;
        byte[] target = ref.getRefToken();
        ComponentBundle compBundle = bundle.getComponentBundle();
        Esm[] ioms = compBundle.getEsm();
        for (int i = 0; i < ioms.length; ++i) {
            byte[] current = ioms[i].getEsmRef().getRefToken();
            if (!Utility.rawCompare(target, current)) continue;
            Location location = ioms[i].getPhysicalLocation();
            Tray physicalTray = Utility.findTray(bundle, location.getTrayRef());
            int tray = -1;
            if (physicalTray != null) {
                tray = physicalTray.getTrayId();
            }
            int slot = location.getSlot();
            name = "Tray." + tray + ".IOM." + Translator.getSlotName(slot);
        }
        return name;
    }
}

