/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.fm.storade.device.storage.treefrog.collector;

import com.sun.netstorage.fm.storade.device.storage.treefrog.SYMbolConnection;
import com.sun.netstorage.fm.storade.device.storage.treefrog.common.Translator;
import com.sun.netstorage.fm.storade.device.storage.treefrog.diags.DiagUtility;
import devmgr.versioned.symbol.Controller;
import devmgr.versioned.symbol.NVSRAMRegion;
import devmgr.versioned.symbol.NVSRAMRegionId;
import devmgr.versioned.symbol.NVSRAMRegionList;
import devmgr.versioned.symbol.ObjectBundle;
import devmgr.versioned.symbol.ProcedureTimeout;
import devmgr.versioned.symbol.SAData;
import devmgr.versioned.symbol.SYMbolAPIClientV1;
import devmgr.versioned.symbol.StorageArray;

public class NVSRAMCollector {
    private static final String INDENT_1 = "\t";
    private static final String INDENT_2 = "\t  ";
    private static final String ONE_SPACE = " ";
    private static final String NEWLINE = "\n";
    private static final String[] nvsramTypes = new String[]{"Solaris_MPxIO", "DSP", "Windows 2000/Server 2003 Non-Clustered", "HP-UX", "AIX", "Irix", "Linux", "Windows NT Clustered (SP5 or higher)", "Windows 2000/Server 2003 Clustered", "AIX (with Veritas DMP)", "PTX", "Netware Failover", "Solaris (with Veritas DMP)", "Windows NT Non-Clustered (SP5 or higher)"};

    static String getData(String ip1, String ip2) {
        SYMbolAPIClientV1 client1 = SYMbolConnection.getOpenConnection(ip1);
        StringBuffer data = new StringBuffer();
        try {
            data.append(NVSRAMCollector.createHeader(client1));
        }
        catch (Exception e) {
            SYMbolConnection.closeClient(client1);
            client1 = SYMbolConnection.getOpenConnection(ip1);
            try {
                data.append(NVSRAMCollector.createHeader(client1));
            }
            catch (Exception e2) {
                SYMbolConnection.closeClient(client1);
                data.append("Error accessing NVSRAM data:\n" + e2.toString());
                return data.toString();
            }
        }
        try {
            data.append(NVSRAMCollector.getCurrentData(client1));
        }
        catch (Exception e) {
            try {
                SYMbolConnection.closeClient(client1);
                client1 = SYMbolConnection.getOpenConnection(ip1);
                data.append(NVSRAMCollector.getCurrentData(client1));
            }
            catch (Exception e2) {
                data.append("Exception accessing NVSRAM data: " + e2.toString() + "\n\n");
            }
        }
        SYMbolAPIClientV1 client2 = SYMbolConnection.getOpenConnection(ip2);
        try {
            data.append(NVSRAMCollector.getCurrentData(client2));
        }
        catch (Exception e) {
            try {
                SYMbolConnection.closeClient(client2);
                client2 = SYMbolConnection.getOpenConnection(ip2);
                data.append(NVSRAMCollector.getCurrentData(client2));
            }
            catch (Exception e2) {
                data.append("Exception accessing NVSRAM data: " + e2.toString() + "\n\n");
            }
        }
        SYMbolConnection.closeClient(client1);
        SYMbolConnection.closeClient(client2);
        return data.toString();
    }

    private static String getCurrentData(SYMbolAPIClientV1 client) throws Exception {
        StringBuffer sb = new StringBuffer();
        int slot = 0;
        client.setTimeout(new ProcedureTimeout().getProcTimeout(40));
        Controller[] controllers = client.getObjectGraph().getController();
        for (int i = 0; i < controllers.length; ++i) {
            if (!DiagUtility.bindToController(client, controllers[i].getControllerRef())) continue;
            slot = controllers[i].getPhysicalLocation().getSlot();
        }
        sb.append("Controller in slot " + Translator.getSlotName(slot) + NEWLINE + NEWLINE);
        client.setTimeout(new ProcedureTimeout().getProcTimeout(54));
        NVSRAMRegionId regionID = new NVSRAMRegionId(-1);
        NVSRAMRegionList regionList = client.getControllerNVSRAM(regionID);
        NVSRAMRegion[] regions = regionList.getNvsram();
        for (int x = 0; x < regions.length; ++x) {
            NVSRAMRegionId id = regions[x].getRegionId();
            sb.append("\tNVSRAM Region " + x + "   Region Id = (" + id.getValue() + ") " + Translator.translateRegionID(id));
            sb.append(NEWLINE);
            byte[] data = regions[x].getRegionData();
            sb.append(NVSRAMCollector.formatRegionData(data));
            sb.append("\n\n");
        }
        return sb.toString();
    }

    private static String formatRegionData(byte[] data) {
        StringBuffer sbuf = new StringBuffer();
        StringBuffer abuf = new StringBuffer();
        sbuf.append(INDENT_2);
        for (int i = 0; i < data.length; ++i) {
            if (i == 0 || i % 16 == 0) {
                sbuf.append("\n\t  ");
                sbuf.append(NVSRAMCollector.toHex(i, 4) + ": ");
            }
            if (i > 0 && i % 2 == 0 && i % 16 > 0) {
                sbuf.append(ONE_SPACE);
            }
            sbuf.append(NVSRAMCollector.toHex(data[i], 2));
            abuf.append(new String(data, i, 1));
            if (i <= 0 || (i + 1) % 16 != 0) continue;
            sbuf.append("    " + abuf.toString());
            abuf = new StringBuffer();
        }
        return sbuf.toString();
    }

    private static String toHex(int value, int width) {
        StringBuffer buf = new StringBuffer();
        String rep = Integer.toHexString(value);
        while (buf.length() + rep.length() < width) {
            buf.append('0');
        }
        int i = rep.length() > width ? rep.length() - width : 0;
        while (buf.length() < width) {
            buf.append(rep.charAt(i++));
        }
        return buf.toString();
    }

    private static String createHeader(SYMbolAPIClientV1 client) throws Exception {
        StringBuffer buf = new StringBuffer();
        String nvsram = "Unknown";
        client.setTimeout(new ProcedureTimeout().getProcTimeout(40));
        ObjectBundle bundle = client.getObjectGraph();
        StorageArray stArray = bundle.getSa();
        SAData array = bundle.getSa().getSaData();
        nvsram = array.getNvsramVersion();
        int defaultIndex = stArray.getDefaultHostPortTypeIndex();
        defaultIndex += 8;
        buf.append("NVSRAM Version = " + nvsram + "\n\n");
        buf.append("NVSRAM Host Type Table\n");
        buf.append(NEWLINE);
        buf.append("\tNVSRAM HOST TYPE INDEX DEFINITIONS\n");
        buf.append(NEWLINE);
        buf.append("\tINDEX        AVT STATUS  TYPE\n");
        client.setTimeout(new ProcedureTimeout().getProcTimeout(54));
        NVSRAMRegionId regionID = new NVSRAMRegionId(-1);
        NVSRAMRegionList regionList = client.getControllerNVSRAM(regionID);
        NVSRAMRegion[] regions = regionList.getNvsram();
        for (int x = 8; x < regions.length && x <= 21; ++x) {
            byte[] data = regions[x].getRegionData();
            byte enabled = data[36];
            String status = "Disabled";
            if (enabled > 0) {
                status = "Enabled ";
            }
            boolean dflag = false;
            if (x == defaultIndex) {
                dflag = true;
            }
            int index = x - 8;
            String space1 = "            ";
            String space2 = "    ";
            space1 = index < 10 ? (dflag ? " (Default)  " : "            ") : (dflag ? " (Default) " : "           ");
            buf.append(INDENT_1 + index + space1 + status + space2 + nvsramTypes[index]);
            buf.append(NEWLINE);
        }
        buf.append("\n\n");
        return buf.toString();
    }
}

