/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.fm.storade.device.storage.treefrog.collector;

import com.sun.netstorage.fm.storade.device.storage.treefrog.SYMbolConnection;
import com.sun.netstorage.fm.storade.device.storage.treefrog.collector.SupportDataCollector;
import com.sun.netstorage.fm.storade.device.storage.treefrog.common.Translator;
import com.sun.netstorage.fm.storade.device.storage.treefrog.common.Utility;
import devmgr.versioned.symbol.Drive;
import devmgr.versioned.symbol.DriveLogData;
import devmgr.versioned.symbol.DriveRef;
import devmgr.versioned.symbol.Location;
import devmgr.versioned.symbol.ObjectBundle;
import devmgr.versioned.symbol.ProcedureTimeout;
import devmgr.versioned.symbol.SYMbolAPIClientV1;
import devmgr.versioned.symbol.Tray;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

public class DriveLogCollector {
    static boolean getData(String ip, String path, String filename) {
        boolean rval = false;
        SYMbolAPIClientV1 client = SYMbolConnection.getOpenConnection(ip);
        try {
            DriveLogCollector.collectData(client, path, filename);
        }
        catch (Exception e) {
            SYMbolConnection.closeClient(client);
            client = SYMbolConnection.getOpenConnection(ip);
            try {
                DriveLogCollector.collectData(client, path, filename);
            }
            catch (Exception e2) {
                String error = "Error accessing the drive log data:\n" + e2.toString();
                SupportDataCollector.writeFile(path, filename, error);
            }
        }
        SYMbolConnection.closeClient(client);
        return rval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void collectData(SYMbolAPIClientV1 client, String path, String filename) throws Exception {
        DataOutputStream stream = null;
        client.setTimeout(new ProcedureTimeout().getProcTimeout(40));
        ObjectBundle bundle = client.getObjectGraph();
        Drive[] drives = bundle.getDrive();
        try {
            stream = DriveLogCollector.openFile(path, filename);
            for (int x = 0; x < drives.length; ++x) {
                DriveRef ref = drives[x].getDriveRef();
                client.setTimeout(new ProcedureTimeout().getProcTimeout(137));
                DriveLogData logData = client.getDriveLogData(ref);
                if (logData.getReturnCode().getValue() == 1) {
                    byte[] log = logData.getLogs();
                    Location loc = logData.getPhysicalLocation();
                    int slot = loc.getSlot();
                    Tray trayObj = Utility.findTray(bundle, loc.getTrayRef());
                    int tray = trayObj.getTrayId();
                    stream.writeUTF(logData.getSerialNumber());
                    stream.write(tray);
                    stream.write(slot);
                    stream.write(log);
                    continue;
                }
                stream.writeUTF("Unable to get the data for this drive. ");
                if (logData.getReturnCode().getValue() == 18) {
                    stream.writeUTF("An internal error has been reported by the controller that indicates ");
                    stream.writeUTF("some communication problems prevented reporting log data for the drive.");
                    continue;
                }
                stream.writeUTF("ReturnCode = " + Translator.translateReturnCode(logData.getReturnCode()));
            }
        }
        catch (IOException ioe) {
            String error = "Error writing the drive log data to a file: \n" + ioe.toString();
            SupportDataCollector.writeFile(path, filename, error);
        }
        finally {
            DriveLogCollector.closeFile(stream);
        }
    }

    private static DataOutputStream openFile(String path, String filename) {
        DataOutputStream dos = null;
        try {
            File outfile = new File(path, filename);
            FileOutputStream fos = new FileOutputStream(outfile);
            dos = new DataOutputStream(fos);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return dos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean closeFile(DataOutputStream dos) {
        if (dos != null) {
            try {
                dos.flush();
            }
            catch (Exception e) {
            }
            finally {
                try {
                    dos.close();
                }
                catch (IOException ioe) {}
            }
        }
        return false;
    }
}

