/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.fm.storade.device.storage.treefrog.collector;

import com.sun.netstorage.fm.storade.device.storage.treefrog.TreefrogReport;
import com.sun.netstorage.fm.storade.device.storage.treefrog.collector.Util;
import com.sun.netstorage.fm.storade.device.storage.treefrog.common.Translator;
import com.sun.netstorage.fm.storade.device.storage.treefrog.common.Utility;
import com.sun.netstorage.fm.storade.resource.report.ReportClass;
import devmgr.versioned.symbol.AbstractVolRef;
import devmgr.versioned.symbol.Battery;
import devmgr.versioned.symbol.Cluster;
import devmgr.versioned.symbol.ComponentBundle;
import devmgr.versioned.symbol.Controller;
import devmgr.versioned.symbol.ControllerRef;
import devmgr.versioned.symbol.ControllerSFP;
import devmgr.versioned.symbol.ControllerTime;
import devmgr.versioned.symbol.Drive;
import devmgr.versioned.symbol.DriveRef;
import devmgr.versioned.symbol.DriveTypeData;
import devmgr.versioned.symbol.Esm;
import devmgr.versioned.symbol.EthernetInterface;
import devmgr.versioned.symbol.Fan;
import devmgr.versioned.symbol.FibreDriveAddress;
import devmgr.versioned.symbol.FibreInterface;
import devmgr.versioned.symbol.Host;
import devmgr.versioned.symbol.HostPort;
import devmgr.versioned.symbol.HotSpareCoverage;
import devmgr.versioned.symbol.HotSpareCoverageList;
import devmgr.versioned.symbol.IOInterfaceTypeData;
import devmgr.versioned.symbol.LUNMapping;
import devmgr.versioned.symbol.Location;
import devmgr.versioned.symbol.NetInterfaceTypeData;
import devmgr.versioned.symbol.ObjectBundle;
import devmgr.versioned.symbol.PowerSupply;
import devmgr.versioned.symbol.PremiumFeature;
import devmgr.versioned.symbol.ProcedureTimeout;
import devmgr.versioned.symbol.SAData;
import devmgr.versioned.symbol.SFPParentTypeData;
import devmgr.versioned.symbol.SYMbolAPIClientV1;
import devmgr.versioned.symbol.SYMbolRef;
import devmgr.versioned.symbol.Sfp;
import devmgr.versioned.symbol.StagedFirmware;
import devmgr.versioned.symbol.StorageArray;
import devmgr.versioned.symbol.StoragePoolBundle;
import devmgr.versioned.symbol.ThermalSensor;
import devmgr.versioned.symbol.Tray;
import devmgr.versioned.symbol.TrayRef;
import devmgr.versioned.symbol.UserAssignedLabel;
import devmgr.versioned.symbol.Volume;
import devmgr.versioned.symbol.VolumeCache;
import devmgr.versioned.symbol.VolumeGroup;
import devmgr.versioned.symbol.VolumeGroupRef;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

public class ArrayProfile {
    private static final String NEWLINE = "\n";
    private static final String TAB = "\t";
    private static final String TAB2 = "\t\t";
    private static final String TAB3 = "\t\t\t";
    private static final String TBD = "<TBD>";
    private static final int KILOBYTE = 1024;
    private static final int MEGABYTE = 0x100000;
    private static final int GIGABYTE = 0x40000000;

    public static String getData(SYMbolAPIClientV1 client) {
        StringBuffer profile = new StringBuffer();
        try {
            client.setTimeout(new ProcedureTimeout().getProcTimeout(40));
            ObjectBundle bundle = client.getObjectGraph();
            HotSpareCoverageList spares = null;
            try {
                profile.append("PROFILE FOR STORAGE ARRAY: " + Utility.userLabelString(bundle.getSa().getSaData().getStorageArrayLabel()) + NEWLINE);
                client.setTimeout(new ProcedureTimeout().getProcTimeout(141));
                spares = client.getHotSpareCoverage();
            }
            catch (Exception sube) {
                // empty catch block
            }
            client.setTimeout(new ProcedureTimeout().getProcTimeout(117));
            ControllerTime ctime = client.getControllerTime();
            ArrayProfile.getArraySummaryData(bundle, spares, profile);
            ArrayProfile.getControllerData(bundle, ctime, profile);
            ArrayProfile.getVolumeGroupData(bundle, profile);
            ArrayProfile.getVolumeData(bundle, profile);
            ArrayProfile.getDriveData(bundle, profile);
            ArrayProfile.getHotSpareData(bundle, spares, profile);
            ArrayProfile.getTrayData(bundle, profile);
            ArrayProfile.getMappingData(bundle, profile, client);
        }
        catch (Exception e) {
            profile.append("Exception: " + e.toString());
        }
        return profile.toString();
    }

    private static void getArraySummaryData(ObjectBundle bundle, HotSpareCoverageList spares, StringBuffer buf) {
        buf.append(NEWLINE);
        buf.append("SUMMARY------------------------------\n");
        try {
            StorageArray stArray = bundle.getSa();
            SAData array = bundle.getSa().getSaData();
            byte[] firmware = array.getFwVersion();
            byte[] wwn = array.getSaId().getWorldWideName();
            boolean noBattery = stArray.getFeatureParameters().getBattery_not_in_configuration();
            String battery = !noBattery ? "Yes" : "No";
            Controller[] controllers = bundle.getController();
            Drive[] drives = bundle.getDrive();
            int hotSpares = 0;
            int installedDrives = 0;
            for (int x = 0; x < drives.length; ++x) {
                if (drives[x].getHotSpare()) {
                    ++hotSpares;
                }
                if (drives[x].getStatus().getValue() == 6) continue;
                ++installedDrives;
            }
            int sparesInUse = 0;
            int standbySpares = hotSpares;
            if (spares != null) {
                HotSpareCoverage[] coverage = spares.getHotSpareCoverage();
                for (int i = 0; i < coverage.length; ++i) {
                    if (!coverage[i].getInUse()) continue;
                    ++sparesInUse;
                    --standbySpares;
                }
            }
            VolumeGroup[] volumeGroups = bundle.getVolumeGroup();
            Volume[] volumes = bundle.getVolume();
            buf.append("\tNumber of controllers: " + controllers.length + NEWLINE);
            buf.append("\tNumber of volume groups: " + volumeGroups.length + NEWLINE);
            buf.append("\tTotal number of volumes " + volumes.length + NEWLINE);
            buf.append("\t   Number of standard volumes: " + volumes.length + NEWLINE);
            buf.append("\tNumber of installed drives: " + installedDrives + NEWLINE);
            buf.append("\tTotal hot spare drives: " + hotSpares + NEWLINE);
            buf.append("\t   Standby: " + standbySpares + NEWLINE);
            buf.append("\t   In use: " + sparesInUse + NEWLINE);
            buf.append("\tCurrent configuration\n");
            buf.append("\t   Firmware version: " + Utility.bytesToDecimalString(firmware) + NEWLINE);
            buf.append("\t   NVSRAM version: " + array.getNvsramVersion() + NEWLINE);
            StagedFirmware staged = stArray.getStagedFirmware();
            buf.append("\tPending configuration\n");
            buf.append("\t\tStaged firmware download supported?: " + staged.getStagedFwValid() + NEWLINE);
            buf.append("\t\tNote, the preceeding value is straight from the bundle,\n");
            buf.append("\t\tbut I believe that it is inverted there for some reason.\n");
            String fw = "None";
            String nv = "None";
            String dt = "None";
            if (staged.getTimeStamp() > 0L) {
                fw = Utility.bytesToString(staged.getFwVersion());
                nv = Utility.bytesToString(staged.getNvsramVersion());
                dt = Utility.convertDate(staged.getTimeStamp());
            }
            buf.append("\t\tFirmware version: " + fw + NEWLINE);
            buf.append("\t\tNVSRAM version: " + nv + NEWLINE);
            buf.append("\t\tTranferred on: " + dt + NEWLINE);
            buf.append("\tNVSRAM configured for batteries: " + battery + NEWLINE);
            buf.append("\tCache block size (in KB): " + stArray.getCache().getCacheBlkSize() / 1024 + NEWLINE);
            buf.append("\tMedia scan frequency (in days): " + stArray.getMediaScanPeriod() + NEWLINE);
            buf.append("\tStorage array pseudo worldwide name (ID): " + Utility.wwnString(wwn) + NEWLINE);
            buf.append("\tFeature enable identifier: " + Utility.bytesArrayString(stArray.getSafeId().getWorldWideName()) + NEWLINE);
            PremiumFeature[] features = stArray.getPremiumFeatures();
            for (int i = 0; i < features.length; ++i) {
                PremiumFeature feature = features[i];
                if (!feature.getIsEnabled()) continue;
                buf.append(TAB2 + Translator.translateCapability(feature.getCapability()));
                buf.append("\tEnabled " + feature.getIsEnabled());
                buf.append("\tCompliant " + feature.getIsCompliant());
                buf.append("\tWithinLimits " + feature.getIsWithinLimits() + NEWLINE);
            }
            buf.append(NEWLINE);
        }
        catch (Exception e) {
            buf.append("Problem with StorageArray data.");
        }
    }

    private static void getControllerData(ObjectBundle bundle, ControllerTime ctime, StringBuffer buf) {
        buf.append("Controllers------------------------------\n");
        try {
            Controller[] controllers = bundle.getController();
            String nvsram = bundle.getSa().getSaData().getNvsramVersion();
            buf.append("Number of controllers: " + controllers.length + NEWLINE + NEWLINE);
            for (int x = 0; x < controllers.length; ++x) {
                Controller controller = controllers[x];
                buf.append(TAB + Util.createName(bundle, controller.getControllerRef()) + NEWLINE);
                buf.append("\t   Status: " + Translator.translateControllerStatus(controller.getStatus().getValue()) + NEWLINE);
                buf.append("\t   Current configuration\n");
                buf.append("\t      Firmware version: \n");
                buf.append("\t         Appware version: " + controller.getAppVersion() + NEWLINE);
                buf.append("\t         Bootware version: " + controller.getBootVersion() + NEWLINE);
                buf.append("\t      NVSRAM version: " + nvsram + NEWLINE);
                buf.append("\t   Board ID: " + controller.getBoardID() + NEWLINE);
                buf.append("\t   Product ID: " + controller.getProductID() + NEWLINE);
                buf.append("\t   Product revision: " + controller.getProductRevLevel() + NEWLINE);
                buf.append("\t   Serial number: " + controller.getSerialNumber() + NEWLINE);
                buf.append("\t   Date of manufacture: " + Utility.convertDate(controller.getManufacturerDate()) + NEWLINE);
                buf.append("\t   Cache/processor size (MB): " + controller.getCacheMemorySize() + "/" + controller.getProcessorMemorySize() + NEWLINE);
                if (x == 0) {
                    buf.append("\t   Date/Time: " + Utility.convertDate(ctime.getControllerATime()) + NEWLINE);
                } else {
                    buf.append("\t   Date/Time: " + Utility.convertDate(ctime.getControllerBTime()) + NEWLINE);
                }
                buf.append("\t   Associated Volumes (* = Preferred Owner):\n");
                buf.append(ArrayProfile.getAssociatedVolumes(bundle, controller.getControllerRef(), TAB3) + NEWLINE);
                NetInterfaceTypeData[] net = controller.getNetInterfaces();
                for (int i = 0; i < net.length; ++i) {
                    EthernetInterface enet = net[i].getEthernet();
                    int gwip = enet.getGatewayIp();
                    int ip = enet.getIp();
                    buf.append("\t   Ethernet port: " + (x + 1) + NEWLINE);
                    buf.append("\t      MAC address: " + Utility.bytesToString(enet.getMacAddr()) + NEWLINE);
                    buf.append("\t      IP address: " + Utility.convertIpAddr(ip) + NEWLINE);
                    buf.append("\t      Subnet mask: " + Utility.convertIpAddr(enet.getSubnetMask()) + NEWLINE);
                    buf.append("\t      Gateway: " + Utility.convertIpAddr(gwip) + NEWLINE);
                    buf.append("\t      Remote login: " + enet.getRloginEnabled() + NEWLINE);
                }
                buf.append(NEWLINE);
                IOInterfaceTypeData[] driveIFData = controller.getDriveInterfaces();
                for (int i = 0; i < driveIFData.length; ++i) {
                    int type = driveIFData[i].getInterfaceType().getValue();
                    if (type != 2) continue;
                    FibreInterface fc = driveIFData[i].getFibre();
                    buf.append("\t   Drive interface: Fibre\n");
                    buf.append("\t      Channel: " + fc.getChannel() + NEWLINE);
                    buf.append("\t      Maximum data rate: " + fc.getMaxSpeed() + " MB/s" + NEWLINE);
                    buf.append("\t      Current data rate: " + fc.getSpeed() + " MB/s" + NEWLINE);
                    int temp = fc.getLinkStatus().getValue();
                    buf.append("\t      Link status: " + Translator.translateLinkStatus(temp) + NEWLINE);
                }
                IOInterfaceTypeData[] hostIfData = controller.getHostInterfaces();
                for (int i = 0; i < hostIfData.length; ++i) {
                    int type = hostIfData[i].getInterfaceType().getValue();
                    if (type != 2) continue;
                    FibreInterface fc = hostIfData[i].getFibre();
                    buf.append("\t   Host interface: Fibre\n");
                    buf.append("\t      Port: " + Utility.bytesArrayString(fc.getPortId()) + NEWLINE);
                    buf.append("\t      NL-Port ID: " + fc.getLoopID() + NEWLINE);
                    buf.append("\t      Maximum data rate: " + fc.getMaxSpeed() + NEWLINE);
                    buf.append("\t      Current data rate: " + fc.getSpeed() + NEWLINE);
                    int temp = fc.getLinkStatus().getValue();
                    buf.append("\t      Link status: " + Translator.translateLinkStatus(temp) + NEWLINE);
                    buf.append("\t      Topology: " + Translator.translateTopologyType(fc.getTopology().getValue()) + NEWLINE);
                    buf.append("\t      World-wide port name: " + Utility.wwnString(fc.getPortName()) + NEWLINE);
                    buf.append("\t      World-wide node name: " + Utility.wwnString(fc.getNodeName()) + NEWLINE);
                    buf.append("\t      Part type: " + fc.getPart() + NEWLINE);
                }
                buf.append(NEWLINE);
            }
        }
        catch (Exception e) {
            buf.append("Error getting controller data\n");
            buf.append(e.toString() + NEWLINE);
            StackTraceElement[] ste = e.getStackTrace();
            for (int z = 0; z < ste.length; ++z) {
                buf.append(ste[z].toString() + NEWLINE);
            }
        }
    }

    private static String getAssociatedVolumes(ObjectBundle bundle, ControllerRef cref, String indent) {
        StringBuffer assocVols = new StringBuffer();
        byte[] target = cref.getRefToken();
        try {
            Volume[] volumes = bundle.getVolume();
            for (int x = 0; x < volumes.length; ++x) {
                Volume volume = volumes[x];
                byte[] cman = volume.getCurrentManager().getRefToken();
                byte[] pman = volume.getPreferredManager().getRefToken();
                if (!Utility.rawCompare(target, cman)) continue;
                String label = Utility.userLabelString(volume.getLabel());
                assocVols.append(indent + label);
                if (Utility.rawCompare(target, pman)) {
                    assocVols.append("*");
                }
                assocVols.append(NEWLINE);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return assocVols.toString();
    }

    private static String getAssociatedVolumes(ObjectBundle bundle, VolumeGroupRef vgref, String indent) {
        StringBuffer assocVols = new StringBuffer();
        byte[] target = vgref.getRefToken();
        try {
            Volume[] volumes = bundle.getVolume();
            for (int x = 0; x < volumes.length; ++x) {
                Volume volume = volumes[x];
                byte[] parent = volume.getVolumeGroupRef().getRefToken();
                if (!Utility.rawCompare(target, parent)) continue;
                String label = Utility.userLabelString(volume.getLabel());
                String capacity = "" + volume.getCapacity() / 0x40000000L;
                assocVols.append(indent + label + " (" + capacity + " GB)");
                assocVols.append(NEWLINE);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return assocVols.toString();
    }

    private static String getAssociatedDrives(ObjectBundle bundle, VolumeGroupRef vgref, String indent) {
        StringBuffer assocDrives = new StringBuffer();
        byte[] target = vgref.getRefToken();
        try {
            Drive[] drives = bundle.getDrive();
            for (int x = 0; x < drives.length; ++x) {
                Drive drive = drives[x];
                try {
                    byte[] parent = drive.getCurrentVolumeGroupRef().getRefToken();
                    if (!Utility.rawCompare(target, parent)) continue;
                    String name = Util.createName(bundle, drive.getDriveRef());
                    assocDrives.append(indent + name);
                    assocDrives.append(NEWLINE);
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return assocDrives.toString();
    }

    private static void getVolumeGroupData(ObjectBundle bundle, StringBuffer buf) {
        buf.append("\nVirtual Disks (Volume Groups) --------------\n");
        try {
            VolumeGroup[] volumeGroups = bundle.getVolumeGroup();
            buf.append("Number of volume groups: " + volumeGroups.length + NEWLINE);
            buf.append(NEWLINE);
            for (int v = 0; v < volumeGroups.length; ++v) {
                VolumeGroup volumeGroup = volumeGroups[v];
                buf.append("\tVolumeGroup " + volumeGroup.getSequenceNum() + NEWLINE);
                buf.append("\t\tRaid Level: " + Translator.translateRaidLevel(volumeGroup.getRaidLevel().getValue()) + NEWLINE);
                buf.append("\t\tOnline: " + !volumeGroup.getOffline() + NEWLINE);
                buf.append("\t\tTray loss protection: " + volumeGroup.getTrayLossProtection() + NEWLINE);
                buf.append("\t\tAssociated volumes and free capacities:\n");
                buf.append(ArrayProfile.getAssociatedVolumes(bundle, volumeGroup.getVolumeGroupRef(), TAB3));
                buf.append("\t\tAssociated drives\n");
                buf.append(ArrayProfile.getAssociatedDrives(bundle, volumeGroup.getVolumeGroupRef(), TAB3));
            }
        }
        catch (Exception e) {
            buf.append("Error accessing volume group data");
        }
    }

    private static void getVolumeData(ObjectBundle bundle, StringBuffer buf) {
        try {
            Volume volume;
            int v;
            buf.append(NEWLINE);
            buf.append("STANDARD VOLUMES------------------------------\n");
            buf.append(NEWLINE);
            Volume[] volumes = bundle.getVolume();
            buf.append("SUMMARY\n");
            buf.append("\tNumber of standard volumes: " + volumes.length + NEWLINE);
            buf.append(NEWLINE);
            buf.append("\tNAME\t\tSTATUS\tCAPACITY\tRAID LEVEL\tVDISK(VOLUME GROUP)\n");
            for (v = 0; v < volumes.length; ++v) {
                volume = volumes[v];
                buf.append(TAB);
                buf.append(Utility.userLabelString(volume.getLabel()) + TAB);
                buf.append(Translator.translateVolumeStatus(volume.getStatus().getValue()) + TAB);
                buf.append(volume.getCapacity() / 0x40000000L + " GB" + TAB2);
                buf.append(Translator.translateRaidLevel(volume.getRaidLevel()) + TAB2);
                buf.append(ArrayProfile.getVolumeGroupID(bundle, volume.getVolumeGroupRef()));
                buf.append(NEWLINE);
            }
            buf.append(NEWLINE);
            buf.append("DETAILS\n");
            for (v = 0; v < volumes.length; ++v) {
                volume = volumes[v];
                VolumeCache cache = volume.getCache();
                buf.append("\tVolume name: " + Utility.userLabelString(volume.getLabel()) + NEWLINE);
                buf.append("\t\tVolume handle: " + volume.getVolumeHandle() + NEWLINE);
                buf.append("\t\tVolume WWN: " + Utility.wwnString(volume.getWorldWideName()) + NEWLINE);
                buf.append("\t\tStatus: " + Translator.translateVolumeStatus(volume.getStatus().getValue()) + NEWLINE);
                buf.append("\t\tPreferred owner: " + TreefrogReport.findControllerName(bundle, volume.getPreferredManager()) + NEWLINE);
                buf.append("\t\tCurrent owner: " + TreefrogReport.findControllerName(bundle, volume.getCurrentManager()) + NEWLINE);
                buf.append("\t\tCapacity: " + volume.getCapacity() / 0x40000000L + " GB" + NEWLINE);
                buf.append("\t\tRaid level: " + Translator.translateRaidLevel(volume.getRaidLevel()) + NEWLINE);
                buf.append("\t\tSegment size: " + volume.getSegmentSize() / 1024 + " KB" + NEWLINE);
                buf.append("\t\tReconstruction priority: " + volume.getReconPriority() + NEWLINE);
                buf.append("\t\tAssociated volume group: " + ArrayProfile.getVolumeGroupID(bundle, volume.getVolumeGroupRef()) + NEWLINE);
                buf.append("\t\tRead cache enabled: " + cache.getReadCacheEnable() + NEWLINE);
                buf.append("\t\tRead cache active: " + cache.getReadCacheActive() + NEWLINE);
                buf.append("\t\tWrite cache enabled: " + cache.getWriteCacheEnable() + NEWLINE);
                buf.append("\t\tWrite cache active: " + cache.getWriteCacheActive() + NEWLINE);
                buf.append("\t\tWrite cache without batteries: " + cache.getCwob() + NEWLINE);
                buf.append("\t\tWrite cache with mirroring enabled: " + cache.getMirrorEnable() + NEWLINE);
                buf.append("\t\tWrite cache with mirroring active: " + cache.getMirrorActive() + NEWLINE);
                buf.append("\t\tFlush write cache after (in seconds): " + Translator.translateCacheFlushModifier(cache.getCacheFlushModifier()) + NEWLINE);
                buf.append("\t\tCache read ahead multiplier: " + cache.getReadAheadMultiplier() + NEWLINE);
                buf.append("\t\tMedia scan enabled: " + volume.getMediaScan().getEnable() + NEWLINE);
                buf.append("\t\tMedia scan with parity check: " + volume.getMediaScan().getParityValidationEnable() + NEWLINE);
                buf.append(NEWLINE);
            }
        }
        catch (Exception e) {
            buf.append("Error accessing volume data");
        }
    }

    private static String getVolumeGroupID(ObjectBundle bundle, VolumeGroupRef ref) {
        String id = "Unknown";
        try {
            VolumeGroup[] groups = bundle.getVolumeGroup();
            byte[] targetVG = ref.getRefToken();
            for (int x = 0; x < groups.length; ++x) {
                byte[] currentVG = groups[x].getVolumeGroupRef().getRefToken();
                if (!Utility.rawCompare(targetVG, currentVG)) continue;
                id = "VolumeGroup." + groups[x].getSequenceNum();
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return id;
    }

    private static void getDriveData(ObjectBundle bundle, StringBuffer buf) {
        try {
            Drive drive;
            int d;
            buf.append("\nDRIVES-----------------------\n\n");
            buf.append("\tTRAY, SLOT\tSTATUS\tCAPACITY\tCURRENT DATA RATE\tPRODUCT ID\tFIRMWARE VERSION\n");
            Drive[] drives = bundle.getDrive();
            drives = Util.sortDriveArray(drives, bundle, buf);
            for (d = 0; d < drives.length; ++d) {
                drive = drives[d];
                Location loc = drive.getPhysicalLocation();
                Tray tray = Utility.findTray(bundle, loc.getTrayRef());
                int trayid = tray.getTrayId();
                int slot = loc.getSlot();
                String status = Translator.translateDriveStatus(drive.getStatus().getValue());
                String capacity = drive.getRawCapacity() / 0x40000000L + " GB";
                String rate = Translator.translateSpeed(drive.getCurrentSpeed());
                String productID = drive.getProductID();
                String firmware = drive.getSoftwareVersion();
                int prefChan = -1;
                int redChan = -1;
                buf.append(TAB + trayid + ", " + slot + TAB + status + TAB + capacity + TAB + rate + TAB + productID + TAB + firmware + NEWLINE);
            }
            buf.append("\n\n");
            buf.append("DRIVE CHANNELS:\n\n");
            buf.append("\tDRIVE            PREFERRED CHANNEL  REDUNDANT CHANNEL\n");
            for (d = 0; d < drives.length; ++d) {
                drive = drives[d];
                buf.append(TAB + Util.createName(bundle, drive.getDriveRef()));
                DriveTypeData dtd = drive.getInterfaceType();
                if (dtd.getDriveType().getValue() == 2) {
                    FibreDriveAddress[] addr = dtd.getFibre();
                    for (int x = 0; x < addr.length; ++x) {
                        if (x > 0) {
                            buf.append(TAB);
                        }
                        buf.append(TAB2 + addr[x].getChannel());
                    }
                }
                buf.append(NEWLINE);
            }
            buf.append("\n\n");
            for (d = 0; d < drives.length; ++d) {
                drive = drives[d];
                if (drive.getStatus().getValue() == 6) {
                    buf.append(TAB + Util.createName(bundle, drive.getDriveRef()) + NEWLINE);
                    buf.append("\t\tStatus: Removed\n");
                    buf.append(NEWLINE);
                    continue;
                }
                String red = "OK";
                if (drive.getNonRedundantAccess()) {
                    red = "Error";
                }
                buf.append(TAB + Util.createName(bundle, drive.getDriveRef()) + NEWLINE);
                DriveTypeData dtd = drive.getInterfaceType();
                if (dtd.getDriveType().getValue() == 2) {
                    FibreDriveAddress[] addr = dtd.getFibre();
                    for (int x = 0; x < addr.length; ++x) {
                        buf.append("\t\tDrive port: " + (x + 1) + ", Channel: " + addr[x].getChannel() + ", ID: " + addr[x].getLoopID() + NEWLINE);
                    }
                }
                buf.append("\t\tDrive path redundancy: " + red + NEWLINE);
                buf.append("\t\tStatus: " + Translator.translateDriveStatus(drive.getStatus().getValue()) + NEWLINE);
                buf.append("\t\tRaw capacity: " + drive.getRawCapacity() / 0x100000L + " MB" + NEWLINE);
                buf.append("\t\tUsable capacity: " + drive.getUsableCapacity() / 0x100000L + " MB" + NEWLINE);
                buf.append("\t\tCurrent data rate: " + Translator.translateSpeed(drive.getCurrentSpeed()) + NEWLINE);
                buf.append("\t\tProduct ID: " + drive.getProductID() + NEWLINE);
                buf.append("\t\tFirmware version: " + drive.getSoftwareVersion() + NEWLINE);
                buf.append("\t\tSerial number: " + drive.getSerialNumber() + NEWLINE);
                buf.append("\t\tVendor: " + drive.getManufacturer() + NEWLINE);
                buf.append("\t\tDate of manufacture: " + Utility.convertDate(drive.getManufacturerDate()) + NEWLINE);
                buf.append("\t\tWorld-wide name: " + Utility.wwnString(drive.getWorldWideName()) + NEWLINE);
                buf.append("\t\tDrive type: " + Translator.translatePhysicalDriveType(drive.getPhyDriveType()) + NEWLINE);
                buf.append("\t\tSpeed: " + drive.getSpindleSpeed() + " RPM\n");
                String mode = "Unassigned";
                String vgroup = "None";
                if (drive.getVolumeGroupIndex() >= 0) {
                    mode = "Assigned";
                    vgroup = ArrayProfile.getVolumeGroupID(bundle, drive.getCurrentVolumeGroupRef());
                }
                buf.append("\t\tMode: " + mode + NEWLINE);
                buf.append("\t\tAssociated volume group: " + vgroup + NEWLINE);
                buf.append(NEWLINE);
            }
        }
        catch (Exception e) {
            buf.append("Error accessing Drive data\n");
            buf.append(e.toString() + NEWLINE);
            StackTraceElement[] ste = e.getStackTrace();
            for (int z = 0; z < ste.length; ++z) {
                buf.append(ste[z].toString() + NEWLINE);
            }
        }
    }

    private static void getHotSpareData(ObjectBundle bundle, HotSpareCoverageList spares, StringBuffer buf) {
        try {
            int i;
            int totalSpares = 0;
            int sparesInUse = 0;
            int standbySpares = 0;
            HotSpareCoverage[] coverage = null;
            if (spares != null) {
                coverage = spares.getHotSpareCoverage();
                totalSpares = coverage.length;
                for (i = 0; i < coverage.length; ++i) {
                    if (!coverage[i].getInUse()) continue;
                    ++sparesInUse;
                }
                standbySpares = totalSpares - sparesInUse;
            }
            buf.append("HOT SPARE COVERAGE:\n\n");
            buf.append("\tTotal hot spare drives: " + totalSpares + NEWLINE);
            buf.append("\t\tStandby: " + standbySpares + NEWLINE);
            buf.append("\t\tIn use: " + sparesInUse + NEWLINE + NEWLINE);
            if (coverage != null) {
                for (i = 0; i < coverage.length; ++i) {
                    HotSpareCoverage spare = coverage[i];
                    DriveRef dref = spare.getDriveRef();
                    String driveName = Util.createName(bundle, dref);
                    buf.append("\tStandby drive " + driveName + NEWLINE);
                    buf.append("\t\tProtects the following volume groups: ");
                    VolumeGroupRef[] vgreflinst = spare.getVolumeGroupRefList().getVolumeGroupRef();
                    for (int y = 0; y < vgreflinst.length; ++y) {
                        buf.append(ArrayProfile.getVolumeGroupID(bundle, vgreflinst[y]) + ", ");
                    }
                    buf.append(NEWLINE);
                }
            }
            buf.append(NEWLINE);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void getTrayData(ObjectBundle bundle, StringBuffer buf) {
        try {
            buf.append("TRAYS------------------------------\n");
            Tray[] trays = bundle.getTray();
            for (int x = 0; x < trays.length; ++x) {
                Tray tray = trays[x];
                buf.append(NEWLINE);
                buf.append("\tOverall Component Information for Drive/Controller tray " + tray.getTrayId() + NEWLINE);
                buf.append("\t\tSpeed Mismatch: " + tray.getDrvMHSpeedMismatch() + NEWLINE);
                buf.append("\t\tIOM Miswire: " + tray.getEsmMiswire() + NEWLINE);
                buf.append("\t\tIOM Mismatch: " + tray.getEsmVersionMismatch() + NEWLINE);
                buf.append("\t\tPart Number: " + tray.getPartNumber() + NEWLINE);
                buf.append("\t\tSerial Number: " + tray.getSerialNumber() + NEWLINE);
                buf.append("\t\tVendor: " + tray.getVendorName() + NEWLINE);
                buf.append("\t\tDate of manufacture: " + Utility.convertDate(tray.getManufacturerDate()) + NEWLINE);
                buf.append("\t\tTray path redundant: " + !tray.getNonRedundantAccess() + NEWLINE);
                TrayRef trayRef = tray.getTrayRef();
                ArrayProfile.getTrayComponentData(bundle, buf, trayRef);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void getTrayComponentData(ObjectBundle bundle, StringBuffer buf, TrayRef trayRef) {
        try {
            ArrayProfile.getFanData(bundle, buf, trayRef);
            ArrayProfile.getBatteryData(bundle, buf, trayRef);
            ArrayProfile.getPowerSupplyData(bundle, buf, trayRef);
            ArrayProfile.getThermalSensorData(bundle, buf, trayRef);
            ArrayProfile.getEsmData(bundle, buf, trayRef);
            ArrayProfile.getSfpData(bundle, buf, trayRef);
        }
        catch (Exception e) {
            buf.append("Error accessing tray component data");
        }
    }

    private static void getFanData(ObjectBundle obundle, StringBuffer buf, TrayRef trayRef) {
        ComponentBundle cbundle = obundle.getComponentBundle();
        try {
            Fan[] fans = cbundle.getFan();
            for (int x = 0; x < fans.length; ++x) {
                Fan fan = fans[x];
                Location location = fan.getPhysicalLocation();
                if (!ArrayProfile.compareTrayRefs(trayRef, location.getTrayRef())) continue;
                Tray tray = Utility.findTray(obundle, location.getTrayRef());
                String id = "Tray." + tray.getTrayId() + ".Fan." + location.getSlot();
                buf.append("\t\tFan " + id + NEWLINE);
                buf.append("\t\t\tStatus: " + Translator.translateFanStatus(fan.getStatus().getValue()));
                buf.append(NEWLINE);
            }
        }
        catch (Exception e) {
            buf.append("Error accessing fan data\n");
        }
    }

    private static void getBatteryData(ObjectBundle obundle, StringBuffer buf, TrayRef trayRef) {
        ComponentBundle cbundle = obundle.getComponentBundle();
        try {
            Battery[] batteries = cbundle.getBattery();
            for (int x = 0; x < batteries.length; ++x) {
                Battery battery = batteries[x];
                Location location = battery.getPhysicalLocation();
                if (!ArrayProfile.compareTrayRefs(trayRef, location.getTrayRef())) continue;
                ControllerRef cref = battery.getBatteryTypeData().getParentController();
                String parentName = TreefrogReport.findControllerName(obundle, battery.getBatteryTypeData().getParentController());
                String locationName = parentName + ".Battery";
                buf.append("\t\tBattery: " + locationName + NEWLINE);
                buf.append("\t\t\tStatus: " + Translator.translateBatteryStatus(battery.getStatus()) + NEWLINE);
                buf.append("\t\t\tAge in days: " + battery.getBatteryAge() + NEWLINE);
                buf.append("\t\t\tDays until replacement: " + battery.getBatteryLifeRemaining() + NEWLINE);
            }
        }
        catch (Exception e) {
            buf.append("Error accessing battery data\n");
        }
    }

    private static void getEsmData(ObjectBundle obundle, StringBuffer buf, TrayRef trayRef) {
        ComponentBundle cbundle = obundle.getComponentBundle();
        try {
            Esm[] esms = cbundle.getEsm();
            for (int x = 0; x < esms.length; ++x) {
                Esm esm = esms[x];
                Location location = esm.getPhysicalLocation();
                if (!ArrayProfile.compareTrayRefs(trayRef, location.getTrayRef())) continue;
                Tray tray = Utility.findTray(obundle, location.getTrayRef());
                String locationName = "Tray." + tray.getTrayId() + ".IOM" + location.getSlot();
                int currSpeed = esm.getCurrentSpeed().getValue();
                int maxSpeed = esm.getMaxSpeed().getValue();
                buf.append("\t\tIOM (ESM) card " + locationName + NEWLINE);
                buf.append("\t\t\tStatus: " + locationName + NEWLINE);
                buf.append("\t\t\tFirmware version: " + esm.getSoftwareVersion() + NEWLINE);
                buf.append("\t\t\tMaximum data rate: " + Translator.translateSpeed(maxSpeed) + NEWLINE);
                buf.append("\t\t\tCurrent data rate: " + Translator.translateSpeed(currSpeed) + NEWLINE);
                buf.append("\t\t\tProduct ID: " + esm.getProductID() + NEWLINE);
                buf.append("\t\t\tPart Number: " + esm.getPartNumber() + NEWLINE);
                buf.append("\t\t\tSerial Number: " + esm.getSerialNumber() + NEWLINE);
                buf.append("\t\t\tVendor: " + esm.getManufacturer() + NEWLINE);
                buf.append("\t\t\tDate of manufacture: " + Utility.convertDate(esm.getManufacturerDate()) + NEWLINE);
            }
        }
        catch (Exception e) {
            buf.append("Error accessing IOM data\n");
        }
    }

    private static void getPowerSupplyData(ObjectBundle obundle, StringBuffer buf, TrayRef trayRef) {
        ComponentBundle cbundle = obundle.getComponentBundle();
        try {
            PowerSupply[] powerSupplies = cbundle.getPowerSupply();
            for (int x = 0; x < powerSupplies.length; ++x) {
                PowerSupply powerSupply = powerSupplies[x];
                Location location = powerSupply.getPhysicalLocation();
                if (!ArrayProfile.compareTrayRefs(trayRef, location.getTrayRef())) continue;
                Tray tray = Utility.findTray(obundle, location.getTrayRef());
                buf.append("\t\tPower supply Tray." + tray.getTrayId() + ".PowerSupply" + location.getSlot() + NEWLINE);
                buf.append("\t\t\tStatus: " + Translator.translatePowerSupplyStatus(powerSupply.getStatus().getValue()) + NEWLINE);
                buf.append("\t\t\tPart Number: " + powerSupply.getPartNumber() + NEWLINE);
                buf.append("\t\t\tSerial Number: " + powerSupply.getSerialNumber() + NEWLINE);
                buf.append("\t\t\tVendor: " + powerSupply.getVendorName() + NEWLINE);
                buf.append("\t\t\tDate of manufacture: " + Utility.convertDate(powerSupply.getManufacturerDate()) + NEWLINE);
            }
        }
        catch (Exception e) {
            buf.append("Error accessing power supply data\n");
        }
    }

    private static void getThermalSensorData(ObjectBundle obundle, StringBuffer buf, TrayRef trayRef) {
        ComponentBundle cbundle = obundle.getComponentBundle();
        try {
            ThermalSensor[] tempSensors = cbundle.getThermalSensor();
            for (int x = 0; x < tempSensors.length; ++x) {
                ThermalSensor tempSensor = tempSensors[x];
                Location location = tempSensor.getPhysicalLocation();
                if (!ArrayProfile.compareTrayRefs(trayRef, location.getTrayRef())) continue;
                buf.append("\t\tTemperature: " + Translator.translateTempStatus(tempSensor.getStatus().getValue()) + NEWLINE);
            }
        }
        catch (Exception e) {
            buf.append("Error accessing temperature data");
        }
    }

    private static void getSfpData(ObjectBundle obundle, StringBuffer buf, TrayRef trayRef) {
        ComponentBundle cbundle = obundle.getComponentBundle();
        try {
            Sfp[] sfps = cbundle.getSfp();
            for (int x = 0; x < sfps.length; ++x) {
                Sfp sfp = sfps[x];
                Location location = sfp.getPhysicalLocation();
                if (!ArrayProfile.compareTrayRefs(trayRef, location.getTrayRef())) continue;
                SFPParentTypeData parent = sfp.getParentData();
                int ptype = parent.getSfpParentType().getValue();
                String nameExtention = "";
                String parentName = "";
                if (ptype == 3) {
                    ControllerSFP controller = parent.getControllerSFP();
                    parentName = TreefrogReport.findControllerName(obundle, controller.getParentController());
                    int type = controller.getControllerSFPType().getValue();
                    if (type == 2) {
                        nameExtention = ".SFP.Expansion";
                    } else if (type == 1) {
                        nameExtention = ".SFP.Host" + controller.getChannel();
                    }
                } else if (ptype == 1) {
                    parentName = TreefrogReport.findEsmName(obundle, parent.getParentEsm());
                    nameExtention = ".SFP.Port" + sfp.getSfpPort().getValue();
                } else if (ptype == 2) {
                    parentName = "minihub";
                }
                String name = null;
                name = nameExtention == null ? TreefrogReport.findSfpName(parentName, sfp.getSfpRef()) : parentName + nameExtention;
                buf.append("\t\tSFP\n");
                buf.append("\t\t\tLocation: " + name + NEWLINE);
                buf.append("\t\t\tStatus: " + Translator.translateSfpStatus(sfp.getStatus().getValue()) + NEWLINE);
                buf.append("\t\t\tLink length: " + Translator.translateSfpLinkType(sfp.getSfpType().getSfpLinkLType()) + NEWLINE);
                buf.append("\t\t\tConnector: " + Translator.translateSfpConnectType(sfp.getSfpType().getSfpConnectType()) + NEWLINE);
                buf.append("\t\t\tTransmitter type: " + Translator.translateSfpXmitType(sfp.getSfpType().getSfpTransmitterType()) + NEWLINE);
                buf.append("\t\t\tTransmission media: " + Translator.translateSfpXmitMedia(sfp.getSfpType().getSfpTransmissionMedia()) + NEWLINE);
                buf.append("\t\t\tIEEE company ID: " + Utility.bytesArrayString(sfp.getSfpType().getVendorOUI()) + NEWLINE);
                buf.append("\t\t\tRevision: " + sfp.getSfpType().getVendorRev() + NEWLINE);
                buf.append("\t\t\tPart number: " + sfp.getSfpType().getVendorPN() + NEWLINE);
                buf.append("\t\t\tSerial number: " + sfp.getSfpType().getVendorSN() + NEWLINE);
                buf.append("\t\t\tVendor: " + sfp.getSfpType().getVendorName() + NEWLINE);
                buf.append("\t\t\tDate of manufacture: " + Utility.convertDate(sfp.getSfpType().getManufacturerDate()) + NEWLINE);
            }
        }
        catch (Exception e) {
            buf.append("Error accessing SFP data\n");
        }
    }

    private static void getMappingData(ObjectBundle bundle, StringBuffer buf, SYMbolAPIClientV1 client) {
        try {
            buf.append("\nMappings ------------------------------\n\n\n");
            StoragePoolBundle spb = bundle.getStoragePoolBundle();
            LUNMapping[] mappings = spb.getLunMapping();
            Cluster[] clusters = spb.getCluster();
            Host[] hosts = spb.getHost();
            HostPort[] hostPorts = spb.getHostPort();
            Volume[] volumes = bundle.getVolume();
            buf.append("\tVOLUME NAME\t\tLUN\tCONTROLLER\t\tACCESSIBLE BY\tVOLUME STATUS\n");
            for (int x = 0; x < mappings.length; ++x) {
                LUNMapping mapping = mappings[x];
                int lun = mapping.getLun();
                AbstractVolRef volRefObj = mapping.getVolumeRef();
                String volName = "No Match";
                String volStatus = "Unknown";
                String controller = "Unknown\t\t";
                for (int i = 0; i < volumes.length; ++i) {
                    byte[] vref = volumes[i].getVolumeRef().getRefToken();
                    if (!Utility.rawCompare(volRefObj.getRefToken(), vref)) continue;
                    volName = Utility.userLabelString(volumes[i].getLabel());
                    volStatus = Translator.translateVolumeStatus(volumes[i].getStatus().getValue());
                    controller = TreefrogReport.findControllerName(bundle, volumes[i].getCurrentManager());
                    break;
                }
                SYMbolRef ref = mapping.getMapRef();
                String accessBy = "Not Found";
                if (mapping.getType().getValue() == 3) {
                    for (int i = 0; i < hosts.length; ++i) {
                        if (!Utility.rawCompare(ref.getRefToken(), hosts[i].getHostRef().getRefToken())) continue;
                        accessBy = Utility.userLabelString(hosts[i].getLabel());
                        break;
                    }
                } else {
                    accessBy = mapping.getType().getValue() == 4 ? "Cluster" : (mapping.getType().getValue() == 8 ? "Default Group" : (mapping.getType().getValue() == 2 ? "HostPort" : (mapping.getType().getValue() == 7 ? "HostSAConnection" : (mapping.getType().getValue() == 1 ? "None" : (mapping.getType().getValue() == 5 ? "SAPort" : (mapping.getType().getValue() == 6 ? "SAPortGroup" : "Unknown"))))));
                }
                buf.append(TAB + volName + TAB2 + lun + TAB + controller + TAB + accessBy + TAB + volStatus + NEWLINE);
            }
            buf.append("\n\tTOPOLOGY DEFINITIONS\n\n");
            StorageArray sarray = bundle.getSa();
            UserAssignedLabel[] typeArray = sarray.getHostPortType();
            try {
                HostPort[] ulPorts = client.getUnlabeledHostPorts().getValue();
                buf.append("\t\tDEFAULT GROUP\n");
                if (ulPorts.length > 0) {
                    int type = ulPorts[0].getHostPortTypeIndex();
                    String typeString = Utility.userLabelString(typeArray[type]);
                    buf.append("\t\t\tDefault Type: " + typeString + NEWLINE);
                }
                for (int i = 0; i < ulPorts.length; ++i) {
                    buf.append("\t\t\tHost Port: " + Utility.wwnString(ulPorts[i].getHostPortName().getValue()) + NEWLINE);
                }
            }
            catch (Exception ulpe) {
                buf.append("\t\tException accessing Default Group info " + ulpe.toString() + NEWLINE);
            }
            for (int i = 0; i < clusters.length; ++i) {
                buf.append(NEWLINE);
                buf.append("\tHost Group: " + Utility.userLabelString(clusters[i].getLabel()) + NEWLINE);
                byte[] clusterRef = clusters[i].getClusterRef().getRefToken();
                for (int y = 0; y < hosts.length; ++y) {
                    byte[] hostClusterRef = hosts[y].getClusterRef().getRefToken();
                    if (!Utility.rawCompare(clusterRef, hostClusterRef)) continue;
                    buf.append("\t\tHost: " + Utility.userLabelString(hosts[y].getLabel()) + NEWLINE);
                    byte[] hostRef = hosts[y].getHostRef().getRefToken();
                    for (int z = 0; z < hostPorts.length; ++z) {
                        if (!Utility.rawCompare(hostRef, hostPorts[z].getHostRef().getRefToken())) continue;
                        String wwn = Utility.wwnString(hostPorts[z].getHostPortName().getValue());
                        String name = Utility.userLabelString(hostPorts[z].getLabel());
                        int type = hostPorts[z].getHostPortTypeIndex();
                        String typeString = Utility.userLabelString(typeArray[type]);
                        buf.append("\t\t\tHost Port WWN: " + wwn + NEWLINE);
                        buf.append("\t\t\t\tAlias: " + name + NEWLINE);
                        buf.append("\t\t\t\tType: " + typeString + NEWLINE);
                    }
                }
            }
            for (int y = 0; y < hosts.length; ++y) {
                byte[] hostClusterRef = hosts[y].getClusterRef().getRefToken();
                boolean match = false;
                for (int i = 0; i < clusters.length; ++i) {
                    if (!Utility.rawCompare(hostClusterRef, clusters[i].getClusterRef().getRefToken())) continue;
                    match = true;
                }
                if (match) continue;
                buf.append(NEWLINE);
                buf.append("\tHost: " + Utility.userLabelString(hosts[y].getLabel()) + NEWLINE);
                byte[] hostRef = hosts[y].getHostRef().getRefToken();
                for (int z = 0; z < hostPorts.length; ++z) {
                    if (!Utility.rawCompare(hostRef, hostPorts[z].getHostRef().getRefToken())) continue;
                    String wwn = Utility.wwnString(hostPorts[z].getHostPortName().getValue());
                    String name = Utility.userLabelString(hostPorts[z].getLabel());
                    int type = hostPorts[z].getHostPortTypeIndex();
                    String typeString = Utility.userLabelString(typeArray[type]);
                    buf.append("\t\tHost Port WWN: " + wwn + NEWLINE);
                    buf.append("\t\t\tAlias: " + name + NEWLINE);
                    buf.append("\t\t\tType: " + typeString + NEWLINE);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static boolean compareTrayRefs(TrayRef target, TrayRef current) {
        byte[] rawCurrent;
        boolean match = false;
        byte[] rawTarget = target.getRefToken();
        if (Utility.rawCompare(rawTarget, rawCurrent = current.getRefToken())) {
            match = true;
        }
        return match;
    }

    public static boolean storeData(ReportClass report, String path, String filename) {
        try {
            DataOutputStream stream = ArrayProfile.openFile(path, filename);
            report.toTab(stream);
            ArrayProfile.closeFile(stream);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    private static DataOutputStream openFile(String path, String filename) {
        DataOutputStream dos = null;
        try {
            File outfile = new File(path, filename);
            FileOutputStream fos = new FileOutputStream(outfile);
            dos = new DataOutputStream(fos);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return dos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean closeFile(DataOutputStream dos) {
        if (dos != null) {
            try {
                dos.flush();
            }
            catch (Exception e) {
            }
            finally {
                try {
                    dos.close();
                }
                catch (IOException ioe) {}
            }
        }
        return false;
    }
}

