/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.fm.storade.device.storage.treefrog;

import com.sun.netstorage.fm.storade.device.storage.treefrog.common.Utility;
import com.sun.netstorage.fm.storade.device.storage.treefrog.discovery.BroadCaster;
import com.sun.netstorage.fm.storade.resource.discovery.AbstractProbe;
import com.sun.netstorage.fm.storade.resource.discovery.ProbeResult;
import com.sun.netstorage.fm.storade.service.device.DeviceProperties;
import devmgr.versioned.symbol.AccessibleController;
import devmgr.versioned.symbol.Controller;
import devmgr.versioned.symbol.ControllerDescriptor;
import devmgr.versioned.symbol.ControllerRef;
import devmgr.versioned.symbol.DiscoveryResponse;
import devmgr.versioned.symbol.EthernetInterface;
import devmgr.versioned.symbol.FibreInterface;
import devmgr.versioned.symbol.IOInterfaceTypeData;
import devmgr.versioned.symbol.NetInterfaceTypeData;
import devmgr.versioned.symbol.ObjectBundle;
import devmgr.versioned.symbol.ReturnCode;
import devmgr.versioned.symbol.SAData;
import devmgr.versioned.symbol.SAIdentifier;
import devmgr.versioned.symbol.SYMbolAPIClientV1;
import devmgr.versioned.symbol.Tray;
import devmgr.versioned.symbol.UserAssignedLabel;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class TreefrogProbe
extends AbstractProbe {
    public static final String ARRAY_TYPE_6130 = "6130";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public ProbeResult probe(Properties inputProperties) {
        ProbeResult result;
        block16: {
            result = new ProbeResult();
            ArrayList<String> discoveredArrays = new ArrayList<String>();
            SYMbolAPIClientV1 symbolClient = null;
            String ip = inputProperties.getProperty("ip");
            if (ip == null) {
                ip = "localhost";
            }
            if (TreefrogProbe.serverExists(ip)) {
                InetAddress inet = InetAddress.getByName(ip);
                symbolClient = new SYMbolAPIClientV1(inet, 2463, true);
                DiscoveryResponse response = symbolClient.discoverControllers();
                boolean viaProxy = response.getResponseFromAgent();
                AccessibleController[] controllers = response.getControllers();
                int numControllers = controllers == null ? 0 : controllers.length;
                for (int x = 0; x < numControllers; ++x) {
                    String wwn;
                    ObjectBundle bundle;
                    ControllerRef cref = controllers[x].getThisController();
                    SAIdentifier said = controllers[x].getSaId();
                    ControllerDescriptor descriptor = new ControllerDescriptor();
                    descriptor.setControllerRef(cref);
                    descriptor.setSaId(said);
                    ReturnCode rc = symbolClient.bindToController(descriptor);
                    if (rc.getValue() != 1 || (bundle = symbolClient.getObjectGraph()) == null || discoveredArrays.contains(wwn = this.getWWN(bundle))) continue;
                    discoveredArrays.add(wwn);
                    String controllerIP = this.getControllerIP(bundle);
                    DeviceProperties p = new DeviceProperties();
                    if (viaProxy) {
                        p.setProperty("proxys", ip);
                    }
                    p.setProperty("type", ARRAY_TYPE_6130);
                    p.setProperty("class", "storage.6130");
                    p.setProperty("key", this.getKey(bundle));
                    p.setProperty("name", this.getName(bundle));
                    p.setProperty("wwn", wwn.toLowerCase());
                    p.setProperty("ipno", this.getIPNum(controllerIP));
                    p.setProperty("ip", this.getIPName(controllerIP));
                    String altIP = this.getAlternateIP(controllerIP, bundle);
                    p.setProperty("altipno", altIP);
                    p.setProperty("altip", this.getIPName(altIP));
                    p.setProperty("said", this.getSaid(bundle));
                    p.setProperty("wwns", this.getWWNList(bundle));
                    result.addDevice(p);
                }
                Object var22_22 = null;
                try {
                    if (symbolClient != null) {
                        symbolClient.close();
                    }
                    break block16;
                }
                catch (IOException ioe) {}
                break block16;
                {
                    catch (Exception e) {
                        Object var22_23 = null;
                        try {
                            if (symbolClient != null) {
                                symbolClient.close();
                            }
                            break block16;
                        }
                        catch (IOException ioe) {}
                    }
                }
                catch (Throwable throwable) {
                    Object var22_24 = null;
                    try {
                        if (symbolClient != null) {
                            symbolClient.close();
                        }
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }
        if (result.sizeOfDiscoveredDevices() == 0) {
            return new ProbeResult("#ARG_ERROR", "No CSM found at " + inputProperties.getProperty("ip"));
        }
        return result;
    }

    private static boolean serverExists(String ip) {
        boolean found = false;
        BroadCaster broadcast = new BroadCaster();
        Hashtable servers = broadcast.search(ip);
        if (servers.size() > 0) {
            Enumeration enumeration = servers.elements();
            while (enumeration.hasMoreElements()) {
                String address = (String)enumeration.nextElement();
            }
            found = true;
        }
        return found;
    }

    private String getIPName(String ip) {
        String ipName;
        try {
            InetAddress addr = InetAddress.getByName(ip);
            ipName = addr.getHostName();
        }
        catch (UnknownHostException uhe) {
            ipName = ip;
        }
        return ipName;
    }

    private String getIPNum(String ip) {
        String ipNum;
        try {
            InetAddress addr = InetAddress.getByName(ip);
            ipNum = addr.getHostAddress();
        }
        catch (UnknownHostException uhe) {
            ipNum = ip;
        }
        return ipNum;
    }

    private String getAlternateIP(String ip, ObjectBundle bundle) {
        String altIP = "";
        boolean found = false;
        try {
            InetAddress addr = InetAddress.getByName(ip);
            try {
                Controller[] controllers = bundle.getController();
                for (int x = 0; x < controllers.length; ++x) {
                    NetInterfaceTypeData[] net = controllers[x].getNetInterfaces();
                    for (int y = 0; y < net.length; ++y) {
                        EthernetInterface enet = net[y].getEthernet();
                        int ipValue = enet.getIp();
                        String tempIP = Utility.convertIpAddr(ipValue);
                        try {
                            InetAddress tempAddr = InetAddress.getByName(tempIP);
                            if (!addr.equals(tempAddr)) {
                                altIP = tempIP;
                                found = true;
                            }
                        }
                        catch (Exception e) {
                            System.out.println(tempIP + "is not a recognizable ip address");
                        }
                        if (found) break;
                    }
                    if (!found) {
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                System.out.println("Probe error getting alternat IP");
            }
        }
        catch (UnknownHostException uhe) {
            System.out.println("Probe error getting alternat IP");
        }
        return altIP;
    }

    private String getControllerIP(ObjectBundle bundle) {
        String ip = "";
        try {
            Controller[] controllers = bundle.getController();
            NetInterfaceTypeData[] net = controllers[0].getNetInterfaces();
            EthernetInterface enet = net[0].getEthernet();
            int targetip = enet.getIp();
            ip = Utility.convertIpAddr(targetip);
        }
        catch (Exception e) {
            System.out.println("Probe error getting controller ip");
        }
        return ip;
    }

    private String getWWN(ObjectBundle bundle) {
        String wwn = "";
        try {
            byte[] wwnValue = bundle.getSa().getRemoteAccessID();
            wwn = Utility.wwnString(wwnValue);
        }
        catch (Exception e) {
            System.out.println("Probe error getting wwn");
        }
        return wwn;
    }

    private String getWWNList(ObjectBundle bundle) {
        StringBuffer wwnList = new StringBuffer();
        try {
            Controller[] controllers = bundle.getController();
            for (int x = 0; x < controllers.length; ++x) {
                IOInterfaceTypeData[] ports = controllers[x].getHostInterfaces();
                for (int p = 0; p < ports.length; ++p) {
                    int type = ports[p].getInterfaceType().getValue();
                    if (type != 2) continue;
                    if (wwnList.length() > 0) {
                        wwnList.append(",");
                    }
                    FibreInterface fc = ports[p].getFibre();
                    String wwn = Utility.wwnString(fc.getPortName()).toLowerCase();
                    wwnList.append(wwn);
                }
            }
        }
        catch (Exception e) {
            System.out.println("Probe error getting wwn");
        }
        return wwnList.toString();
    }

    private String getSaid(ObjectBundle bundle) {
        String said = "";
        try {
            SAData array = bundle.getSa().getSaData();
            byte[] wwnValue = array.getSaId().getWorldWideName();
            said = Utility.wwnString(wwnValue);
        }
        catch (Exception e) {
            System.out.println("Probe error getting wwn");
        }
        return said;
    }

    private String getKey(ObjectBundle bundle) {
        String vendor = "SUN";
        String partNum = "";
        String serialNum = "";
        if (bundle != null) {
            int x;
            Tray[] trays = bundle.getTray();
            for (x = 0; x < trays.length && trays[x].getNumControllerSlots() <= 0; ++x) {
            }
            if (x >= trays.length) {
                x = 0;
            }
            partNum = this.stripHeader(trays[x].getPartNumber());
            serialNum = this.stripHeader(trays[x].getSerialNumber());
        }
        String key = vendor + "." + partNum + "." + serialNum;
        return key.trim();
    }

    private String stripHeader(String data) {
        String value = "";
        if (data != null) {
            int index = data.indexOf(" ");
            value = index > 0 ? data.substring(index + 1) : data;
        }
        return value.trim();
    }

    private String getName(String ip) {
        return this.getIPName(ip);
    }

    private String getName(ObjectBundle bundle) {
        String name = "unnamed";
        try {
            UserAssignedLabel label = bundle.getSa().getSaData().getStorageArrayLabel();
            name = Utility.userLabelString(label);
            if ("".equals(name) || "unlabeled".equals(name)) {
                name = "unnamed";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return name;
    }
}

