/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.fm.storade.device.storage.smis;

import com.sun.netstorage.fm.storade.resource.report.ReportClass;
import com.sun.netstorage.fm.storade.resource.report.ReportGenerator;
import com.sun.netstorage.fm.wbem.client.Report;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Properties;

public class SMISReport
implements ReportGenerator {
    public ReportClass generateReport(Properties p, String content) {
        try {
            String cimUser = p.getProperty("cimUser");
            String cimPass = p.getProperty("cimPass");
            String cimHost = p.getProperty("cimHost");
            String cimClass = p.getProperty("cimClass");
            String cimSystem = p.getProperty("name");
            String cimNameSpace = p.getProperty("cimNameSpace");
            Report re = new Report(cimHost, cimUser, cimPass);
            re.setNameSpace(cimNameSpace);
            re.setSystem(cimClass, cimSystem);
            return re.getSystemReport();
        }
        catch (Exception e) {
            ReportClass rc = new ReportClass("rc");
            rc.setProperty("error", e.toString());
            StringWriter sw = new StringWriter();
            PrintWriter out = new PrintWriter(sw);
            e.printStackTrace(out);
            rc.setProperty("trace", sw.toString());
            return rc;
        }
    }

    public static void main(String[] args) {
        if (args.length != 6) {
            System.out.println("Usage: <host> <user> <pass> <namespace> <class> <name>");
            System.exit(0);
        }
        Properties p = new Properties();
        p.setProperty("cimHost", args[0]);
        p.setProperty("cimUser", args[1]);
        p.setProperty("cimPass", args[2]);
        p.setProperty("cimNameSpace", args[3]);
        p.setProperty("cimClass", args[4]);
        p.setProperty("name", args[5]);
        SMISReport rg = new SMISReport();
        ReportClass rc = rg.generateReport(p, null);
        rc.toProperties(System.out);
    }
}

