/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.fm.storade.device.storage.minnow.io;

import com.sun.netstorage.fm.storade.agent.util.CommandExec;
import com.sun.netstorage.fm.storade.device.storage.minnow.io.ChannelTokenList;
import com.sun.netstorage.fm.storade.device.storage.minnow.io.ControllerToken;
import com.sun.netstorage.fm.storade.device.storage.minnow.io.DiskTokenList;
import com.sun.netstorage.fm.storade.device.storage.minnow.io.FruTokenList;
import com.sun.netstorage.fm.storade.device.storage.minnow.io.LogicalDiskTokenList;
import com.sun.netstorage.fm.storade.device.storage.minnow.io.PeriDeviceTokenList;
import com.sun.netstorage.fm.storade.device.storage.minnow.io.PortTokenList;
import com.sun.netstorage.fm.storade.device.storage.minnow.util.MinnowCLICommand;
import com.sun.netstorage.fm.storade.device.storage.minnow.util.MinnowCommands;
import com.sun.netstorage.fm.util.LocalizedString;
import java.util.Properties;

public class MinnowXmlReporter
implements MinnowCommands {
    private String hostIP;
    private static int TIMEOUT = 300000;
    private static int RETRY_TIMEOUT = 90000;
    public static final String sccs_id = "@(#)MinnowXmlReporter.java";

    public MinnowXmlReporter(String boxIP) {
        this.hostIP = boxIP;
    }

    public String getSeedInfo() {
        String info = this.getInfo();
        info = info.trim();
        int retry_time = 0;
        while ((info == null || info.length() == 0) && retry_time < 5) {
            ++retry_time;
            try {
                this.wait(5000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            info = this.getInfo();
        }
        return info;
    }

    /*
     * WARNING - void declaration
     */
    public String getInfo() {
        void var1_7;
        String output;
        CommandExec command = null;
        Properties p = new Properties();
        String cliCommand = MinnowCLICommand.getCommand();
        String commandLine = cliCommand + this.hostIP + " show configuration --xml";
        System.out.println("Debug in xml reporter: command line used is: " + commandLine);
        try {
            command = new CommandExec(commandLine);
            command.exec();
            int returnCode = command.getReturnValue(TIMEOUT);
            output = command.getStandardOutput();
            output = output.trim();
            String err = command.getErrorOutput();
            err = err.trim();
            System.out.println("Debug1 in xml reported: Output from show config is :");
            System.out.println("Debug1 end");
            System.out.println("Debug2 in xml reported: Output from show config is :");
            System.out.println(err);
            System.out.println("Debug2 end");
        }
        catch (InterruptedException ie) {
            try {
                command.exec();
                int returnCode = command.getReturnValue(TIMEOUT + RETRY_TIMEOUT);
                output = command.getStandardOutput();
                output = output.trim();
                String err = command.getErrorOutput();
                err = err.trim();
            }
            catch (Exception ex) {
                System.out.println("Show config timeout for ip " + this.hostIP);
                return null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LocalizedString errorString = new LocalizedString(e);
            return e.toString();
        }
        return var1_7;
    }

    public ControllerToken createControllerToken(String input) {
        ControllerToken st = new ControllerToken(input);
        return st;
    }

    public FruTokenList createFruTokenList(String input) {
        FruTokenList ftl = new FruTokenList(input);
        return ftl;
    }

    public DiskTokenList createDiskTokenList(String input) {
        DiskTokenList dtl = new DiskTokenList(input);
        return dtl;
    }

    public ChannelTokenList createChannelTokenList(String input) {
        ChannelTokenList clist = new ChannelTokenList(input);
        return clist;
    }

    public PortTokenList createPortTokenList(String input) {
        PortTokenList ptl = new PortTokenList(input);
        return ptl;
    }

    public PeriDeviceTokenList createPeriDeviceTokenList(String input) {
        PeriDeviceTokenList pdtl = new PeriDeviceTokenList(input);
        return pdtl;
    }

    public LogicalDiskTokenList createLogicalDiskTokenList(String input) {
        LogicalDiskTokenList ldtl = new LogicalDiskTokenList(input);
        return ldtl;
    }
}

