/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.fm.storade.device.storage.minnow.io;

import com.sun.netstorage.fm.storade.agent.util.CommandExec;
import com.sun.netstorage.fm.storade.device.storage.minnow.io.MinnowLoopTestToken;
import com.sun.netstorage.fm.storade.device.storage.minnow.util.MinnowCLICommand;
import com.sun.netstorage.fm.storade.device.storage.minnow.util.MinnowCommands;

public class MinnowLoopTestManager
implements MinnowCommands {
    private String hostIP;
    private String testType;
    private int chanId;
    private static int TIMEOUT = 5000;
    private static int RETRY_TIMEOUT = 90000;
    private MinnowLoopTestToken mtk = null;
    public static final String sccs_id = " ";

    public MinnowLoopTestManager(String boxIP, int test_id, int Channel2) {
        this.hostIP = boxIP;
        this.chanId = Channel2;
        if (test_id == 10) {
            this.testType = "wrbuf";
        } else if (test_id == 11) {
            this.testType = "loopback";
        } else if (test_id == 12) {
            this.testType = "echo";
        }
    }

    public String getDiagStatus() {
        String output;
        CommandExec command = null;
        String cliCommand = MinnowCLICommand.getCommand();
        String commandLine = cliCommand + this.hostIP + " diag status" + " -type " + this.testType + " -chan " + this.chanId;
        try {
            command = new CommandExec(commandLine);
            command.exec();
            int returnCode = command.getReturnValue();
            output = command.getStandardOutput();
            output = output.trim();
            String err = command.getErrorOutput();
            err = err.trim();
        }
        catch (Exception ie) {
            try {
                command.exec();
                int returnCode = command.getReturnValue(TIMEOUT + RETRY_TIMEOUT);
                output = command.getStandardOutput();
                output = output.trim();
                String err = command.getErrorOutput();
                err = err.trim();
            }
            catch (Exception ex) {
                return ex.toString();
            }
        }
        return output;
    }

    public MinnowLoopTestToken getTestStatusToken(String input) {
        this.mtk = new MinnowLoopTestToken(input);
        return this.mtk;
    }

    public boolean getTestState(MinnowLoopTestToken tk) {
        return tk.getTestState();
    }

    public static String getStatus(MinnowLoopTestToken tk) {
        return tk.getStatus();
    }

    public static void main(String[] args) {
        if (args.length != 3) {
            System.err.println("Usage: Java MinnowLoopTestManager <ip> <channel> <payload>");
        }
        System.out.println("args[0] is " + args[0]);
        System.out.println("args[1] is " + args[1]);
        System.out.println("args[2] is " + args[2]);
        MinnowLoopTestManager mtm = new MinnowLoopTestManager(args[0], 11, Integer.parseInt(args[1]));
        String out = mtm.getDiagStatus();
    }
}

