/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.fm.storade.device.storage.minnow.io;

import java.io.IOException;
import java.io.StringReader;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.crimson.tree.XmlDocument;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ControllerToken {
    private String descp;
    private String status;
    private String fwrev;
    private String boot_ver;
    private String name;
    private String id;
    private String primary_sn;
    private String secondary_sn;
    private String cache_size;
    private String cpu;
    private static final String sccs_id = "@(#)ControllerToken.java\t";

    public ControllerToken() {
        this.descp = null;
        this.status = null;
        this.fwrev = null;
        this.boot_ver = null;
        this.name = null;
        this.id = null;
        this.primary_sn = null;
        this.secondary_sn = null;
        this.cache_size = null;
        this.cpu = null;
    }

    public ControllerToken(String descp, String status, String fwrev, String boot_ver, String name, String id, String primary_sn, String secondary_sn, String cache_size, String cpu) {
        this.descp = descp;
        this.status = status;
        this.fwrev = fwrev;
        this.boot_ver = boot_ver;
        this.name = name;
        this.id = id;
        this.primary_sn = primary_sn;
        this.secondary_sn = secondary_sn;
        this.cache_size = cache_size;
        this.cpu = cpu;
    }

    public ControllerToken(String input) {
        Vector<String> tempList = new Vector<String>();
        String output = "";
        try {
            StringTokenizer st = new StringTokenizer(input, "\n");
            while (st.hasMoreTokens()) {
                tempList.add(st.nextToken());
            }
        }
        catch (StringIndexOutOfBoundsException e) {
            e.printStackTrace();
        }
        for (int i = 0; i < tempList.size(); ++i) {
            String tokenline = (String)tempList.get(i);
            if (!tokenline.startsWith("<")) continue;
            output = output + tokenline + " ";
        }
        this.parseXML(output);
    }

    public void parseXML(String xmlReport) {
        XmlDocument doc = null;
        try {
            doc = XmlDocument.createXmlDocument((InputSource)new InputSource(new StringReader(xmlReport)), (boolean)false);
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        Element baseviewNode = doc.getDocumentElement();
        NamedNodeMap attr = baseviewNode.getAttributes();
        NodeList children = baseviewNode.getChildNodes();
        NodeList children2 = null;
        for (int j = 0; j < children.getLength(); ++j) {
            Node cnode = children.item(j);
            if (!"raidsystem".equals(cnode.getNodeName())) continue;
            children2 = cnode.getChildNodes();
        }
        for (int m = 0; m < children2.getLength(); ++m) {
            Node ccnode = children2.item(m);
            Node ccChildNode = ccnode.getFirstChild();
            String setvalue = null;
            if (ccChildNode != null) {
                setvalue = ccChildNode.getNodeValue();
            }
            if (ccnode.getNodeType() == 3) {
                // empty if block
            }
            if ("name".equals(ccnode.getNodeName())) {
                this.descp = setvalue;
                continue;
            }
            if ("status".equals(ccnode.getNodeName())) {
                this.status = setvalue;
                continue;
            }
            if ("firmware_version".equals(ccnode.getNodeName())) {
                this.fwrev = setvalue;
                continue;
            }
            if ("bootrecord_revision".equals(ccnode.getNodeName())) {
                this.boot_ver = setvalue;
                continue;
            }
            if ("controller_name".equals(ccnode.getNodeName())) {
                this.name = setvalue;
                continue;
            }
            if ("unique_id".equals(ccnode.getNodeName())) {
                this.id = setvalue;
                continue;
            }
            if ("cache_size".equals(ccnode.getNodeName())) {
                this.cache_size = setvalue;
                continue;
            }
            if ("primary_sn".equals(ccnode.getNodeName())) {
                this.primary_sn = setvalue;
                continue;
            }
            if ("secondary_sn".equals(ccnode.getNodeName())) {
                this.secondary_sn = setvalue;
                continue;
            }
            if (!"cpu".equals(ccnode.getNodeName())) continue;
            this.cpu = setvalue;
        }
    }

    public String getDescp() {
        return this.descp;
    }

    public String getStatus() {
        return this.status;
    }

    public String getFwRev() {
        return this.fwrev;
    }

    public String getBootRev() {
        return this.boot_ver;
    }

    public String getName() {
        return this.name;
    }

    public String getID() {
        return this.id;
    }

    public String getPrimarySN() {
        return this.primary_sn;
    }

    public String getSecondarySN() {
        return this.secondary_sn;
    }

    public String getCache() {
        return this.cache_size;
    }

    public String getCpu() {
        return this.cpu;
    }

    public int getNum() {
        int count = 2;
        if (this.primary_sn.equals("N/A") || this.primary_sn.length() == 0) {
            --count;
        }
        if (this.secondary_sn.equals("N/A") || this.secondary_sn.length() == 0) {
            --count;
        }
        return count;
    }
}

