/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.fm.storade.device.storage.dsp;

import com.sun.netstorage.fm.storade.device.storage.dsp.MD5;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URLEncoder;

public class DSPUtil {
    private static boolean logToScreen = true;
    private static String dspIP = "";
    private static String user = "";
    private static String pass = "";
    private static String toSend = "";
    private static String toReturn = "";
    private static Socket socket;
    private static InetAddress addr;
    private static int port;
    private static String nonce;
    private static String dspPort;
    private static String targetIP;

    public DSPUtil(String dspIP) {
        dspIP = dspIP.trim();
        user = "root";
        pass = "sun1";
        try {
            addr = InetAddress.getByName(dspIP);
        }
        catch (Exception e) {
            System.out.println(e);
        }
        DSPUtil.doLogin();
        System.out.println("\n --- Authentication complete, inactivity timeout is 120 seconds ---");
    }

    public String doPost(String path, String[] commands, String[] values) {
        PrintWriter topp = null;
        boolean header = true;
        String toSend = "";
        String toReturn = "";
        try {
            String line;
            String tempStr = path;
            tempStr = tempStr.trim();
            FileOutputStream out = new FileOutputStream("/tmp" + tempStr);
            topp = new PrintWriter(out);
            socket = new Socket(addr, port);
            BufferedWriter wr = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream(), "UTF8"));
            BufferedReader rd = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            toSend = "";
            for (int i = 0; i < commands.length; ++i) {
                if (i > 0) {
                    toSend = toSend + "&";
                }
                toSend = toSend + URLEncoder.encode(commands[i]) + "=" + URLEncoder.encode(values[i], "UTF-8");
            }
            System.out.println("");
            System.out.println("Using this nonce: " + nonce);
            System.out.println("");
            System.out.println("sending this POST data:");
            System.out.println(toSend);
            System.out.println("");
            System.out.println("POST data length:");
            System.out.println(toSend.length());
            System.out.println("");
            wr.write("POST " + path + " HTTP/1.1\r\n");
            wr.write("Content-Length: " + toSend.length() + "\r\n");
            wr.write("Content-Type: application/x-www-form-urlencoded\r\n");
            wr.write("MasE: MasE\r\n");
            wr.write("Cookie: auth=" + nonce + "\r\n");
            wr.write("\r\n");
            wr.write(toSend);
            wr.flush();
            while ((line = rd.readLine()) != null) {
                if (logToScreen) {
                    System.out.println(line);
                }
                if (-1 < line.indexOf("xml version")) {
                    header = false;
                }
                if (header || line.equals("0")) continue;
                toReturn = toReturn + line + "\n";
                topp.println(line);
            }
            wr.close();
            rd.close();
            topp.close();
        }
        catch (Exception e) {
            System.out.println("Something bad happened in doPost, uh-oh\n" + e.toString());
        }
        return toReturn;
    }

    private static void doGet(int doRepeat) {
        PrintWriter topp = null;
        boolean header = true;
        int counter = 1;
        try {
            String tempStr;
            String fileName = DSPUtil.getAnAnswer("Which XML file you want to GET (e.g. \"disks.xml\"): ");
            fileName = fileName.trim();
            if (doRepeat == 0) {
                tempStr = DSPUtil.getAnAnswer("Enter the file name to write to");
                tempStr = tempStr.trim();
            } else {
                tempStr = fileName + counter;
                System.out.println("\n**********************************");
                System.out.print("* You will have to kill this process once it starts - hit enter when you're ready to begin <enter>:");
                try {
                    int temp = System.in.read();
                }
                catch (IOException e) {
                    throw new Exception();
                }
            }
            block4: while (true) {
                String line;
                FileOutputStream out = new FileOutputStream(tempStr);
                topp = new PrintWriter(out);
                socket = new Socket(addr, port);
                BufferedWriter wr = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream(), "UTF8"));
                BufferedReader rd = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                System.out.println("Sending this GET request: GET /" + fileName + " HTTP/1.1\r\n\r\n");
                wr.write("GET /" + fileName + " HTTP/1.1\r\n\r\n");
                wr.flush();
                while ((line = rd.readLine()) != null) {
                    if (logToScreen) {
                        System.out.println(line);
                    }
                    if (-1 < line.indexOf("xml version")) {
                        header = false;
                    }
                    if (header || line.equals("0")) continue;
                    topp.println(line);
                }
                wr.close();
                rd.close();
                topp.close();
                if (doRepeat != 0 && counter != 1000) {
                    tempStr = fileName + ++counter;
                    int i = 0;
                    while (true) {
                        if (i >= 10000) continue block4;
                        for (int j = 0; j < 10000; ++j) {
                        }
                        ++i;
                    }
                }
                break;
            }
        }
        catch (Exception e) {
            System.out.println("Something bad happened in doGet, uh-oh\n");
        }
    }

    private static void doLogin() {
        MD5 md5 = new MD5();
        try {
            String line;
            socket = new Socket(addr, port);
            BufferedWriter wr = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream(), "UTF8"));
            BufferedReader rd = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            wr.write("GET / HTTP/1.1\r\n\r\n");
            wr.flush();
            String matchStr = "<input type=\"hidden\" name=\"nonce\" value=";
            while ((line = rd.readLine()) != null) {
                if (-1 >= line.indexOf(matchStr)) continue;
                int temp = line.indexOf(matchStr) + 41;
                nonce = line.substring(temp, temp + 16);
            }
            md5.Init();
            md5.Update(pass);
            String ePass = md5.asHex();
            md5.Init();
            md5.Update(user + ":" + ePass.substring(0, 16) + ":" + nonce);
            String encodedStr = md5.asHex();
            toSend = "encoded=" + user + "%3A" + encodedStr + "&nonce=" + nonce + "&URL=%2F";
            System.out.println("using nonce: " + nonce + " to authenticate with:");
            System.out.println("    " + toSend + "\n");
            wr.close();
            rd.close();
            socket = new Socket(addr, port);
            wr = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream(), "UTF8"));
            rd = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            wr.write("POST / HTTP/1.1\r\n");
            wr.write("Content-Length: " + toSend.length() + "\r\n");
            wr.write("Content-Type: application/x-www-form-urlencoded\r\n");
            wr.write("MasE: MasE\r\n");
            wr.write("Cookie: auth=" + nonce + "\r\n");
            wr.write("\r\n");
            wr.write(toSend);
            wr.flush();
            while ((line = rd.readLine()) != null) {
            }
            wr.close();
            rd.close();
        }
        catch (Exception e) {
            System.out.println("Something bad happened in doLogin, uh-oh\n");
        }
    }

    private static int mainLoop() throws Exception {
        int temp;
        try {
            System.out.println("**********************************");
            System.out.println("* Main Menu");
            System.out.println("*");
            System.out.println("*         Current selections:");
            System.out.println("*");
            System.out.println("*           Log to Screen: " + logToScreen);
            System.out.println("*");
            System.out.println("* Please make a choice");
            System.out.println("*");
            System.out.println("* 1.) Perform a single HTTP GET");
            System.out.println("* 2.) Perform repeated HTTP GETs");
            System.out.println("* 3.) Perform a single HTTP POST");
            System.out.println("* 4.) Toggle logging to the screen");
            System.out.println("* 5.) Quit");
            System.out.println("*");
            System.out.print("*  ?> ");
            temp = System.in.read();
            temp -= 48;
            try {
                int bad;
                while ((bad = System.in.read()) != -1 && bad != 10) {
                }
            }
            catch (IOException e) {
                throw new Exception();
            }
        }
        catch (Exception e) {
            throw new Exception();
        }
        return temp;
    }

    private static String getAnAnswer(String toAsk) throws Exception {
        StringBuffer sb = new StringBuffer();
        System.out.println("**********************************");
        System.out.print("* " + toAsk + ": ");
        try {
            int temp;
            while ((temp = System.in.read()) != -1 && temp != 10) {
                sb.append((char)temp);
            }
        }
        catch (IOException e) {
            throw new Exception();
        }
        return sb.toString();
    }

    static {
        port = 80;
        nonce = "";
        dspPort = "";
        targetIP = "";
    }
}

