/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.fm.storade.agent.util;

import com.sun.netstorage.fm.storade.service.StoradeException;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class XmlElement {
    private Node element;
    public static final String _SOURCE_REVISION = "$Revision: 1.1 $";

    public XmlElement(Node element) {
        this.element = element;
    }

    public XmlElement(File document) throws StoradeException {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setValidating(false);
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document xmlDoc = db.parse(new InputSource(new FileReader(document)));
            this.element = xmlDoc.getDocumentElement();
        }
        catch (Exception e) {
            throw new StoradeException("invalid.document", (Throwable)e);
        }
    }

    public XmlElement(Reader document) throws StoradeException {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setValidating(false);
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document xmlDoc = db.parse(new InputSource(document));
            this.element = xmlDoc.getDocumentElement();
        }
        catch (Exception e) {
            throw new StoradeException("invalid.document", (Throwable)e);
        }
    }

    public XmlElement(String document) throws StoradeException {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setValidating(false);
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document xmlDoc = db.parse(new InputSource(new StringReader(document)));
            this.element = xmlDoc.getDocumentElement();
        }
        catch (Exception e) {
            throw new StoradeException("invalid.document", (Throwable)e);
        }
    }

    public Node getElementNode() {
        return this.element;
    }

    public String getName() {
        return this.element.getNodeName();
    }

    public String getStringValue() {
        return XmlElement.getStringValue(this.element);
    }

    public int getIntegerValue(int defaultValue) {
        try {
            return Integer.parseInt(this.getStringValue());
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public String getAttribute(String name) {
        try {
            return this.element.getAttributes().getNamedItem(name).getNodeValue();
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean getBooleanAttribute(String name) {
        String attr = this.getAttribute(name);
        return "true".equals(attr);
    }

    public List getList(String name) {
        LinkedList<XmlElement> list = new LinkedList<XmlElement>();
        NodeList children = this.element.getChildNodes();
        if (children != null) {
            for (int i = 0; i < children.getLength(); ++i) {
                Node cnode = children.item(i);
                if (cnode.getNodeType() != 1) continue;
                if (name == null) {
                    list.add(new XmlElement(cnode));
                    continue;
                }
                if (!name.equals(cnode.getNodeName())) continue;
                list.add(new XmlElement(cnode));
            }
        }
        return list;
    }

    public XmlElement getElement(String name) {
        NodeList children = this.element.getChildNodes();
        if (children != null) {
            for (int i = 0; i < children.getLength(); ++i) {
                Node cnode = children.item(i);
                if (cnode.getNodeType() != 1 || !name.equals(cnode.getNodeName())) continue;
                return new XmlElement(cnode);
            }
        }
        return null;
    }

    public XmlElement getElement(String name, String keyName, String keyValue) {
        try {
            NodeList children = this.element.getChildNodes();
            if (children != null) {
                for (int i = 0; i < children.getLength(); ++i) {
                    Node cnode = children.item(i);
                    if (cnode.getNodeType() != 1 || !name.equals(cnode.getNodeName()) || !keyValue.equals(XmlElement.getAttribute(cnode, keyName))) continue;
                    return new XmlElement(cnode);
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return null;
    }

    public Map getKeyedValues(String name, String key) {
        HashMap<String, XmlElement> map = new HashMap<String, XmlElement>();
        NodeList children = this.element.getChildNodes();
        if (children != null) {
            for (int i = 0; i < children.getLength(); ++i) {
                Node cnode = children.item(i);
                if (cnode.getNodeType() != 1 || !name.equals(cnode.getNodeName())) continue;
                XmlElement celement = new XmlElement(cnode);
                String ckey = celement.getAttribute(key);
                map.put(ckey, celement);
            }
        }
        return map;
    }

    public Properties getProperties(String name, String key) {
        Properties p = new Properties();
        NodeList children = this.element.getChildNodes();
        if (children != null) {
            for (int i = 0; i < children.getLength(); ++i) {
                Node cnode = children.item(i);
                if (cnode.getNodeType() != 1 || !name.equals(cnode.getNodeName())) continue;
                p.setProperty(XmlElement.getAttribute(cnode, key), XmlElement.getStringValue(cnode));
            }
        }
        return p;
    }

    public String getStringValue(String name) {
        NodeList children = this.element.getChildNodes();
        if (children != null) {
            for (int i = 0; i < children.getLength(); ++i) {
                Node cnode = children.item(i);
                if (cnode.getNodeType() != 1 || !name.equals(cnode.getNodeName())) continue;
                return XmlElement.getStringValue(cnode);
            }
        }
        return null;
    }

    public Map getStringValues() {
        HashMap<String, String> map = new HashMap<String, String>();
        NodeList children = this.element.getChildNodes();
        if (children != null) {
            for (int j = 0; j < children.getLength(); ++j) {
                Node cnode = children.item(j);
                if (cnode.getNodeType() != 1) continue;
                String name = cnode.getNodeName();
                String value = XmlElement.getStringValue(cnode);
                if (value == null) continue;
                map.put(name, value);
            }
        }
        return map;
    }

    public String toString() {
        return this.element.toString();
    }

    private static String getStringValue(Node node) {
        try {
            StringBuffer sb = new StringBuffer();
            NodeList children = node.getChildNodes();
            if (children != null) {
                for (int i = 0; i < children.getLength(); ++i) {
                    Node cnode = children.item(i);
                    if (cnode.getNodeType() != 3 && cnode.getNodeType() != 4) continue;
                    sb.append(cnode.getNodeValue());
                }
            }
            return sb.toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    private static String getAttribute(Node node, String name) {
        try {
            return node.getAttributes().getNamedItem(name).getNodeValue();
        }
        catch (Exception e) {
            return null;
        }
    }
}

