/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.fm.storade.agent.jmx;

import com.sun.jdmk.comm.CommunicationException;
import com.sun.jdmk.comm.CommunicatorServer;
import com.sun.netstorage.fm.storade.agent.command.CommandHandler;
import com.sun.netstorage.fm.storade.agent.command.ThreadPool;
import com.sun.netstorage.fm.storade.agent.command.xml.XMLCommandHandler;
import com.sun.netstorage.fm.storade.util.Environment;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.logging.Level;
import java.util.logging.Logger;

public class XMLCommunicatorServer
extends CommunicatorServer {
    private int workers;
    private long lastBindTime;
    private long lastProcessTime;
    private long lastReceiveTime;
    private CommandHandler handler;
    private ServerSocket ipserver;
    private Throwable error;
    private Socket connection;
    private String user;
    private String credential;
    private static Logger logger = Logger.getLogger("com.sun.netstorage.fm.storade.agent.jmx");
    public static final String _SOURCE_REVISION = "$Revision: 1.5 $";

    public XMLCommunicatorServer() {
        super(2);
        this.setPort(Environment.getSOAPPort());
    }

    public XMLCommunicatorServer(int port) {
        super(2);
        this.setPort(port);
    }

    public XMLCommunicatorServer(int port, String user, String credential) {
        super(2);
        this.setPort(port);
        this.user = user;
        this.credential = credential;
    }

    protected void doBind() throws CommunicationException {
        this.handler = new XMLCommandHandler(this.getMBeanServer(), this.user, this.credential);
        this.lastBindTime = System.currentTimeMillis();
        try {
            this.ipserver = new ServerSocket(this.getPort());
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Error starting service.", e);
            throw new CommunicationException((Throwable)e);
        }
    }

    protected void doError(Exception e) {
        e.printStackTrace();
        this.error = e;
    }

    protected void doProcess() throws CommunicationException {
        this.lastProcessTime = System.currentTimeMillis();
        try {
            ThreadPool tp = ThreadPool.getThreadPool();
            tp.runJob(new Worker(this.connection));
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Error processing request.", e);
            throw new CommunicationException((Throwable)e);
        }
    }

    protected void doReceive() throws CommunicationException {
        this.lastReceiveTime = System.currentTimeMillis();
        try {
            this.connection = this.ipserver.accept();
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Error accepting request.", e);
            throw new CommunicationException((Throwable)e);
        }
    }

    protected void doUnbind() throws CommunicationException {
        try {
            if (this.ipserver != null) {
                this.ipserver.close();
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Error closing connection.", e);
            throw new CommunicationException((Throwable)e);
        }
    }

    public String getProtocol() {
        return "HTTP/XML";
    }

    public long getLastBindTime() {
        return this.lastBindTime;
    }

    public long getLastProcessTime() {
        return this.lastProcessTime;
    }

    public long getLastReceiveTime() {
        return this.lastReceiveTime;
    }

    public int getRunningThreads() {
        return this.workers;
    }

    public class Worker
    implements Runnable {
        Socket s;

        Worker(Socket s) {
            this.s = s;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                XMLCommunicatorServer.this.workers++;
                XMLCommunicatorServer.this.handler.handleRequest(this.s);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Error processing request.", e);
            }
            finally {
                XMLCommunicatorServer.this.workers--;
            }
        }
    }
}

