/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.fm.storade.agent.command.xml;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLUtil {
    public static final String _SOURCE_REVISION = "$Id: XMLUtil.java,v 1.4 2005/01/18 16:28:28 jkremer Exp $";

    public static void encodeXML(StringBuffer sb, String name, String value) {
        if (value == null) {
            return;
        }
        sb.append("<");
        sb.append(name);
        sb.append(">");
        XMLUtil.encodeXML(value, sb);
        sb.append("</");
        sb.append(name);
        sb.append(">\n");
    }

    public static void encodeXML(StringBuffer sb, String name, Date value) {
        if (value == null) {
            return;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("MMM dd HH:mm:ss");
        XMLUtil.encodeXML(sb, name, sdf.format(value));
    }

    public static String encodeToXML(String in) {
        if (in == null) {
            return null;
        }
        int len = in.length();
        StringBuffer sb = new StringBuffer(len);
        XMLUtil.encodeXML(in, sb);
        return sb.toString();
    }

    public static void encodeXML(String in, StringBuffer sb) {
        if (in == null) {
            return;
        }
        int len = in.length();
        block7: for (int i = 0; i < len; ++i) {
            char ch = in.charAt(i);
            switch (ch) {
                case '<': {
                    sb.append("&lt;");
                    continue block7;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block7;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block7;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    sb.append("&apos;");
                    continue block7;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
    }

    public static Node getNode(String document) throws SAXException, ParserConfigurationException, IOException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setValidating(false);
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document xmlDoc = db.parse(new InputSource(new StringReader(document)));
        return xmlDoc.getDocumentElement();
    }

    public static Node getNode(Reader document) throws SAXException, ParserConfigurationException, IOException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setValidating(false);
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document xmlDoc = db.parse(new InputSource(document));
        return xmlDoc.getDocumentElement();
    }

    public static String getCdata(Node node) {
        StringBuffer sb = new StringBuffer();
        NodeList children = node.getChildNodes();
        if (children != null) {
            for (int j = 0; j < children.getLength(); ++j) {
                Node cnode = children.item(j);
                if (cnode.getNodeType() != 3 && cnode.getNodeType() != 4) continue;
                sb.append(cnode.getNodeValue());
            }
        }
        return sb.toString();
    }

    public static String getAttribute(NamedNodeMap nnm, String name) {
        Node n = nnm.getNamedItem(name);
        if (n != null) {
            return n.getNodeValue();
        }
        return null;
    }

    public static String getAttribute(Node node, String name) {
        return XMLUtil.getAttribute(node.getAttributes(), name);
    }
}

