/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.fm.storade.agent.catalog;

import com.sun.netstorage.fm.storade.agent.catalog.Catalog;
import com.sun.netstorage.fm.storade.agent.catalog.ModelClass;
import com.sun.netstorage.fm.storade.agent.util.XmlElement;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class Model {
    private String type;
    private XmlElement model;
    private Map classMap = new HashMap();
    public static final String _SOURCE_REVISION = "$Revision: 1.3 $";

    public Model(String type) {
        this.type = type;
        this.init();
    }

    public Model(XmlElement model) {
        this.model = model;
        this.type = model.getAttribute("type");
        this.parseModel();
    }

    public ModelClass getModelClass(String name) {
        return new ModelClass(this.model.getElement("class", "name", name));
    }

    public ModelClass[] getModelClasses() {
        ModelClass[] mods = new ModelClass[this.classMap.size()];
        this.classMap.entrySet().toArray(mods);
        return mods;
    }

    private void init() {
        try {
            File file = new File(Catalog.getCatalogDir(this.type), "model.xml");
            this.model = new XmlElement(file);
            this.parseModel();
        }
        catch (Exception e) {
            this.model = null;
        }
    }

    private void parseModel() {
        List clist = this.model.getList("class");
        Iterator iter = clist.iterator();
        while (iter.hasNext()) {
            ModelClass mc = new ModelClass((XmlElement)iter.next());
            this.classMap.put(mc.getName(), mc);
        }
    }

    private void doIncludeModel(XmlElement inc) {
        String fname = inc.getAttribute("file");
        if (fname == null) {
            return;
        }
        File incFile = new File(Catalog.getCommonDir(this.type), fname);
        if (!incFile.exists() && !(incFile = new File(Catalog.getCatalogDir(this.type), fname)).exists()) {
            return;
        }
        try {
            String line;
            FileReader in = new FileReader(incFile);
            BufferedReader br = new BufferedReader(in);
            StringBuffer sb = new StringBuffer();
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
            Properties args = inc.getProperties("value", "name");
            Iterator<Object> iter = args.keySet().iterator();
            String incDoc = sb.toString();
            while (iter.hasNext()) {
                String name = (String)iter.next();
                String val = args.getProperty(name);
                incDoc = incDoc.replaceAll(name, val);
            }
            Model imodel = new Model(new XmlElement(incDoc));
            ModelClass[] icls = imodel.getModelClasses();
            for (int i = 0; i < icls.length; ++i) {
                this.mergeClass(icls[i]);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private void mergeClass(ModelClass mc) {
        ModelClass oc = (ModelClass)this.classMap.get(mc.getName());
        if (oc == null) {
            this.classMap.put(mc.getName(), mc);
        }
        oc.extendClass(mc);
    }
}

